/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.io.IOException;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.ModelState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import smartin.miapi.Miapi;

@JsonAdapter(value=TransformJsonAdapter.class)
public class Transform {
    public String origin;
    public final Vector3f rotation;
    public final Vector3f translation;
    public final Vector3f scale;
    public static final Transform IDENTITY = new Transform(new Vector3f(), new Vector3f(), new Vector3f(1.0f, 1.0f, 1.0f));

    public Transform(Vector3f rotation, Vector3f translation, Vector3f scale) {
        this.rotation = new Vector3f((Vector3fc)rotation);
        this.translation = new Vector3f((Vector3fc)translation);
        this.scale = new Vector3f((Vector3fc)scale);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Transform(ItemTransform transformation) {
        this.rotation = new Vector3f((Vector3fc)transformation.f_111755_);
        this.translation = new Vector3f((Vector3fc)transformation.f_111756_);
        this.scale = new Vector3f((Vector3fc)transformation.f_111757_);
    }

    public Transform merge(Transform child) {
        return Transform.merge(this, child);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemTransform toTransformation() {
        return new ItemTransform(new Vector3f((Vector3fc)this.rotation), new Vector3f((Vector3fc)this.translation), new Vector3f((Vector3fc)this.scale));
    }

    public static Transform merge(Transform parent, Transform originalChild) {
        Transform child = originalChild.copy();
        parent = parent.copy();
        Matrix4f parentMatrix = parent.toMatrix();
        Matrix4f childMatrix = child.toMatrix();
        childMatrix.mul((Matrix4fc)parentMatrix);
        Transform merged = Transform.fromMatrix(childMatrix);
        float rotation = merged.rotation.y;
        if (Float.isNaN(rotation)) {
            Miapi.LOGGER.info("FAILURE " + rotation);
        }
        return merged;
    }

    public static void applyPosition(PoseStack matrixStack, Matrix4f matrix4f) {
        matrixStack.m_252931_(matrix4f);
        matrixStack.m_85850_().m_252943_().mul((Matrix3fc)matrix4f.get3x3(new Matrix3f()));
    }

    public static void applyPosition(PoseStack matrixStack, Transform transform) {
        Transform.applyPosition(matrixStack, transform.toMatrix());
    }

    public void applyPosition(PoseStack matrixStack) {
        Transform.applyPosition(matrixStack, this);
    }

    public Matrix4f toMatrix() {
        Matrix4f translationMatrix = new Matrix4f().translate((Vector3fc)this.translation);
        Quaternionf a = new Quaternionf((Quaternionfc)Axis.f_252529_.m_252977_(this.rotation.x));
        Quaternionf b = new Quaternionf((Quaternionfc)Axis.f_252436_.m_252977_(this.rotation.y));
        Quaternionf c = new Quaternionf((Quaternionfc)Axis.f_252403_.m_252977_(this.rotation.z));
        Quaternionf d = a.add((Quaternionfc)b).add((Quaternionfc)c);
        Matrix4f rotationMatrix = new Matrix4f().rotateX((float)Math.toRadians(this.rotation.x)).rotateY((float)Math.toRadians(this.rotation.y)).rotateZ((float)Math.toRadians(this.rotation.z));
        Matrix4f scaleMatrix = new Matrix4f().scale((Vector3fc)this.scale);
        return new Matrix4f().mul((Matrix4fc)translationMatrix).mul((Matrix4fc)rotationMatrix).mul((Matrix4fc)scaleMatrix);
    }

    public static Transform fromMatrix(Matrix4f matrix) {
        Vector3f translation = new Vector3f();
        matrix.getTranslation(translation);
        Matrix4f rotationMatrix = new Matrix4f((Matrix4fc)matrix);
        rotationMatrix.normalize3x3();
        Vector3f rotation = rotationMatrix.getEulerAnglesXYZ(new Vector3f());
        rotation.x = (float)Math.toDegrees(rotation.x());
        rotation.y = (float)Math.toDegrees(rotation.y());
        rotation.z = (float)Math.toDegrees(rotation.z());
        Vector3f scale = matrix.getScale(new Vector3f());
        return new Transform(rotation, translation, scale);
    }

    public Transform copy() {
        Transform copy = new Transform(this.rotation != null ? new Vector3f((Vector3fc)this.rotation) : new Vector3f(0.0f, 0.0f, 0.0f), this.translation != null ? new Vector3f((Vector3fc)this.translation) : new Vector3f(0.0f, 0.0f, 0.0f), this.scale != null ? new Vector3f((Vector3fc)this.scale) : new Vector3f(1.0f, 1.0f, 1.0f));
        copy.origin = this.origin;
        return copy;
    }

    public static Transform repair(Transform transformation) {
        Vector3f parentScale;
        Vector3f parentTranslation;
        Vector3f parentRotation = transformation.rotation;
        if (parentRotation == null) {
            parentRotation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if ((parentTranslation = transformation.translation) == null) {
            parentTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if ((parentScale = transformation.scale) == null) {
            parentScale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        return new Transform(new Vector3f((Vector3fc)parentRotation), new Vector3f((Vector3fc)parentTranslation), new Vector3f((Vector3fc)parentScale)).withOrigin(transformation.origin);
    }

    public Transform withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public static Transform toModelTransformation(Transform transformation) {
        Transform transform = Transform.repair(transformation);
        transform.translation.mul(0.0625f);
        return transform;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Transformation toAffineTransformation() {
        Transform transform = this.copy();
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotationXYZ((float)Math.toRadians(this.rotation.x), (float)Math.toRadians(this.rotation.y), (float)Math.toRadians(this.rotation.z));
        Vector3f translationVector = new Vector3f((Vector3fc)transform.translation);
        Vector3f scaleVector = new Vector3f((Vector3fc)transform.scale);
        return new Transformation(translationVector, quaternionf, scaleVector, quaternionf);
    }

    public int[] rotateVertexData(int[] vertexData) {
        for (int i = 0; i < vertexData.length; i += 8) {
            float x = Float.intBitsToFloat(vertexData[i]);
            float y = Float.intBitsToFloat(vertexData[i + 1]);
            float z = Float.intBitsToFloat(vertexData[i + 2]);
            Vector4f position = new Vector4f(x, y, z, 1.0f);
            Vector4f transformedPosition = this.toMatrix().transform(position);
            float transformedX = transformedPosition.x;
            float transformedY = transformedPosition.y;
            float transformedZ = transformedPosition.z;
            vertexData[i] = Float.floatToIntBits(transformedX);
            vertexData[i + 1] = Float.floatToIntBits(transformedY);
            vertexData[i + 2] = Float.floatToIntBits(transformedZ);
        }
        return vertexData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelState toModelBakeSettings() {
        Transform transform = Transform.toModelTransformation(this);
        final Transformation affineTransformation = transform.toAffineTransformation();
        return new ModelState(){

            public Transformation m_6189_() {
                return affineTransformation;
            }

            public boolean m_7538_() {
                return false;
            }
        };
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Transform transformation = (Transform)o;
        return this.rotation.equals((Object)transformation.rotation) && this.scale.equals((Object)transformation.scale) && this.translation.equals((Object)transformation.translation);
    }

    public int hashCode() {
        int i = this.rotation.hashCode();
        i = 31 * i + this.translation.hashCode();
        i = 31 * i + this.scale.hashCode();
        return i;
    }

    public static class TransformJsonAdapter
    extends TypeAdapter<Transform> {
        public void write(JsonWriter jsonWriter, Transform transform) throws IOException {
            jsonWriter.beginObject();
            jsonWriter.name("origin").value(transform.origin);
            this.writeVector3f(jsonWriter, "rotation", transform.rotation);
            this.writeVector3f(jsonWriter, "translation", transform.translation);
            this.writeVector3f(jsonWriter, "scale", transform.scale);
            jsonWriter.endObject();
        }

        public Transform read(JsonReader jsonReader) throws IOException {
            Vector3f rotation = null;
            Vector3f translation = null;
            Vector3f scale = null;
            String origin = null;
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if ("origin".equals(name)) {
                    origin = jsonReader.nextString();
                    continue;
                }
                if ("rotation".equals(name)) {
                    rotation = this.readVector3f(jsonReader);
                    continue;
                }
                if ("translation".equals(name)) {
                    translation = this.readVector3f(jsonReader);
                    continue;
                }
                if ("scale".equals(name)) {
                    scale = this.readVector3f(jsonReader);
                    continue;
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            if (rotation == null) {
                rotation = new Vector3f();
            }
            if (translation == null) {
                translation = new Vector3f();
            }
            if (scale == null) {
                scale = new Vector3f();
            }
            Transform transform = new Transform(rotation, translation, scale);
            transform.origin = origin;
            return transform;
        }

        private void writeVector3f(JsonWriter jsonWriter, String name, Vector3f vector3f) throws IOException {
            jsonWriter.name(name);
            jsonWriter.beginArray();
            jsonWriter.value(vector3f.x);
            jsonWriter.value(vector3f.y);
            jsonWriter.value(vector3f.z);
            jsonWriter.endArray();
        }

        private Vector3f readVector3f(JsonReader jsonReader) throws IOException {
            Vector3f vector3f = new Vector3f();
            if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                jsonReader.beginArray();
                vector3f.x = (float)jsonReader.nextDouble();
                vector3f.y = (float)jsonReader.nextDouble();
                vector3f.z = (float)jsonReader.nextDouble();
                jsonReader.endArray();
            } else if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String propName = jsonReader.nextName();
                    if ("x".equals(propName)) {
                        vector3f.x = (float)jsonReader.nextDouble();
                        continue;
                    }
                    if ("y".equals(propName)) {
                        vector3f.y = (float)jsonReader.nextDouble();
                        continue;
                    }
                    if (!"z".equals(propName)) continue;
                    vector3f.z = (float)jsonReader.nextDouble();
                }
                jsonReader.endObject();
            }
            return vector3f;
        }
    }
}

