/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class PropertyResolver {
    public static List<Tuple<ResourceLocation, PropertyProvider>> registry = Collections.synchronizedList(new ArrayList());

    public static void resolve(ItemModule.ModuleInstance moduleInstance) {
        moduleInstance.allSubModules().forEach(instance -> {
            if (instance.rawProperties == null) {
                instance.rawProperties = new ConcurrentHashMap<ModuleProperty, JsonElement>();
            }
        });
        registry.forEach(pair -> {
            PropertyProvider propertyProvider = (PropertyProvider)pair.m_14419_();
            moduleInstance.allSubModules().forEach(instance -> {
                if (instance.rawProperties == null) {
                    instance.rawProperties = new ConcurrentHashMap<ModuleProperty, JsonElement>();
                }
                instance.rawProperties.putAll(propertyProvider.resolve((ItemModule.ModuleInstance)instance, instance.rawProperties));
            });
        });
    }

    public static PropertyProvider register(ResourceLocation identifier, PropertyProvider propertyProvider, Collection<ResourceLocation> before) {
        Tuple entry = new Tuple((Object)identifier, (Object)propertyProvider);
        registry.removeIf(pair -> ((ResourceLocation)pair.m_14418_()).equals((Object)identifier));
        int index = 0;
        for (Tuple<ResourceLocation, PropertyProvider> pair2 : registry) {
            if (before.contains(pair2.m_14418_())) {
                registry.add(index, (Tuple<ResourceLocation, PropertyProvider>)entry);
                return propertyProvider;
            }
            ++index;
        }
        registry.add((Tuple<ResourceLocation, PropertyProvider>)entry);
        return propertyProvider;
    }

    public static PropertyProvider register(ResourceLocation identifier, PropertyProvider propertyProvider) {
        registry.add((Tuple<ResourceLocation, PropertyProvider>)new Tuple((Object)identifier, (Object)propertyProvider));
        return propertyProvider;
    }

    public static PropertyProvider register(String identifier, PropertyProvider propertyProvider) {
        return PropertyResolver.register(Miapi.MiapiIdentifier(identifier), propertyProvider);
    }

    public static Map<ModuleProperty, JsonElement> merge(Map<ModuleProperty, JsonElement> old, Map<ModuleProperty, JsonElement> toMerge, MergeType mergeType) {
        toMerge.forEach((property, element) -> {
            if (old.containsKey(property)) {
                old.put((ModuleProperty)property, property.merge((JsonElement)old.get(property), (JsonElement)element, mergeType));
            } else {
                old.put((ModuleProperty)property, (JsonElement)element);
            }
        });
        return old;
    }

    public static interface PropertyProvider {
        public Map<ModuleProperty, JsonElement> resolve(ItemModule.ModuleInstance var1, Map<ModuleProperty, JsonElement> var2);
    }
}

