/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.mixin.LivingEntityAccessor;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    private float storedValue;
    private DamageSource storedDamageSource;
    private MiapiEvents.LivingHurtEvent lastEvent;

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void miapi$damageEvent(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        MiapiEvents.LivingHurtEvent livingHurtEvent = new MiapiEvents.LivingHurtEvent((LivingEntity)this, source, amount);
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player entity2 = (Player)entity;
            livingHurtEvent.isCritical = this.hasCrited(entity2, (LivingEntity)this);
        }
        if ((entity = source.m_7639_()) instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
        }
        this.lastEvent = livingHurtEvent;
        this.storedValue = livingHurtEvent.amount;
        this.storedDamageSource = livingHurtEvent.damageSource;
    }

    @ModifyVariable(method={"modifyAppliedDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"}, at=@At(value="HEAD"), ordinal=0)
    private float miapi$modiyAppliedDamageEvent(float amount) {
        MiapiEvents.LivingHurtEvent livingHurtEvent = new MiapiEvents.LivingHurtEvent((LivingEntity)this, this.storedDamageSource, amount);
        if (this.storedDamageSource != null) {
            Entity entity = this.storedDamageSource.m_7639_();
            if (entity instanceof Player) {
                Player entity2 = (Player)entity;
                livingHurtEvent.isCritical = this.hasCrited(entity2, (LivingEntity)this);
            }
            if ((entity = this.storedDamageSource.m_7639_()) instanceof Arrow) {
                Arrow arrow = (Arrow)entity;
            }
        }
        ((MiapiEvents.LivingHurt)MiapiEvents.LIVING_HURT_AFTER_ARMOR.invoker()).hurt(livingHurtEvent);
        return livingHurtEvent.amount;
    }

    @Unique
    private boolean hasCrited(Player attacker, LivingEntity defender) {
        return Boolean.TRUE.equals(AttributeRegistry.hasCrittedLast.putIfAbsent(attacker, false));
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void miapi$damageEventAfter(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        float lastDamageTaken = ((LivingEntityAccessor)livingEntity).getLastDamageTaken();
        MiapiEvents.LivingHurtEvent livingHurtEvent = new MiapiEvents.LivingHurtEvent((LivingEntity)this, source, lastDamageTaken);
        livingHurtEvent.isCritical = this.lastEvent.isCritical;
        ((MiapiEvents.LivingHurt)MiapiEvents.LIVING_HURT_AFTER.invoker()).hurt(livingHurtEvent);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0)
    private float miapi$damageEventValue(float value) {
        return this.storedValue;
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0)
    private DamageSource miapi$damageEventSource(DamageSource value) {
        return this.storedDamageSource;
    }
}

