/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge.compat.pmmo;

import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.fml.LogicalSide;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.forge.mixin.AutoItemAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.registries.RegistryInventory;

public class ToolStats {
    public static void setup() {
        ReloadEvents.END.subscribe(ToolStats::register);
    }

    public static void register(boolean isClient) {
        RegistryInventory.modularItems.addCallback(item -> {
            ResourceLocation itemID = RegistryInventory.modularItems.getId((Item)item);
            if (item instanceof ArmorItem || item instanceof ElytraItem) {
                ToolStats.setupForItem(itemID, ReqType.WEAR, false, isClient);
            } else {
                ToolStats.setupForItem(itemID, ReqType.TOOL, false, isClient);
                ToolStats.setupForItem(itemID, ReqType.WEAPON, true, isClient);
            }
        });
    }

    public static void registerItemRequirementTooltipData(ResourceLocation res, ReqType reqType, boolean isClient, Function<ItemStack, Map<String, Integer>> func) {
        if (isClient) {
            Core.get((LogicalSide)LogicalSide.CLIENT).getTooltipRegistry().registerItemRequirementTooltipData(res, reqType, func);
        } else {
            Core.get((LogicalSide)LogicalSide.SERVER).getTooltipRegistry().registerItemRequirementTooltipData(res, reqType, func);
        }
    }

    private static void setupForItem(ResourceLocation identifier, ReqType tool, boolean isWeapon, boolean isClient) {
        ToolStats.registerItemRequirementTooltipData(identifier, tool, isClient, stack -> {
            HashMap<String, Integer> outMap = new HashMap<String, Integer>();
            try {
                if (stack.m_41720_() instanceof SwordItem) {
                    outMap.put("combat", (int)ToolStats.getUtensilAttributes(AutoValueConfig.UtensilTypes.SWORD, stack, true));
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.SWORD, tool, stack, true));
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.SWORD, tool, stack, false));
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.AXE, tool, stack, true));
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.AXE, tool, stack, false));
                } else if (stack.m_41720_() instanceof AxeItem) {
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.AXE, tool, stack, isWeapon));
                } else if (stack.m_41720_() instanceof PickaxeItem) {
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, tool, stack, isWeapon));
                } else if (stack.m_41720_() instanceof ShovelItem) {
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, tool, stack, isWeapon));
                } else if (stack.m_41720_() instanceof HoeItem) {
                    outMap.putAll(AutoItemAccessor.callGetUtensilData(AutoValueConfig.UtensilTypes.HOE, tool, stack, isWeapon));
                } else if (stack.m_41720_() instanceof ArmorItem && tool == ReqType.WEAR) {
                    outMap.putAll(AutoItemAccessor.callGetWearableData(tool, stack, true));
                } else if (stack.m_41720_() instanceof ElytraItem && tool == ReqType.WEAR) {
                    outMap.putAll(AutoItemAccessor.callGetWearableData(tool, stack, true));
                } else {
                    outMap.put("combat", (int)ToolStats.getUtensilAttributes(AutoValueConfig.UtensilTypes.SWORD, stack, true));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return outMap;
        });
    }

    private static double getUtensilAttributes(AutoValueConfig.UtensilTypes type, ItemStack stack, boolean asWeapon) {
        double baseDurability = AutoItemAccessor.callGetDurability(stack);
        double baseTier = MiningLevelProperty.getMiningLevel("sword", stack);
        double baseDamage = asWeapon ? AutoItemAccessor.callGetDamage(stack) : 0.0;
        double baseAtkSpeed = asWeapon ? AutoItemAccessor.callGetAttackSpeed(stack) : 0.0;
        double baseDigSpeed = 15.0;
        double durMultiplier = AutoValueConfig.getUtensilAttribute((AutoValueConfig.UtensilTypes)type, (AutoValueConfig.AttributeKey)AutoValueConfig.AttributeKey.DUR);
        double tierMultiplier = AutoValueConfig.getUtensilAttribute((AutoValueConfig.UtensilTypes)type, (AutoValueConfig.AttributeKey)AutoValueConfig.AttributeKey.TIER);
        double dmgMultiplier = asWeapon ? AutoValueConfig.getUtensilAttribute((AutoValueConfig.UtensilTypes)type, (AutoValueConfig.AttributeKey)AutoValueConfig.AttributeKey.DMG) : 0.0;
        double spdMultiplier = asWeapon ? AutoValueConfig.getUtensilAttribute((AutoValueConfig.UtensilTypes)type, (AutoValueConfig.AttributeKey)AutoValueConfig.AttributeKey.SPD) : 0.0;
        double digMultiplier = asWeapon ? 0.0 : AutoValueConfig.getUtensilAttribute((AutoValueConfig.UtensilTypes)type, (AutoValueConfig.AttributeKey)AutoValueConfig.AttributeKey.DIG);
        baseTier = 0.0;
        for (ItemModule.ModuleInstance moduleInstance : ItemModule.getModules(stack).allSubModules()) {
            Material material = MaterialProperty.getMaterial(moduleInstance);
            if (material == null) continue;
            baseTier = Math.max(baseTier, MaterialProperty.getMaterial(moduleInstance).getDouble("mining_level"));
        }
        double durabilityScale = baseDurability * durMultiplier;
        double tierScale = baseTier * tierMultiplier;
        double damageScale = baseDamage * dmgMultiplier;
        double atkSpdScale = baseAtkSpeed * spdMultiplier;
        double digSpeedScale = baseDigSpeed + digMultiplier;
        return damageScale + atkSpdScale + digSpeedScale + durabilityScale + tierScale;
    }
}

