/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.entity.ShieldingArmorFacet;
import smartin.miapi.events.ClientEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.forge.MiapiClientReloadListenerForge;
import smartin.miapi.forge.MiapiReloadListenerForge;
import smartin.miapi.forge.compat.ApotheosisCompat;
import smartin.miapi.forge.compat.epic_fight.EpicFightCompat;
import smartin.miapi.forge.compat.epic_fight.EpicFightCompatProperty;
import smartin.miapi.forge.compat.pmmo.ToolStats;
import smartin.miapi.forge.compat.quark.QuarkCompat;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.compat.ht_treechop.TreechopUtil;
import smartin.miapi.registries.RegistryInventory;

@Mod(value="miapi")
public class TrulyModularForge {
    public static IEventBus trulyModularEventBus;

    public TrulyModularForge() {
        trulyModularEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EventBuses.registerModEventBus((String)"miapi", (IEventBus)trulyModularEventBus);
        if (Environment.isClient()) {
            trulyModularEventBus.register((Object)new ClientModEvents());
            MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        }
        trulyModularEventBus.register((Object)new ModEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        Miapi.init();
        TrulyModularForge.loadCompat("epicfight", () -> {
            RegistryInventory.moduleProperties.register(EpicFightCompatProperty.KEY, new EpicFightCompatProperty());
            if (Platform.getEnv() == Dist.CLIENT) {
                EpicFightCompat.setup();
            }
        });
        TrulyModularForge.loadCompat("quark", QuarkCompat::setup);
        TrulyModularForge.loadCompat("pmmo", ToolStats::setup);
        TrulyModularForge.loadCompat("apotheosis", ApotheosisCompat::setup);
        LifecycleEvent.SERVER_STARTING.register(instance -> TrulyModularForge.setupAttributes());
        ReloadEvents.START.subscribe(isClient -> TrulyModularForge.setupAttributes(), -100.0f);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new MiapiReloadListenerForge());
        AttributeProperty.replaceMap.put("miapi:generic.reach", (Supplier<Attribute>)ForgeMod.BLOCK_REACH);
        AttributeProperty.replaceMap.put("miapi:generic.attack_range", (Supplier<Attribute>)ForgeMod.ENTITY_REACH);
        AttributeProperty.replaceMap.put("forge:block_reach", (Supplier<Attribute>)ForgeMod.BLOCK_REACH);
        AttributeProperty.replaceMap.put("forge:entity_reach", (Supplier<Attribute>)ForgeMod.ENTITY_REACH);
        AttributeProperty.replaceMap.put("reach-entity-attributes:reach", (Supplier<Attribute>)ForgeMod.BLOCK_REACH);
        AttributeProperty.replaceMap.put("reach-entity-attributes:attack_range", (Supplier<Attribute>)ForgeMod.ENTITY_REACH);
        AttributeProperty.replaceMap.put("miapi:generic.swim_speed", () -> AttributeRegistry.SWIM_SPEED);
    }

    public static void setupAttributes() {
        AttributeRegistry.REACH = (Attribute)ForgeMod.BLOCK_REACH.get();
        AttributeRegistry.ATTACK_RANGE = (Attribute)ForgeMod.ENTITY_REACH.get();
        AttributeRegistry.SWIM_SPEED = (Attribute)ForgeMod.SWIM_SPEED.get();
        AttributeProperty.replaceMap.put("miapi:generic.reach", (Supplier<Attribute>)ForgeMod.BLOCK_REACH);
        AttributeProperty.replaceMap.put("miapi:generic.attack_range", (Supplier<Attribute>)ForgeMod.ENTITY_REACH);
        AttributeProperty.replaceMap.put("forge:block_reach", (Supplier<Attribute>)ForgeMod.BLOCK_REACH);
        AttributeProperty.replaceMap.put("forge:entity_reach", (Supplier<Attribute>)ForgeMod.ENTITY_REACH);
        AttributeProperty.replaceMap.put("reach-entity-attributes:reach", (Supplier<Attribute>)ForgeMod.BLOCK_REACH);
        AttributeProperty.replaceMap.put("reach-entity-attributes:attack_range", (Supplier<Attribute>)ForgeMod.ENTITY_REACH);
        AttributeProperty.replaceMap.put("miapi:generic.swim_speed", () -> AttributeRegistry.SWIM_SPEED);
    }

    public static void loadCompat(String modId, Runnable onLoaded) {
        try {
            if (Platform.isModLoaded((String)modId)) {
                onLoaded.run();
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("could not setup compat for " + modId, (Throwable)e);
        }
    }

    public static class ClientModEvents {
        @SubscribeEvent
        public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            TrulyModularForge.setupAttributes();
        }

        @SubscribeEvent
        public void addReloadListeners(RegisterClientReloadListenersEvent addReloadListenerEvent) {
            addReloadListenerEvent.registerReloadListener((PreparableReloadListener)new MiapiClientReloadListenerForge());
        }

        @SubscribeEvent
        public void registerBindings(RegisterKeyMappingsEvent event) {
            MiapiClient.KEY_BINDINGS.addCallback(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        }
    }

    public static class ClientEvents {
        @SubscribeEvent
        public void onRenderGameOverlayEventPre(RenderGuiEvent event) {
            GuiGraphics context = event.getGuiGraphics();
            LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
            if (playerEntity.m_7500_()) {
                return;
            }
            int heartBars = (int)Math.ceil(playerEntity.m_21133_(Attributes.f_22276_) / 20.0);
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((Entity)playerEntity);
            int playerHealth = Mth.m_14167_((float)playerEntity.m_21223_());
            int renderHealthValue = playerHealth + Mth.m_14167_((float)playerEntity.m_6103_());
            int scaledWidth = event.getWindow().m_85445_();
            int shieldingArmorCurrentAmount = (int)facet.getCurrentAmount();
            int scaledHeight = event.getWindow().m_85446_();
            float maxHealth = Math.max((float)playerEntity.m_21133_(Attributes.f_22276_), (float)Math.max(renderHealthValue, playerHealth));
            int absorptionAmount = Mth.m_14167_((float)playerEntity.m_6103_());
            int healthAbsorptionTotal = Mth.m_14167_((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
            int numHearts = Math.max(10 - (healthAbsorptionTotal - 2), 3);
            int startY = scaledHeight - 39 - 10;
            if (MiapiConfig.INSTANCE.client.shieldingArmor.respectHealth) {
                startY -= (healthAbsorptionTotal - 1) * numHearts;
            }
            if (MiapiConfig.INSTANCE.client.shieldingArmor.respectArmor && playerEntity.m_21230_() > 0) {
                startY -= 10;
            }
            startY -= MiapiConfig.INSTANCE.client.shieldingArmor.otherOffests * 10;
            startY = (int)((long)startY - MiapiConfig.INSTANCE.client.shieldingArmor.attributesSingleLine.stream().filter(id -> BuiltInRegistries.f_256951_.m_7804_(id)).map(id -> (Attribute)BuiltInRegistries.f_256951_.m_7745_(id)).filter(arg_0 -> ClientEvents.lambda$onRenderGameOverlayEventPre$2((Player)playerEntity, arg_0)).filter(arg_0 -> ClientEvents.lambda$onRenderGameOverlayEventPre$3((Player)playerEntity, arg_0)).count() * 10L);
            int index = 0;
            while ((float)index < facet.getMaxAmount() / 2.0f) {
                int heartX = scaledWidth / 2 - 91 + index % 10 * 8;
                int yOffset = index / 10 * 10;
                int heartTextureIndex = index * 2 + 1;
                if (heartTextureIndex < shieldingArmorCurrentAmount) {
                    context.m_280163_(CraftingScreen.BACKGROUND_TEXTURE, heartX, startY - yOffset, 430.0f, 96.0f, 9, 9, 512, 512);
                } else if (heartTextureIndex == shieldingArmorCurrentAmount) {
                    context.m_280163_(CraftingScreen.BACKGROUND_TEXTURE, heartX, startY - yOffset, 439.0f, 96.0f, 9, 9, 512, 512);
                } else {
                    context.m_280163_(CraftingScreen.BACKGROUND_TEXTURE, heartX, startY - yOffset, 448.0f, 96.0f, 9, 9, 512, 512);
                }
                ++index;
            }
            ((ClientEvents.HudRender)smartin.miapi.events.ClientEvents.HUD_RENDER.invoker()).render(context, Minecraft.m_91087_().m_91296_());
        }

        private static /* synthetic */ boolean lambda$onRenderGameOverlayEventPre$3(Player playerEntity, Attribute entityAttribute) {
            return playerEntity.m_21133_(entityAttribute) > 1.0;
        }

        private static /* synthetic */ boolean lambda$onRenderGameOverlayEventPre$2(Player playerEntity, Attribute entityAttribute) {
            return playerEntity.m_21204_().m_22171_(entityAttribute);
        }
    }

    public static class ModEvents {
        @SubscribeEvent
        public void enqueueIMC(InterModEnqueueEvent event) {
            if (Platform.isModLoaded((String)"treechop")) {
                InterModComms.sendTo((String)"treechop", (String)"getTreeChopAPI", () -> TreechopUtil::setTreechopApi);
            }
        }
    }

    public static class ServerEvents {
        @SubscribeEvent
        public void damageEvent(LivingHurtEvent hurtEvent) {
            MiapiEvents.LivingHurtEvent event = new MiapiEvents.LivingHurtEvent(hurtEvent.getEntity(), hurtEvent.getSource(), hurtEvent.getAmount());
            if (((MiapiEvents.LivingHurt)MiapiEvents.LIVING_HURT.invoker()).hurt(event).interruptsFurtherEvaluation()) {
                hurtEvent.setCanceled(true);
            }
            hurtEvent.setAmount(event.amount);
        }

        @SubscribeEvent
        public void addReloadListeners(AddReloadListenerEvent addReloadListenerEvent) {
            addReloadListenerEvent.addListener((PreparableReloadListener)new MiapiReloadListenerForge());
        }
    }
}

