/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.conditions.ConditionManager;

public class MiapiClientReloadListenerForge
extends SimplePreparableReloadListener<Map<String, String>> {
    protected void apply(Map<String, String> prepared, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<String, String> dataMap = new HashMap<String, String>(prepared);
        HashMap<String, String> filteredMap = new HashMap<String, String>();
        dataMap.forEach((key, value) -> {
            if (!key.endsWith(".json")) {
                filteredMap.put((String)key, (String)value);
                return;
            }
            try {
                JsonObject element = (JsonObject)Miapi.gson.fromJson(value, JsonObject.class);
                if (!element.has("load_condition")) {
                    filteredMap.put((String)key, (String)value);
                    return;
                }
                boolean allowed = ConditionManager.get(element.get("load_condition")).isAllowed(new ConditionManager.ConditionContext(){

                    @Override
                    public ConditionManager.ConditionContext copy() {
                        return this;
                    }

                    @Override
                    public List<Component> getReasons() {
                        return new ArrayList<Component>();
                    }
                });
                if (allowed) {
                    element.remove("load_condition");
                    Miapi.LOGGER.info("redid " + key);
                    filteredMap.put((String)key, Miapi.gson.toJson((JsonElement)element));
                }
            }
            catch (Exception e) {
                filteredMap.put((String)key, (String)value);
            }
        });
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91073_ != null) {
            ReloadEvents.executeClientReload(Minecraft.m_91087_(), filteredMap);
        } else {
            ReloadEvents.CLIENT_DATA_PACKS.clear();
            ReloadEvents.CLIENT_DATA_PACKS.putAll(filteredMap);
        }
    }

    protected Map<String, String> prepare(ResourceManager manager, ProfilerFiller profiler) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        HashMap<String, List<String>> synced = new HashMap<String, List<String>>(ReloadEvents.syncedPaths);
        synced.forEach((modID, dataPaths) -> new ArrayList<String>((Collection<String>)dataPaths).forEach(dataPath -> {
            Map map = manager.m_214160_("miapi_datapack_data/" + dataPath, fileName -> true);
            map.forEach((identifier, resources) -> {
                if (identifier.m_135827_().equals(modID) && identifier.m_135815_().startsWith("miapi_datapack_data/")) {
                    resources.forEach(resource -> {
                        try {
                            BufferedReader reader = resource.m_215508_();
                            String dataString = reader.lines().collect(Collectors.joining());
                            String fullPath = identifier.m_135815_().replace("miapi_datapack_data/", "");
                            data.put(fullPath, dataString);
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.warn("Error Loading Resource" + String.valueOf(identifier) + " " + String.valueOf(resources));
                        }
                    });
                }
            });
        }));
        return data;
    }
}

