/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import com.redpxnda.nucleus.facet.FacetKey;
import com.redpxnda.nucleus.facet.FacetRegistry;
import com.redpxnda.nucleus.facet.entity.EntityFacet;
import com.redpxnda.nucleus.facet.network.clientbound.FacetSyncPacket;
import com.redpxnda.nucleus.network.PlayerSendable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.registries.RegistryInventory;

public class StunHealthFacet
implements EntityFacet<CompoundTag> {
    private LivingEntity livingEntity;
    private float currentAmount = 20.0f;
    public static final ResourceLocation facetIdentifier = new ResourceLocation("miapi", "stun_current_health");
    public static FacetKey<StunHealthFacet> KEY = FacetRegistry.register((ResourceLocation)facetIdentifier, StunHealthFacet.class);

    public StunHealthFacet(LivingEntity entity) {
        this.livingEntity = entity;
    }

    public void takeStunDamage(float stunDamage, LivingEntity attacker) {
        this.currentAmount -= stunDamage;
        if (this.currentAmount <= 0.0f) {
            if (!this.livingEntity.m_21023_(RegistryInventory.stunResistanceEffect)) {
                this.livingEntity.m_147207_(new MobEffectInstance(RegistryInventory.stunEffect, MiapiConfig.INSTANCE.server.stunEffectCategory.stunLength, 0, false, true), (Entity)attacker);
            }
            this.currentAmount = this.getMaxAmount();
        }
    }

    public float getCurrentStunHealth() {
        return this.currentAmount;
    }

    public void tick() {
        if (this.livingEntity.f_19797_ % 5 == 4) {
            this.currentAmount = Math.min(this.getCurrentStunHealth() + 2.0f, this.getMaxAmount());
            LivingEntity livingEntity = this.livingEntity;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)livingEntity;
                if (serverPlayerEntity.f_8906_ != null && serverPlayerEntity.m_20152_() && !serverPlayerEntity.f_8944_) {
                    try {
                        this.sendToClient(serverPlayerEntity);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public int ticksSinceLastAttack() {
        int lastAttackedTime = ((LivingEntityAccessor)this.livingEntity).getLastAttackedTime();
        if (lastAttackedTime > this.livingEntity.f_19797_) {
            return this.livingEntity.f_19797_;
        }
        return this.livingEntity.f_19797_ - lastAttackedTime;
    }

    public float getMaxAmount() {
        return (float)this.livingEntity.m_21133_(AttributeRegistry.STUN_MAX_HEALTH);
    }

    public CompoundTag toNbt() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("miapi:stun_current_health", this.getCurrentStunHealth());
        return compound;
    }

    public void loadNbt(CompoundTag nbt) {
        this.currentAmount = nbt.m_128457_("miapi:stun_current_health");
    }

    public PlayerSendable createPacket(Entity target) {
        return new FacetSyncPacket(target, KEY, (EntityFacet)this);
    }
}

