/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import com.redpxnda.nucleus.facet.FacetKey;
import com.redpxnda.nucleus.facet.FacetRegistry;
import com.redpxnda.nucleus.facet.entity.EntityFacet;
import com.redpxnda.nucleus.facet.network.clientbound.FacetSyncPacket;
import com.redpxnda.nucleus.network.PlayerSendable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.mixin.LivingEntityAccessor;

public class ShieldingArmorFacet
implements EntityFacet<CompoundTag> {
    private LivingEntity livingEntity;
    private float currentAmount;
    public static final ResourceLocation facetIdentifier = new ResourceLocation("miapi", "shielding_armor");
    public static FacetKey<ShieldingArmorFacet> KEY = FacetRegistry.register((ResourceLocation)facetIdentifier, ShieldingArmorFacet.class);

    public ShieldingArmorFacet(LivingEntity entity) {
        this.livingEntity = entity;
    }

    public float takeDamage(float originalDamage) {
        float reduction = Math.min(originalDamage, this.getCurrentAmount());
        this.currentAmount -= reduction;
        return originalDamage - reduction;
    }

    public float getCurrentAmount() {
        return this.currentAmount;
    }

    public void tick() {
        if (this.livingEntity != null && this.livingEntity.f_19797_ % 5 == 3 && this.ticksSinceLastAttack() > 100) {
            this.currentAmount = Math.min(this.getCurrentAmount() + 0.25f, this.getMaxAmount());
            LivingEntity livingEntity = this.livingEntity;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)livingEntity;
                if (serverPlayerEntity.f_8906_ != null && serverPlayerEntity.m_20152_() && !serverPlayerEntity.f_8944_) {
                    try {
                        this.sendToClient(serverPlayerEntity);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public int ticksSinceLastAttack() {
        int lastAttackedTime = ((LivingEntityAccessor)this.livingEntity).getLastAttackedTime();
        if (lastAttackedTime > this.livingEntity.f_19797_) {
            return this.livingEntity.f_19797_;
        }
        return this.livingEntity.f_19797_ - lastAttackedTime;
    }

    public float getMaxAmount() {
        return (float)this.livingEntity.m_21133_(AttributeRegistry.SHIELDING_ARMOR);
    }

    public CompoundTag toNbt() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("miapi:shielding_armor_current", this.getCurrentAmount());
        return compound;
    }

    public void loadNbt(CompoundTag nbt) {
        this.currentAmount = nbt.m_128457_("miapi:shielding_armor_current");
    }

    public PlayerSendable createPacket(Entity target) {
        return new FacetSyncPacket(target, KEY, (EntityFacet)this);
    }
}

