/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.datapack;

import dev.architectury.event.events.common.PlayerEvent;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;

public class ReloadEvents {
    public static MiapiRegistry<DataSyncer> DATA_SYNCER_REGIGISTRY = MiapiRegistry.getInstance(DataSyncer.class);
    private static final int MAX_PAYLOAD_SIZE = 1000000;
    private static List<String> receivedSyncer = new ArrayList<String>();
    protected static final String RELOAD_PACKET_ID = "miapi:events_reload_s2c";
    public static final Map<String, String> DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static final Map<String, String> CLIENT_DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static Map<String, List<String>> syncedPaths = new HashMap<String, List<String>>();
    public static final ReloadEvent START = new ReloadEvent();
    public static final ReloadEvent MAIN = new ReloadEvent();
    public static final ReloadEvent END = new ReloadEvent();
    public static int reloadCounter = 0;
    private static final Map<String, List<byte[]>> chunkBuffer = new HashMap<String, List<byte[]>>();
    private static final Map<String, Integer> expectedChunks = new HashMap<String, Integer>();
    private static long clientReloadTimeStart = System.nanoTime();

    public static Map<String, String> getDataPacks(boolean isClient) {
        if (isClient) {
            Map<String, String> clientData = Collections.synchronizedMap(new LinkedHashMap());
            clientData.putAll(DATA_PACKS);
            clientData.putAll(CLIENT_DATA_PACKS);
            return clientData;
        }
        return DATA_PACKS;
    }

    public static void registerDataPackPathToSync(String modId, String path) {
        syncedPaths.computeIfAbsent(modId, k -> new ArrayList()).add(path);
    }

    public static void setup() {
        if (Environment.isClient()) {
            ReloadEvents.clientSetup();
        }
        Networking.registerC2SPacket(RELOAD_PACKET_ID, (buf, serverPlayerEntity) -> {
            boolean allowHandshake = buf.readBoolean();
            if (!allowHandshake) {
                Miapi.LOGGER.warn("Client " + String.valueOf(serverPlayerEntity.m_20148_()) + " rejected reload? this should never happen!");
                Miapi.server.m_213846_((Component)Component.m_237113_((String)("Client " + String.valueOf(serverPlayerEntity.m_5446_()) + " failed to reload.")));
            } else {
                ReloadEvents.triggerReloadOnClient(serverPlayerEntity);
            }
        });
        DATA_SYNCER_REGIGISTRY.register("data_packs", new DataSyncer(){

            @Override
            public FriendlyByteBuf createDataServer() {
                FriendlyByteBuf buf = Networking.createBuffer();
                buf.writeInt(DATA_PACKS.size());
                for (String key : DATA_PACKS.keySet()) {
                    buf.m_130070_(key);
                    buf.m_130070_(DATA_PACKS.get(key));
                }
                return buf;
            }

            @Override
            public void interpretDataClient(FriendlyByteBuf buffer) {
                int dataPackSize = buffer.readInt();
                HashMap<String, String> tempDataPack = new HashMap<String, String>(dataPackSize);
                for (int i = 0; i < dataPackSize; ++i) {
                    String key = buffer.m_130277_();
                    String value = buffer.m_130277_();
                    tempDataPack.put(key, value);
                }
                Minecraft.m_91087_().execute(() -> {
                    Map<String, String> map = DATA_PACKS;
                    synchronized (map) {
                        DATA_PACKS.clear();
                        DATA_PACKS.putAll(tempDataPack);
                    }
                    DataPackLoader.trigger(tempDataPack);
                    tempDataPack.clear();
                });
            }
        });
        PlayerEvent.PLAYER_JOIN.register(ReloadEvents::triggerReloadOnClient);
        START.subscribe(isClient -> ++reloadCounter);
        END.subscribe(isClient -> --reloadCounter);
        DataPackLoader.subscribe(dataPack -> {
            Map<String, String> map = DATA_PACKS;
            synchronized (map) {
                DATA_PACKS.clear();
                DATA_PACKS.putAll(dataPack);
            }
        });
    }

    private static void sendInChunks(ServerPlayer entity, String id, byte[] data) {
        int totalChunks = (int)Math.ceil((double)data.length / 1000000.0);
        for (int i = 0; i < totalChunks; ++i) {
            int start = i * 1000000;
            int end = Math.min(start + 1000000, data.length);
            byte[] chunk = Arrays.copyOfRange(data, start, end);
            FriendlyByteBuf buf = Networking.createBuffer();
            buf.m_130070_(id);
            buf.writeInt(totalChunks);
            buf.writeInt(i);
            buf.writeBytes(chunk);
            Networking.sendS2C(RELOAD_PACKET_ID, entity, buf);
        }
    }

    public static void triggerReloadOnClient(ServerPlayer entity) {
        if (!ReloadEvents.isInReload()) {
            DATA_SYNCER_REGIGISTRY.getFlatMap().forEach((id, syncer) -> {
                byte[] fullData = syncer.createDataServer().copy().array();
                ReloadEvents.sendInChunks(entity, id, fullData);
            });
        }
    }

    private static void clientSetup() {
        Networking.registerS2CPacket(RELOAD_PACKET_ID, buffer -> {
            String id = buffer.m_130277_();
            int totalChunks = buffer.readInt();
            int chunkIndex = buffer.readInt();
            byte[] chunk = new byte[buffer.readableBytes()];
            buffer.readBytes(chunk);
            chunkBuffer.computeIfAbsent(id, k -> new ArrayList<Object>(Collections.nCopies(totalChunks, null))).set(chunkIndex, chunk);
            expectedChunks.putIfAbsent(id, totalChunks);
            if (chunkBuffer.get(id).stream().allMatch(Objects::nonNull)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (byte[] part : chunkBuffer.get(id)) {
                    try {
                        out.write(part);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                FriendlyByteBuf reconstructed = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
                DATA_SYNCER_REGIGISTRY.get(id).interpretDataClient(reconstructed);
                receivedSyncer.add(id);
                chunkBuffer.remove(id);
                expectedChunks.remove(id);
            }
            if (receivedSyncer.size() == DATA_SYNCER_REGIGISTRY.getFlatMap().keySet().size()) {
                receivedSyncer.clear();
                ReloadEvents.executeClientReload(Minecraft.m_91087_());
            }
        });
    }

    public static boolean isInReload() {
        if (reloadCounter < 0) {
            reloadCounter = 0;
        }
        return reloadCounter != 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void executeClientReload(Minecraft client) {
        client.execute(() -> {
            ++reloadCounter;
            START.fireEvent(true);
            MAIN.fireEvent(true);
            END.fireEvent(true);
            Miapi.LOGGER.info("Client load took " + (double)(System.nanoTime() - clientReloadTimeStart) / 1000.0 / 1000.0 + " ms");
            if (--reloadCounter != 0) {
                Miapi.LOGGER.error("client believes there is another ongoing reload. This is bad! Reseting Counter" + reloadCounter);
                reloadCounter = 0;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void executeClientReload(Minecraft client, Map<String, String> clientSideData) {
        client.execute(() -> {
            ++reloadCounter;
            CLIENT_DATA_PACKS.clear();
            START.fireEvent(true);
            CLIENT_DATA_PACKS.putAll(clientSideData);
            MAIN.fireEvent(true);
            END.fireEvent(true);
            Miapi.LOGGER.info("Client load took " + (double)(System.nanoTime() - clientReloadTimeStart) / 1000.0 / 1000.0 + " ms");
            if (--reloadCounter != 0) {
                Miapi.LOGGER.error("client believes there is another ongoing reload. This is bad! Reseting Counter" + reloadCounter);
                reloadCounter = 0;
            }
        });
    }

    public static class ReloadEvent {
        private final Map<EventListener, Float> mainListeners = new HashMap<EventListener, Float>();

        public void subscribe(EventListener listener, float priority) {
            this.mainListeners.put(listener, Float.valueOf(priority));
        }

        public void subscribe(EventListener listener) {
            this.subscribe(listener, 0.0f);
        }

        public void unsubscribe(EventListener listener) {
            this.mainListeners.remove(listener);
        }

        public void fireEvent(boolean isClient) {
            this.mainListeners.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(eventListenerFloatEntry -> {
                try {
                    ((EventListener)eventListenerFloatEntry.getKey()).onEvent(isClient);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                }
            });
        }
    }

    public static interface EventListener {
        public void onEvent(boolean var1);
    }

    public static class DataPackLoader {
        protected static final List<EventListener> listeners = new ArrayList<EventListener>();

        public static void subscribe(EventListener listener) {
            listeners.add(listener);
        }

        public static void unsubscribe(EventListener listener) {
            listeners.remove(listener);
        }

        public static void trigger(Map<String, String> dataPack) {
            for (EventListener listener : listeners) {
                try {
                    listener.onEvent(dataPack);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                }
            }
        }

        public static interface EventListener {
            public void onEvent(Map<String, String> var1);
        }
    }

    public static interface DataSyncer {
        public FriendlyByteBuf createDataServer();

        public void interpretDataClient(FriendlyByteBuf var1);
    }
}

