/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.config;

import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.auto.ConfigAutoCodec;
import com.redpxnda.nucleus.util.Comment;
import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;

@ConfigAutoCodec.ConfigClassMarker
public class MiapiServerConfig {
    @AutoCodec.Name(value="generated_materials")
    public GeneratedMaterialsCategory generatedMaterials = new GeneratedMaterialsCategory();
    public EnchantmentsCategory enchants = new EnchantmentsCategory();
    @AutoCodec.Name(value="stun_effect")
    public StunEffectCategory stunEffectCategory = new StunEffectCategory();
    public OtherCategory other = new OtherCategory();

    @ConfigAutoCodec.ConfigClassMarker
    public static class GeneratedMaterialsCategory {
        @Comment(value="Whether Miapi should automatically generate materials based on modded items\nIf this is disabled, the other fields in this section will have no effect")
        @AutoCodec.Name(value="generate_materials")
        public boolean generateMaterials = true;
        @Comment(value="Whether Miapi generated converters if a JsonMaterial doesnt specify if it wants the api to")
        @AutoCodec.Name(value="default_generate_converters")
        public boolean defaultGenerateConverters = true;
        @Comment(value="The maximum amount of materials generated per type")
        @AutoCodec.Name(value="max_generated_materials")
        public int maximumGeneratedMaterials = 200;
        @Comment(value="A regex used to prevent items matching the pattern from generating materials\nBy default this prevents chipped and everycompat from generating materials")
        @AutoCodec.Name(value="block_regex")
        public String blockRegex = "^(chipped|everycompat).*";
        @Comment(value="Whether Miapi should automatically generate materials based on modded wood related items")
        @AutoCodec.Name(value="generate_wood_materials")
        public boolean generateWoodMaterials = true;
        @Comment(value="Whether Miapi should automatically generate materials based on modded stone related items")
        @AutoCodec.Name(value="generate_stone_materials")
        public boolean generateStoneMaterials = true;
        @Comment(value="Whether Miapi should automatically generate materials based on modded tools")
        @AutoCodec.Name(value="generate_other_materials")
        public boolean generateOtherMaterials = true;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class EnchantmentsCategory {
        @Comment(value="Whether Modular Bows should no longer require any arrows to work infinity")
        @AutoCodec.Name(value="better_infinity")
        public boolean betterInfinity = true;
        @Comment(value="Whether loyalty should trigger in the void with Modular Items")
        @AutoCodec.Name(value="better_loyalty")
        public boolean betterLoyalty = true;
        @Comment(value="Whether base modular items should have a say in valid enchantments\nFor example, if this is true, a modular pickaxe will automatically be allowed pickaxe enchantments regardless of its modules")
        @AutoCodec.Name(value="lenient_enchantments")
        public boolean lenientEnchantments = false;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class StunEffectCategory {
        @Comment(value="List of StatusEffects the player will get when stunned")
        @AutoCodec.Name(value="player_effects")
        public List<ResourceLocation> playerEffects = List.of(BuiltInRegistries.f_256974_.m_7981_((Object)MobEffects.f_19610_), BuiltInRegistries.f_256974_.m_7981_((Object)MobEffects.f_19597_));
        @Comment(value="The Stunhealth of a default entity, the StunHealth determins how much stun damage is needed to stun.\nrequires restart to apply - may not correctly affect older worlds")
        @AutoCodec.Name(value="stun_health")
        public double stunHealth = 20.0;
        @Comment(value="The Time a Entity is stunned")
        @AutoCodec.Name(value="stun_length")
        public int stunLength = 100;
        @Comment(value="The Time a Entity is immune to stuns after beeing stunned")
        @AutoCodec.Name(value="stun_resistance_length")
        public int stunResistanceLength = 600;
        @Comment(value="Attackspeed reduction for players while beeing stunned as a Player\nrequires restart to apply")
        @AutoCodec.Name(value="attack_speed_factor")
        public double attackSpeedFactor = 0.5;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class OtherCategory {
        @Comment(value="if the Tooltips are injected on the logical server as well")
        @AutoCodec.Name(value="inject_lore_server")
        public boolean injectLoreServer = true;
        @Comment(value="Bypasses material restrictions entirely NOT RECOMMEND")
        @AutoCodec.Name(value="bypass_material_restriction")
        public boolean bypassMaterialRestrictions = false;
        @Comment(value="Whether the development mode of Miapi is enabled\nDO NOT ENABLE IF U DONT KNOW WHAT IT DOES")
        @AutoCodec.Name(value="development_mode")
        public boolean developmentMode = Platform.isDevelopmentEnvironment();
        @Comment(value="Save Area Mining adds additional checks to prevent explosive behaviour when pared with other mods\n")
        @AutoCodec.Name(value="save_area_mining")
        public boolean saveAreaMining = true;
        @Comment(value="Truly Modular Logs more aggressivly")
        @AutoCodec.Name(value="verbose_logging")
        public boolean verboseLogging = false;
        @Comment(value="If this is on the Block Teleports effect of Truly Modular will block most teleports,\nif false it will only block default Enderman,Chorus fruit and Ender Pearls")
        @AutoCodec.Name(value="block_all_teleports_effects")
        public boolean blockAllTeleportsEffect = true;
        @Comment(value="This allows Truly Modular to dynamicly reset its Toolmaterial\nSome mods might not like dynamic Toolmaterials and cause issues with it,\nbut overall it should increase compatibility and help with Tooldetection")
        @AutoCodec.Name(value="loose_tool_material")
        public boolean looseToolMaterial = true;
        @Comment(value="If this is true modular items will fully break.\nIf set to false Modular Item will instead to go into a Broken state\nIn this broken state they cant do anything but repaired.\nWARNING: some anvil reworking mods break the repairing logic. Please report those issues to us.\n")
        @AutoCodec.Name(value="full_break_modular_items")
        public boolean fullBreakModularItems = true;
        @Comment(value="Whether a miapi reload should be automatically forced on serverstart\nThis is enabled for compat reasons, sometimes scanning recipes and other stuff during a reload isnt stable\n")
        @AutoCodec.Name(value="reload_on_server_start")
        public boolean doubleReload = true;
        @Comment(value="How much of a Modules Durability is used to repair the Item\n")
        @AutoCodec.Name(value="repair_ratio")
        public double repairRatio = 1.0;
    }
}

