/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.DynamicBakery;
import smartin.miapi.client.model.item.BakedSingleModelOverrides;

@OnlyIn(value=Dist.CLIENT)
public class BakedSingleModel
implements BakedModel {
    public List<BakedQuad> quads;
    public ItemTransforms modelTransformation = ItemTransforms.f_111786_;
    public List<BakedModel> childModels = new ArrayList<BakedModel>();
    private BakedSingleModel overrideModel;
    public ItemOverrides overrideList;

    public BakedSingleModel(List<BakedQuad> quads) {
        this.quads = quads;
        this.overrideList = new DynamicOverrides();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        this.quads.forEach(bakedQuad -> {
            if (bakedQuad.m_111306_().equals((Object)face)) {
                bakedQuads.add((BakedQuad)bakedQuad);
            }
        });
        return bakedQuads;
    }

    public void addModel(BakedModel child) {
        if (this.overrideModel == null) {
            this.overrideModel = new BakedSingleModel(new ArrayList<BakedQuad>());
        }
        this.childModels.add(child);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        ResourceLocation stoneTextureId = new ResourceLocation("minecraft", "block/stone");
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(stoneTextureId);
    }

    public ItemTransforms m_7442_() {
        return this.modelTransformation;
    }

    public void setModelTransformation(ItemTransforms transformation) {
        this.modelTransformation = transformation;
        this.childModels.forEach(childModel -> {
            if (childModel instanceof BakedSingleModel) {
                BakedSingleModel bakedSIngleModel = (BakedSingleModel)childModel;
                bakedSIngleModel.setModelTransformation(transformation);
            } else {
                Miapi.LOGGER.warn("childModel is not a Dynamic Model. This should not happen");
            }
        });
    }

    public ItemOverrides m_7343_() {
        if (this.overrideList instanceof DynamicOverrides && this.childModels.isEmpty()) {
            return ItemOverrides.f_111734_;
        }
        return this.overrideList;
    }

    public BakedModel optimize() {
        Map<Direction, List<BakedQuad>> bakedQuads = this.createEmpty();
        this.putDirectionalQuads(bakedQuads, this);
        LinkedHashMap<BakedSingleModelOverrides.ConditionHolder, Map> completeList = new LinkedHashMap<BakedSingleModelOverrides.ConditionHolder, Map>();
        this.childModels.forEach(child -> {
            if (child instanceof BakedSingleModel) {
                BakedSingleModel bakedSIngleModel = (BakedSingleModel)child;
                this.putDirectionalQuads(bakedQuads, (BakedModel)child);
                ItemOverrides patt5032$temp = bakedSIngleModel.overrideList;
                if (patt5032$temp instanceof DynamicBakery.DynamicOverrideList) {
                    DynamicBakery.DynamicOverrideList dynamicOverrideList = (DynamicBakery.DynamicOverrideList)patt5032$temp;
                    for (DynamicBakery.DynamicOverrideList.DynamicBakedOverride overrides : dynamicOverrideList.dynamicOverrides) {
                        BakedSingleModelOverrides.ConditionHolder condition = overrides.conditionHolder;
                        assert (condition != null);
                        if (completeList.containsKey(condition)) continue;
                        completeList.put(condition, this.createEmpty());
                    }
                }
            }
        });
        this.childModels.forEach(child -> {
            if (child instanceof BakedSingleModel) {
                BakedSingleModel bakedSIngleModel = (BakedSingleModel)child;
                ItemOverrides patt5778$temp = bakedSIngleModel.overrideList;
                if (patt5778$temp instanceof DynamicBakery.DynamicOverrideList) {
                    DynamicBakery.DynamicOverrideList dynamicOverrideList = (DynamicBakery.DynamicOverrideList)patt5778$temp;
                    completeList.forEach((conditionHolder, directionBakedQuadHashMap) -> {
                        int index = -1;
                        boolean fallback = true;
                        for (int i = 0; i < dynamicOverrideList.dynamicOverrides.length; ++i) {
                            BakedSingleModelOverrides.ConditionHolder otherCOndition = dynamicOverrideList.dynamicOverrides[i].conditionHolder;
                            if (dynamicOverrideList.dynamicOverrides[i].conditionHolder.equals(conditionHolder)) {
                                this.putDirectionalQuads((Map<Direction, List<BakedQuad>>)directionBakedQuadHashMap, dynamicOverrideList.dynamicOverrides[i].model);
                                fallback = false;
                            }
                            if (!conditionHolder.isAcceptable(otherCOndition)) continue;
                            index = i;
                        }
                        if (index == -1) {
                            this.putDirectionalQuads((Map<Direction, List<BakedQuad>>)directionBakedQuadHashMap, bakedSIngleModel);
                        } else if (fallback) {
                            this.putDirectionalQuads((Map<Direction, List<BakedQuad>>)directionBakedQuadHashMap, dynamicOverrideList.dynamicOverrides[index].model);
                        }
                    });
                }
            }
        });
        LinkedHashMap overrideModels = new LinkedHashMap();
        completeList.forEach((conditionHolder, directionBakedQuadHashMap) -> {
            List defaultList = (List)directionBakedQuadHashMap.get(null);
            defaultList = defaultList == null ? new ArrayList() : defaultList;
            SimpleBakedModel model = new SimpleBakedModel(defaultList, directionBakedQuadHashMap, true, false, true, this.m_6160_(), this.modelTransformation, ItemOverrides.f_111734_);
            overrideModels.put(conditionHolder, model);
        });
        ArrayList defaultList = bakedQuads.get(null);
        defaultList = defaultList == null ? new ArrayList() : defaultList;
        SimpleBakedModel model = new SimpleBakedModel(defaultList, bakedQuads, true, false, true, this.m_6160_(), this.modelTransformation, this.m_7343_());
        return model;
    }

    private Map<Direction, List<BakedQuad>> createEmpty() {
        HashMap<Direction, List<BakedQuad>> defaultMap = new HashMap<Direction, List<BakedQuad>>();
        for (Direction direction : Direction.values()) {
            defaultMap.put(direction, new ArrayList());
        }
        defaultMap.put(null, new ArrayList());
        return defaultMap;
    }

    private void putDirectionalQuads(Map<Direction, List<BakedQuad>> directionalQuads, BakedModel model) {
        model.m_213637_(null, null, RandomSource.m_216327_()).forEach(bakedQuad -> {
            List list = directionalQuads.getOrDefault(bakedQuad.m_111306_(), new ArrayList());
            list.add(bakedQuad);
        });
        for (Direction dir : Direction.values()) {
            model.m_213637_(null, dir, RandomSource.m_216327_()).forEach(bakedQuad -> {
                if (bakedQuad.m_111306_().equals((Object)dir)) {
                    List list = directionalQuads.getOrDefault(bakedQuad.m_111306_(), new ArrayList());
                    list.add(bakedQuad);
                }
            });
        }
        for (Direction direction : Direction.values()) {
            directionalQuads.put(direction, this.cleanUp(directionalQuads.get(direction)));
        }
        directionalQuads.put(null, this.cleanUp(directionalQuads.get(null)));
    }

    private List<BakedQuad> cleanUp(List<BakedQuad> quads) {
        return quads;
    }

    class DynamicOverrides
    extends ItemOverrides {
        public DynamicOverrides() {
            super(DynamicBakery.dynamicBaker, null, new ArrayList());
        }

        public BakedModel m_173464_(BakedModel oldmodel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            if (BakedSingleModel.this.overrideModel != null) {
                BakedSingleModel.this.overrideModel.childModels.clear();
                BakedSingleModel.this.overrideModel.quads.clear();
                BakedSingleModel.this.overrideModel.quads.addAll(BakedSingleModel.this.quads);
                BakedSingleModel.this.childModels.forEach(model -> {
                    if (model != null && model.m_7343_() != null) {
                        BakedModel override = model.m_7343_().m_173464_(model, stack, world, entity, seed);
                        BakedSingleModel.this.overrideModel.addModel(override);
                    } else {
                        BakedSingleModel.this.overrideModel.addModel((BakedModel)model);
                    }
                });
                return BakedSingleModel.this.overrideModel;
            }
            return oldmodel;
        }
    }
}

