/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.client.model.ColorUtil;
import smartin.miapi.client.model.ModelLoadAccessor;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.client.model.item.BakedSingleModelOverrides;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.properties.render.ModelProperty;

@OnlyIn(value=Dist.CLIENT)
public class DynamicBakery {
    public static ModelBaker dynamicBaker;
    static final ItemModelGenerator ITEM_MODEL_GENERATOR;
    private static final FaceBakery QUAD_FACTORY;

    private DynamicBakery() {
    }

    public static BakedSingleModel bakeModel(BlockModel unbakedModel, Function<Material, TextureAtlasSprite> textureGetter, int color, Transform settings) {
        try {
            ModelBakery modelLoader = ModelLoadAccessor.getLoader();
            AtomicReference<BlockModel> actualModel = new AtomicReference<BlockModel>(unbakedModel);
            unbakedModel.m_7970_().stream().filter(identifier -> identifier.toString().equals("minecraft:item/generated") || identifier.toString().contains("handheld")).findFirst().ifPresent(identifier -> actualModel.set(ITEM_MODEL_GENERATOR.m_111670_(ModelProperty.textureGetter, unbakedModel)));
            BakedSingleModel model = DynamicBakery.bake(actualModel.get(), modelLoader, unbakedModel.m_111490_(), textureGetter, Transform.toModelTransformation(settings), new ResourceLocation(unbakedModel.f_111416_), true, color);
            for (Direction direction : Direction.values()) {
                if (model.m_213637_(null, direction, RandomSource.m_216327_()).isEmpty()) continue;
                return model;
            }
            try {
                actualModel.set(ITEM_MODEL_GENERATOR.m_111670_(ModelProperty.textureGetter, unbakedModel));
                return DynamicBakery.bake(actualModel.get(), modelLoader, unbakedModel.m_111490_(), textureGetter, Transform.toModelTransformation(settings), new ResourceLocation(unbakedModel.f_111416_), true, color);
            }
            catch (Exception exception) {
                return model;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BakedSingleModel bake(BlockModel model, ModelBakery loader, BlockModel parent, Function<Material, TextureAtlasSprite> textureGetter, Transform settings, ResourceLocation id, boolean hasDepth, int color) {
        TextureAtlasSprite sprite = textureGetter.apply(model.m_111480_("particle"));
        if (model.m_111490_() == ModelBakery.f_119233_) {
            BuiltInModel model1 = new BuiltInModel(model.m_111491_(), DynamicBakery.compileOverrides(model, loader, parent, textureGetter, (ModelState)BlockModelRotation.X0_Y0, color), sprite, model.m_111479_().m_111526_());
            return DynamicBakery.dynamicBakedModel(DynamicBakery.rotate((BakedModel)model1, settings));
        }
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, DynamicBakery.compileOverrides(model, loader, parent, textureGetter, (ModelState)BlockModelRotation.X0_Y0, color), hasDepth).m_119528_(sprite);
        for (BlockElement modelElement : model.m_111436_()) {
            for (Direction direction : modelElement.f_111310_.keySet()) {
                BlockElementFace modelElementFace = (BlockElementFace)modelElement.f_111310_.get(direction);
                TextureAtlasSprite sprite2 = textureGetter.apply(model.m_111480_(modelElementFace.f_111356_));
                if (modelElementFace.f_111354_ == null) {
                    builder.m_119526_(DynamicBakery.createQuad(modelElement, modelElementFace, sprite2, direction, (ModelState)BlockModelRotation.X0_Y0, id, color));
                    continue;
                }
                builder.m_119530_(Direction.m_252919_((Matrix4f)BlockModelRotation.X0_Y0.m_6189_().m_252783_(), (Direction)modelElementFace.f_111354_), DynamicBakery.createQuad(modelElement, modelElementFace, sprite2, direction, (ModelState)BlockModelRotation.X0_Y0, id, color));
            }
        }
        return DynamicBakery.dynamicBakedModel(DynamicBakery.rotate(builder.m_119533_(), settings));
    }

    public static BakedModel rotate(BakedModel model, Transform transform) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        HashMap directionBakedModelMap = new HashMap();
        for (Object direction : Direction.values()) {
            directionBakedModelMap.put((Direction)direction, new ArrayList());
        }
        for (BakedQuad quad : model.m_213637_(null, null, RandomSource.m_216327_())) {
            quads.addAll(DynamicBakery.rotate(quad, transform));
        }
        for (Object direction : Direction.values()) {
            for (BakedQuad quad : model.m_213637_(null, direction, RandomSource.m_216327_())) {
                quads.addAll(DynamicBakery.rotate(quad, transform));
            }
        }
        return new SimpleBakedModel(quads, directionBakedModelMap, model.m_7541_(), model.m_7547_(), model.m_7539_(), model.m_6160_(), model.m_7442_(), model.m_7343_());
    }

    public static List<BakedQuad> rotate(BakedQuad quad, Transform transform) {
        int[] rotatedData = transform.rotateVertexData(quad.m_111303_());
        for (int i = 0; i < 4; ++i) {
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.add(new BakedQuad(rotatedData, quad.m_111305_(), Direction.m_252919_((Matrix4f)transform.toMatrix(), (Direction)quad.m_111306_()), quad.m_173410_(), quad.m_111307_()));
        for (int i = 0; i < rotatedData.length; i += 8) {
            int endIndex = Math.min(i + 8, rotatedData.length);
            int[] nArray = Arrays.copyOfRange(rotatedData, i, endIndex);
        }
        return quads;
    }

    public static BakedSingleModel dynamicBakedModel(BakedModel model) {
        if (model instanceof BakedSingleModel) {
            BakedSingleModel bakedSIngleModel = (BakedSingleModel)model;
            new Exception().printStackTrace();
            return bakedSIngleModel;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(model.m_213637_(null, null, RandomSource.m_216327_()));
        for (Direction dir : Direction.values()) {
            quads.addAll(model.m_213637_(null, dir, RandomSource.m_216327_()));
        }
        BakedSingleModel model1 = new BakedSingleModel(quads);
        model1.overrideList = model.m_7343_();
        return model1;
    }

    private static ItemOverrides compileOverrides(BlockModel model, ModelBakery modelLoader, BlockModel parent, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotation, int color) {
        if (model.m_111484_().isEmpty()) {
            return ItemOverrides.f_111734_;
        }
        Objects.requireNonNull(modelLoader);
        return new DynamicOverrideList(modelLoader, parent, arg_0 -> ((ModelBakery)modelLoader).m_119341_(arg_0), model.m_111484_(), textureGetter, rotation, color);
    }

    private static BakedQuad createQuad(BlockElement element, BlockElementFace elementFace, TextureAtlasSprite sprite, Direction side, ModelState settings, ResourceLocation id, int color) {
        BakedQuad quad = QUAD_FACTORY.m_111600_(element.f_111308_, element.f_111309_, elementFace, sprite, side, settings, element.f_111311_, element.f_111312_, id);
        quad = ColorUtil.recolorBakedQuad(quad, color);
        return quad;
    }

    static {
        ITEM_MODEL_GENERATOR = new ItemModelGenerator();
        QUAD_FACTORY = new FaceBakery();
    }

    public static class DynamicOverrideList
    extends ItemOverrides {
        public final DynamicBakedOverride[] dynamicOverrides;
        public final ResourceLocation[] dynamicConditionTypes;
        public final List<ItemOverride> overrideList;

        public DynamicOverrideList(ModelBakery modelLoader, BlockModel parent, Function<ResourceLocation, UnbakedModel> unbakedModelGetter, List<ItemOverride> overrides, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotation, int color) {
            super(dynamicBaker, parent, overrides);
            this.dynamicConditionTypes = (ResourceLocation[])overrides.stream().flatMap(ItemOverride::m_173449_).map(ItemOverride.Predicate::m_173459_).distinct().toArray(ResourceLocation[]::new);
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            this.overrideList = overrides;
            for (int i = 0; i < this.dynamicConditionTypes.length; ++i) {
                object2IntMap.put((Object)this.dynamicConditionTypes[i], i);
            }
            ArrayList list = Lists.newArrayList();
            for (int j = overrides.size() - 1; j >= 0; --j) {
                ItemOverride modelOverride = overrides.get(j);
                BlockModel model = ModelProperty.modelCache.get(modelOverride.m_111718_().toString()).model();
                BakedSingleModel bakedModel = DynamicBakery.bakeModel(model, textureGetter, color, Transform.IDENTITY);
                assert (bakedModel != null);
                bakedModel = (BakedSingleModel)ColorUtil.recolorModel(bakedModel, color);
                InlinedCondition[] inlinedConditions = (InlinedCondition[])modelOverride.m_173449_().map(arg_0 -> DynamicOverrideList.lambda$new$1((Object2IntMap)object2IntMap, arg_0)).toArray(InlinedCondition[]::new);
                list.add(new DynamicBakedOverride(inlinedConditions, bakedModel, overrides.get(j)));
            }
            this.dynamicOverrides = list.toArray(new DynamicBakedOverride[0]);
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            if (this.dynamicOverrides.length != 0) {
                Item item = stack.m_41720_();
                int i = this.dynamicConditionTypes.length;
                float[] fs = new float[i];
                for (int j = 0; j < i; ++j) {
                    ResourceLocation identifier = this.dynamicConditionTypes[j];
                    ItemPropertyFunction modelPredicateProvider = ItemProperties.m_117829_((Item)item, (ResourceLocation)identifier);
                    fs[j] = modelPredicateProvider != null ? modelPredicateProvider.m_141951_(stack, world, entity, seed) : Float.NEGATIVE_INFINITY;
                }
                for (DynamicBakedOverride bakedOverride : this.dynamicOverrides) {
                    if (!bakedOverride.test(fs)) continue;
                    BakedModel bakedModel = bakedOverride.model;
                    if (bakedModel == null) {
                        return model;
                    }
                    return bakedModel;
                }
            }
            return model;
        }

        private static /* synthetic */ InlinedCondition lambda$new$1(Object2IntMap object2IntMap, ItemOverride.Predicate condition) {
            int i = object2IntMap.getInt((Object)condition.m_173459_());
            return new InlinedCondition(i, condition.m_173460_());
        }

        @OnlyIn(value=Dist.CLIENT)
        private record InlinedCondition(int index, float threshold) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class DynamicBakedOverride {
            public final InlinedCondition[] conditions;
            @Nullable
            public final BakedModel model;
            public final BakedSingleModelOverrides.ConditionHolder conditionHolder;

            DynamicBakedOverride(InlinedCondition[] conditions, @Nullable BakedModel model, ItemOverride override) {
                this.conditions = conditions;
                this.model = model;
                this.conditionHolder = new BakedSingleModelOverrides.ConditionHolder(override);
            }

            boolean test(float[] values) {
                for (InlinedCondition inlinedCondition : this.conditions) {
                    float f = values[inlinedCondition.index];
                    if (!(f < inlinedCondition.threshold)) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

