/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtil {
    private ColorUtil() {
    }

    public static BakedModel recolorModel(BakedModel originalModel, int color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BakedQuad quad : originalModel.m_213637_(null, null, RandomSource.m_216327_())) {
            builder.add((Object)ColorUtil.recolorBakedQuad(quad, color));
        }
        for (Direction dir : Direction.values()) {
            for (BakedQuad quad : originalModel.m_213637_(null, dir, RandomSource.m_216327_())) {
                builder.add((Object)ColorUtil.recolorBakedQuad(quad, color));
            }
        }
        BakedSingleModel model = new BakedSingleModel((List<BakedQuad>)builder.build());
        model.overrideList = originalModel.m_7343_();
        return model;
    }

    public static BakedQuad recolorBakedQuad(BakedQuad originalQuad, int newColor) {
        return new BakedQuad(originalQuad.m_111303_(), newColor, originalQuad.m_111306_(), originalQuad.m_173410_(), false);
    }

    public static int getModuleColor(ItemModule.ModuleInstance instance) {
        Material material = MaterialProperty.getMaterial(instance);
        if (material != null) {
            return material.getColor();
        }
        return FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    }
}

