/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.config.MiapiConfig;

public class BannerMiapiModel
implements MiapiModel {
    ModelPart banner;
    List<Pair<Holder<BannerPattern>, DyeColor>> patterns;
    BannerMode mode;
    Matrix4f transform;

    public BannerMiapiModel(List<Pair<Holder<BannerPattern>, DyeColor>> patterns, BannerMode mode, Matrix4f transform) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("flag", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f), PartPose.f_171404_);
        this.banner = modelPartData.m_171597_("flag").m_171583_(64, 64);
        this.patterns = patterns;
        this.mode = mode;
        this.transform = transform;
    }

    public BannerMiapiModel(List<Pair<Holder<BannerPattern>, DyeColor>> patterns, BakedModel model, Matrix4f transform) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("flag", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f), PartPose.f_171404_);
        this.banner = modelPartData.m_171597_("flag").m_171583_(64, 64);
        this.patterns = patterns;
        this.transform = transform;
    }

    @Nullable
    public static BannerMiapiModel getFromStack(ItemStack stack, @Nullable BannerMode mode, Matrix4f transform, @Nullable BakedModel model) {
        Item item = stack.m_41720_();
        if (item instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            DyeColor dyeColor = bannerItem.m_40545_();
            ListTag patternList = BannerBlockEntity.m_58487_((ItemStack)stack);
            if (dyeColor != null && patternList != null) {
                if (model != null) {
                    return new BannerMiapiModel((List<Pair<Holder<BannerPattern>, DyeColor>>)BannerBlockEntity.m_58484_((DyeColor)dyeColor, (ListTag)patternList), model, transform);
                }
                if (mode == null) {
                    mode = BannerMode.MODEL;
                }
                return new BannerMiapiModel((List<Pair<Holder<BannerPattern>, DyeColor>>)BannerBlockEntity.m_58484_((DyeColor)dyeColor, (ListTag)patternList), mode, transform);
            }
        }
        return null;
    }

    public static List<Pair<Holder<BannerPattern>, DyeColor>> getPatterns(ItemStack banner) {
        Item item = banner.m_41720_();
        if (item instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            DyeColor dyeColor = bannerItem.m_40545_();
            ListTag patternList = BannerBlockEntity.m_58487_((ItemStack)banner);
            if (dyeColor != null && patternList != null) {
                return BannerBlockEntity.m_58484_((DyeColor)dyeColor, (ListTag)patternList);
            }
        }
        return null;
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext transformationMode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        matrices.m_85836_();
        switch (this.mode) {
            case ITEM: {
                matrices.m_85841_(0.0625f, -0.0625f, -0.0625f);
                matrices.m_85836_();
                matrices.m_85837_(8.0, -8.0, -8.75);
                matrices.m_85841_(1.0f, 1.0f, -1.0f);
                matrices.m_252931_(this.transform);
                matrices.m_85850_().m_252943_().mul((Matrix3fc)this.transform.get3x3(new Matrix3f()));
                matrices.m_85841_(16.0f, 16.0f, 1.0f);
                matrices.m_85841_(0.05f, 0.05f, 2.0f);
                BannerRenderer.m_112074_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.f_119224_, (boolean)true, this.patterns, (stack.m_41790_() && MiapiConfig.INSTANCE.client.other.enchantingGlint ? 1 : 0) != 0);
                matrices.m_85849_();
                matrices.m_85836_();
                matrices.m_85837_(8.0, -8.0, -7.25);
                matrices.m_85841_(1.0f, 1.0f, 1.0f);
                matrices.m_252931_(this.transform);
                matrices.m_85850_().m_252943_().mul((Matrix3fc)this.transform.get3x3(new Matrix3f()));
                matrices.m_85841_(16.0f, 16.0f, 1.0f);
                matrices.m_85841_(0.05f, 0.05f, 2.0f);
                BannerRenderer.m_112074_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.f_119224_, (boolean)true, this.patterns, (stack.m_41790_() && MiapiConfig.INSTANCE.client.other.enchantingGlint ? 1 : 0) != 0);
                matrices.m_85849_();
                break;
            }
            case ITEM_ALT: {
                matrices.m_85841_(0.0625f, -0.0625f, -0.0625f);
                matrices.m_85836_();
                matrices.m_85837_(8.0, -8.0, -8.75);
                matrices.m_85841_(1.0f, 1.0f, -1.0f);
                matrices.m_252931_(this.transform);
                matrices.m_252781_(Axis.f_252529_.m_252977_(10.0f));
                matrices.m_85841_(16.0f, 16.0f, 1.0f);
                matrices.m_85841_(0.05f, 0.05f, 2.0f);
                BannerRenderer.m_112074_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.f_119224_, (boolean)true, this.patterns, (stack.m_41790_() && MiapiConfig.INSTANCE.client.other.enchantingGlint ? 1 : 0) != 0);
                matrices.m_85849_();
                matrices.m_85836_();
                matrices.m_85837_(8.0, -8.0, -7.25);
                matrices.m_85841_(1.0f, 1.0f, 1.0f);
                matrices.m_252931_(this.transform);
                matrices.m_252781_(Axis.f_252529_.m_252977_(10.0f));
                matrices.m_85841_(16.0f, 16.0f, 1.0f);
                matrices.m_85841_(0.05f, 0.05f, 1.0f);
                BannerRenderer.m_112074_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.f_119224_, (boolean)true, this.patterns, (stack.m_41790_() && MiapiConfig.INSTANCE.client.other.enchantingGlint ? 1 : 0) != 0);
                matrices.m_85849_();
                break;
            }
            default: {
                matrices.m_85836_();
                matrices.m_85841_(0.0625f, -0.0625f, -0.0625f);
                matrices.m_252880_(0.0f, -1.0f, 0.0f);
                matrices.m_85836_();
                matrices.m_252931_(new Matrix4f((Matrix4fc)this.transform));
                matrices.m_85850_().m_252943_().mul((Matrix3fc)this.transform.get3x3(new Matrix3f()));
                matrices.m_85841_(16.0f, 16.0f, 16.0f);
                matrices.m_85841_(0.05f, 0.05f, 0.05f);
                BannerRenderer.m_112074_((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.f_119224_, (boolean)true, this.patterns, (stack.m_41790_() && MiapiConfig.INSTANCE.client.other.enchantingGlint ? 1 : 0) != 0);
                matrices.m_85849_();
                matrices.m_85849_();
            }
        }
        matrices.m_85849_();
    }

    public static void render(PoseStack matrices, ItemStack stack, ItemDisplayContext transformationMode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay, List<BakedQuad> quads, List<Pair<Holder<BannerPattern>, DyeColor>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<Holder<BannerPattern>, DyeColor> pair = patterns.get(i);
            float[] fs = ((DyeColor)pair.getSecond()).m_41068_();
            ((Holder)pair.getFirst()).m_203543_().map(Sheets::m_234347_).ifPresent(spriteIdentifier -> {
                VertexConsumer consumer = spriteIdentifier.m_119194_(vertexConsumers, RenderType::m_110482_);
                for (BakedQuad quad : quads) {
                    consumer.m_85987_(matrices.m_85850_(), quad, fs[0], fs[1], fs[2], light, overlay);
                }
            });
        }
    }

    public static BannerMode getMode(String key) {
        try {
            switch (key.toLowerCase()) {
                case "item": {
                    return BannerMode.ITEM;
                }
                case "item_alt": {
                    return BannerMode.ITEM_ALT;
                }
            }
            return BannerMode.valueOf(key);
        }
        catch (Exception e) {
            return BannerMode.MODEL;
        }
    }

    public static enum BannerMode {
        MODEL,
        ITEM,
        ITEM_ALT;

    }

    public record BannerOnModel(String string, boolean isBanner) {
    }
}

