/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.util.DoubleProperty;

@OnlyIn(value=Dist.CLIENT)
public class SinglePropertyStatDisplay
extends SingleStatDisplayDouble {
    protected DoubleProperty property;

    protected SinglePropertyStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter hover, DoubleProperty property) {
        super(0, 0, 51, 19, title, hover);
        this.property = property;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        return this.property.hasValue(original) && this.property.getValue(original) != 0.0 || this.property.hasValue(compareTo) && this.property.getValue(compareTo) != 0.0;
    }

    @Override
    public double getValue(ItemStack stack) {
        return this.property.getValueSafeRaw(stack);
    }

    public static Builder builder(DoubleProperty property) {
        return new Builder(property);
    }

    public static class Builder {
        DoubleProperty property;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.m_237119_();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];
        public DecimalFormat modifierFormat;
        public double min = 0.0;
        public double max = 100.0;
        public Function<Double, Double> convert = a -> a;

        private Builder(DoubleProperty property) {
            this.property = property;
            this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setFunction(Function<Double, Double> function) {
            this.convert = function;
            return this;
        }

        public Builder setName(Component name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setTranslationKey(String key) {
            this.translationKey = key;
            this.name = stack -> Component.m_237110_((String)("miapi.stat." + key), (Object[])new Object[]{this.modifierFormat.format(this.property.getValueSafe(stack))});
            this.hoverDescription = stack -> Component.m_237110_((String)("miapi.stat." + key + ".description"), (Object[])new Object[]{this.modifierFormat.format(this.property.getValueSafe(stack))});
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public SinglePropertyStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.property == null) {
                throw new IllegalStateException("Property is required");
            }
            SinglePropertyStatDisplay display = new SinglePropertyStatDisplay(this.name, this.hoverDescription, this.property);
            display.maxValue = this.max;
            display.minValue = this.min;
            display.modifierFormat = this.modifierFormat;
            display.convert = this.convert;
            return display;
        }
    }
}

