/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.IntegerStatBar;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.StatBar;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;

@OnlyIn(value=Dist.CLIENT)
public class MiningLevelStatDisplay
extends InteractAbleWidget
implements SingleStatDisplay {
    public ResourceLocation texture = CraftingScreen.BACKGROUND_TEXTURE;
    public ItemStack original = ItemStack.f_41583_;
    public ItemStack compareTo = ItemStack.f_41583_;
    public StatBar statBar;
    public ScrollingTextWidget currentValue;
    public ScrollingTextWidget compareValue;
    public ScrollingTextWidget centerValue;
    public ScrollingTextWidget textWidget;
    public double maxValue = 100.0;
    public double minValue = 0.0;
    public int maxValueInt = 4;
    public int minValueInt = 0;
    public DecimalFormat modifierFormat;
    public StatListWidget.TextGetter text;
    public StatListWidget.TextGetter hover;
    public HoverDescription hoverDescription;
    public IntegerStatBar integerStatBar;
    public String type;
    Attribute attribute;
    double defaultValue;
    EquipmentSlot slot;

    public MiningLevelStatDisplay(String type, StatListWidget.TextGetter title, StatListWidget.TextGetter hover) {
        super(0, 0, 76, 19, (Component)Component.m_237119_());
        this.type = type;
        this.text = title;
        this.hover = hover;
        this.textWidget = new ScrollingTextWidget(this.m_252754_(), this.m_252907_(), 80, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.currentValue = new ScrollingTextWidget(this.m_252754_(), this.m_252907_(), 50, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.centerValue = new ScrollingTextWidget(this.m_252754_(), this.m_252907_(), 70, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.centerValue.setOrientation(ScrollingTextWidget.Orientation.CENTERED);
        this.compareValue = new ScrollingTextWidget(this.m_252754_(), this.m_252907_(), 70, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
        this.statBar = new StatBar(0, 0, this.f_93618_, 10, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0));
        this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        this.hoverDescription = new HoverDescription(this.m_252754_(), this.m_252907_(), List.of());
        this.integerStatBar = new IntegerStatBar(0, 0, this.f_93618_, 1);
        this.integerStatBar.setGapWidth(2);
        this.integerStatBar.setHeight(1);
        this.integerStatBar.setMaxSteps(this.maxValueInt);
    }

    public double getValue(ItemStack stack) {
        return AttributeRegistry.getAttribute(stack, this.attribute, this.slot, this.defaultValue);
    }

    public int getAltValue(ItemStack stack) {
        return MiningLevelProperty.getMiningLevel(this.type, stack);
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        ItemStack mainStack = compareTo.m_41619_() ? original : compareTo;
        this.textWidget.setText(this.text.resolve(mainStack));
        this.hoverDescription.setText(this.hover.resolve(mainStack));
        this.original = original;
        this.compareTo = compareTo;
        if (original.m_41638_(this.slot).containsKey((Object)this.attribute)) {
            return true;
        }
        if (compareTo.m_41638_(this.slot).containsKey((Object)this.attribute)) {
            return true;
        }
        return this.getAltValue(original) > 0 || this.getAltValue(compareTo) > 0;
    }

    @Override
    public int getHeightDesired() {
        return 19;
    }

    @Override
    public int getWidthDesired() {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.text.resolve(this.original).getString());
        int numberWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.compareValue.getText().getString());
        int size = 1;
        if (textWidth + numberWidth > 70) {
            size = 2;
        }
        return 76 * size;
    }

    public int getRed() {
        return MiapiConfig.INSTANCE.client.guiColors.red.argb();
    }

    public int getGreen() {
        return MiapiConfig.INSTANCE.client.guiColors.green.argb();
    }

    @Override
    public InteractAbleWidget getHoverWidget() {
        return null;
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        double oldValue = this.getValue(this.original);
        double compareToValue = this.getValue(this.compareTo);
        double min = Math.min(this.minValue, Math.min(oldValue, compareToValue));
        double max = Math.max(this.maxValue, Math.max(oldValue, compareToValue));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        MiningLevelStatDisplay.drawTextureWithEdge(drawContext, this.texture, this.m_252754_(), this.m_252907_(), 339, 6, 51, 19, this.f_93618_, this.f_93619_, 512, 512, 2);
        this.textWidget.m_252865_(this.m_252754_() + 3);
        this.textWidget.m_253211_(this.m_252907_() + 3);
        this.textWidget.m_93674_(this.f_93618_ - 8);
        int oldMining = this.getAltValue(this.original);
        int compareMining = this.getAltValue(this.compareTo);
        this.statBar.m_252865_(this.m_252754_() + 2);
        this.statBar.m_253211_(this.m_252907_() + 12);
        this.statBar.m_93674_(this.f_93618_ - 4);
        this.statBar.setHeight(1);
        this.integerStatBar.m_252865_(this.m_252754_() + 2);
        this.integerStatBar.m_253211_(this.m_252907_() + 15);
        this.integerStatBar.m_93674_(this.f_93618_ - 4);
        this.integerStatBar.setHeight(1);
        if (oldMining < compareMining) {
            this.integerStatBar.setPrimary(oldMining, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.integerStatBar.setSecondary(compareMining, this.getGreen());
        } else {
            this.integerStatBar.setPrimary(compareMining, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.integerStatBar.setSecondary(oldMining, this.getRed());
        }
        if (oldValue < compareToValue) {
            this.statBar.setPrimary((oldValue - min) / (max - min), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((compareToValue - min) / (max - min), this.getGreen());
            this.compareValue.textColor = this.getGreen();
        } else {
            this.statBar.setPrimary((compareToValue - min) / (max - min), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((oldValue - min) / (max - min), this.getRed());
            this.compareValue.textColor = this.getRed();
        }
        if (oldValue == compareToValue) {
            this.currentValue.m_252865_(this.m_252754_() - 3);
            this.currentValue.m_253211_(this.m_252907_() + 3);
            this.currentValue.m_93674_(this.m_5711_());
            this.currentValue.setText((Component)Component.m_237113_((String)this.modifierFormat.format(oldValue)));
            this.currentValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.compareValue.textColor = this.getRed();
            this.currentValue.m_88315_(drawContext, mouseX, mouseY, delta);
        } else {
            this.compareValue.m_252865_(this.m_252754_() - 3);
            this.compareValue.m_253211_(this.m_252907_() + 3);
            this.compareValue.m_93674_(this.m_5711_());
            this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.compareValue.setText(Component.m_130674_((String)this.modifierFormat.format(compareToValue)));
            this.compareValue.m_88315_(drawContext, mouseX, mouseY, delta);
        }
        this.statBar.m_88315_(drawContext, mouseX, mouseY, delta);
        this.integerStatBar.m_88315_(drawContext, mouseX, mouseY, delta);
        this.textWidget.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        Component text1;
        if (this.m_5953_(mouseX, mouseY) && !(text1 = this.hover.resolve(this.compareTo)).getString().isEmpty()) {
            drawContext.m_280557_(Minecraft.m_91087_().f_91062_, this.hover.resolve(this.compareTo), mouseX, mouseY);
        }
    }

    public static Builder builder(String type) {
        return new Builder(type);
    }

    public static class Builder {
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.m_237119_();
        Attribute attribute;
        public EquipmentSlot slot = EquipmentSlot.MAINHAND;
        public double defaultValue = 1.0;
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];
        public DecimalFormat modifierFormat;
        public double min = 0.0;
        public double max = 12.0;
        public String type;

        private Builder(String type) {
            this.type = type;
            this.setTranslationKey("mining.level." + type);
            this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        }

        public Builder setAttribute(Attribute attribute) {
            this.attribute = attribute;
            this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setSlot(EquipmentSlot slot) {
            this.slot = slot;
            return this;
        }

        public Builder setDefault(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setTranslationKey(String key) {
            this.translationKey = key;
            this.name = stack -> Component.m_237115_((String)("miapi.stat." + key));
            this.hoverDescription = stack -> Component.m_237110_((String)("miapi.stat." + key + ".description"), (Object[])this.descriptionArgs);
            return this;
        }

        public MiningLevelStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            MiningLevelStatDisplay display = new MiningLevelStatDisplay(this.type, this.name, this.hoverDescription);
            display.attribute = this.attribute;
            display.slot = this.slot;
            display.defaultValue = this.defaultValue;
            display.minValue = this.min;
            display.maxValue = this.max;
            display.modifierFormat = this.modifierFormat;
            return display;
        }
    }
}

