/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;

@OnlyIn(value=Dist.CLIENT)
public class JsonStatDisplay
extends SingleStatDisplayDouble {
    SingleStatDisplayDouble.StatReaderHelper statReader;

    public JsonStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter description, SingleStatDisplayDouble.StatReaderHelper statReaderHelper, double min, double max) {
        super(0, 0, 51, 19, title, description);
        this.statReader = statReaderHelper;
        this.minValue = min;
        this.maxValue = max;
    }

    @Override
    public double getValue(ItemStack stack) {
        return this.statReader.getValue(stack);
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        if (this.statReader.hasValue(original)) {
            this.textWidget.setText(this.text.resolve(original));
            this.hoverDescription.setText(this.hover.resolve(original));
            return true;
        }
        if (this.statReader.hasValue(compareTo)) {
            this.textWidget.setText(this.text.resolve(compareTo));
            this.hoverDescription.setText(this.hover.resolve(compareTo));
            return true;
        }
        return false;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        StatListWidget.TextGetter title;
        StatListWidget.TextGetter description;
        SingleStatDisplayDouble.StatReaderHelper statReaderHelper;
        double min = 0.0;
        double max = 10.0;
        public boolean isInversed = false;

        public Builder setTitle(Component title) {
            this.title = stack -> title;
            return this;
        }

        public Builder setDescription(Component description) {
            this.description = stack -> description;
            return this;
        }

        public Builder setStatReader(SingleStatDisplayDouble.StatReaderHelper statReaderHelper) {
            this.statReaderHelper = statReaderHelper;
            return this;
        }

        public Builder setMax(int max) {
            this.max = max;
            return this;
        }

        public Builder setMin(int min) {
            this.min = min;
            return this;
        }

        public Builder inverse(boolean inversed) {
            this.isInversed = inversed;
            return this;
        }

        public JsonStatDisplay build() {
            JsonStatDisplay jsonStatDisplay = new JsonStatDisplay(this.title, this.description, this.statReaderHelper, this.min, this.max);
            jsonStatDisplay.inverse = this.isInversed;
            return jsonStatDisplay;
        }
    }
}

