/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.slotdisplay;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.modules.properties.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class SlotDisplay
extends InteractAbleWidget {
    private final Map<SlotProperty.ModuleSlot, ModuleButton> buttonMap = new HashMap<SlotProperty.ModuleSlot, ModuleButton>();
    private ItemStack stack;
    private PoseStack slotProjection = new PoseStack();
    private double lastMouseX;
    private double lastMouseY;
    private boolean mouseDown0 = false;
    private boolean mouseDown1 = false;
    private SlotProperty.ModuleSlot selected = null;
    private final Consumer<SlotProperty.ModuleSlot> setSelected;
    private SlotProperty.ModuleSlot baseSlot;

    public SlotDisplay(ItemStack stack, int x, int y, int height, int width, Consumer<SlotProperty.ModuleSlot> selected) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"Item Display"));
        this.stack = stack;
        this.f_93619_ = height;
        this.f_93618_ = width;
        this.slotProjection.m_85841_(1.0f, -1.0f, 1.0f);
        this.setSelected = selected;
        this.setBaseSlot(new SlotProperty.ModuleSlot(new ArrayList<String>()));
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        if (this.mouseDown0) {
            this.handleLeftClickDrag(mouseX, mouseY, this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        } else if (this.mouseDown1) {
            this.handleRightClickDrag(mouseX, mouseY, this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    @Override
    public boolean m_5953_(double x, double y) {
        boolean mouseOver;
        boolean bl = mouseOver = x >= (double)this.m_252754_() && y >= (double)this.m_252907_() && x < (double)(this.m_252754_() + this.f_93618_) && y < (double)(this.m_252907_() + this.f_93619_);
        if (mouseOver) {
            return true;
        }
        this.mouseDown0 = false;
        this.mouseDown1 = false;
        return super.m_5953_(x, y);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.m_5953_(mouseX, mouseY)) {
            this.mouseDown0 = true;
        } else if (button == 1 && this.m_5953_(mouseX, mouseY)) {
            this.mouseDown1 = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.mouseDown0 = false;
        } else if (button == 1) {
            this.mouseDown1 = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void handleLeftClickDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        PoseStack newStack = new PoseStack();
        newStack.m_252880_((float)(-deltaX) / 100.0f, -((float)deltaY) / 100.0f, 0.0f);
        newStack.m_252931_(this.slotProjection.m_85850_().m_252922_());
        this.slotProjection = newStack;
    }

    private void handleRightClickDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        float angleX = (float)(-(deltaY * (double)0.02f));
        float angleY = (float)(-(deltaX * (double)0.02f));
        PoseStack newStack = new PoseStack();
        newStack.m_85850_().m_252922_().rotateAffineXYZ(-angleX, angleY, 0.0f);
        newStack.m_252931_(this.slotProjection.m_85850_().m_252922_());
        this.slotProjection = newStack;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.m_5953_(mouseX, mouseY)) {
            double scale = Math.pow(2.0, amount / 10.0);
            this.slotProjection.m_85841_((float)scale, (float)scale, (float)scale);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void setBaseSlot(SlotProperty.ModuleSlot baseSlot1) {
        this.baseSlot = baseSlot1;
        this.buttonMap.forEach((slot1, moduleButton) -> this.children().remove(moduleButton));
        this.buttonMap.clear();
        if (this.baseSlot != null && this.baseSlot.inSlot != null) {
            this.baseSlot.inSlot.allSubModules().forEach(moduleInstances -> SlotProperty.getSlots(moduleInstances).forEach((number, slot) -> this.buttonMap.computeIfAbsent((SlotProperty.ModuleSlot)slot, newSlot -> {
                ModuleButton newButton = new ModuleButton(0, 0, 10, 10, (SlotProperty.ModuleSlot)newSlot);
                this.addChild(newButton);
                return newButton;
            })));
            this.buttonMap.computeIfAbsent(this.baseSlot, newSlot -> {
                ModuleButton newButton = new ModuleButton(0, 0, 10, 10, (SlotProperty.ModuleSlot)newSlot);
                this.addChild(newButton);
                return newButton;
            });
        }
    }

    public void setItem(ItemStack itemStack) {
        this.stack = itemStack;
        this.slotProjection = new PoseStack();
        this.slotProjection.m_85841_(1.0f, -1.0f, 1.0f);
        this.selected = new SlotProperty.ModuleSlot(new ArrayList<String>());
    }

    public int getSize() {
        int size = Math.min(this.f_93618_, this.f_93619_);
        size = Math.max(5, size - 10);
        return size;
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_);
        this.renderSlot(this.stack, drawContext, mouseX, mouseY, delta);
        super.m_88315_(drawContext, mouseX, mouseY, delta);
        drawContext.m_280618_();
    }

    public void select(SlotProperty.ModuleSlot selected) {
        this.selected = selected;
    }

    private Vector3f position() {
        return new Vector3f((float)this.m_252754_() + (float)(this.f_93618_ - 16) / 2.0f, (float)this.m_252907_() + (float)(this.f_93619_ - 16) / 2.0f, 150.0f);
    }

    public void renderSlot(ItemStack stack, GuiGraphics context, int mouseX, int mouseY, float delta) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.m_85836_();
        Vector3f pos = this.position();
        matrixStack.m_252880_(pos.x(), pos.y(), pos.z());
        matrixStack.m_85841_((float)this.getSize(), (float)this.getSize(), 1.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = true;
        if (bl) {
            Lighting.m_84930_();
        }
        RenderSystem.enableDepthTest();
        renderer.m_269128_(stack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.f_118083_, this.slotProjection, (MultiBufferSource)immediate, (Level)Minecraft.m_91087_().f_91073_, 0);
        immediate.m_109911_();
        RenderSystem.enableDepthTest();
        if (bl) {
            Lighting.m_84931_();
        }
        matrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public class ModuleButton
    extends InteractAbleWidget {
        private static final ResourceLocation ButtonTexture = new ResourceLocation("miapi", "textures/button.png");
        public SlotProperty.ModuleSlot instance;

        public ModuleButton(int x, int y, int width, int height, SlotProperty.ModuleSlot instance) {
            super(x, y, width, height, (Component)Component.m_237113_((String)" "));
            this.instance = instance;
        }

        private void setSelected(SlotProperty.ModuleSlot instance) {
            SlotDisplay.this.selected = instance;
            SlotDisplay.this.setSelected.accept(instance);
        }

        @Override
        public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.depthFunc((int)519);
            RenderSystem.disableDepthTest();
            this.m_87963_(drawContext, mouseX, mouseY, delta);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY)) {
                this.playClickedSound();
                this.setSelected(this.instance);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public void m_87963_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int textureSize = 30;
            int textureOffset = 0;
            if (this.instance.equals(SlotDisplay.this.selected)) {
                textureOffset = 20;
            } else if (this.m_5953_(mouseX, mouseY)) {
                textureOffset = 10;
            }
        }
    }
}

