/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace.hover;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.AllowedMaterial;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.material.NBTMaterial;
import smartin.miapi.registries.RegistryInventory;

public class HoverMaterialList
extends InteractAbleWidget {
    public Map<String, List<Material>> materials = new LinkedHashMap<String, List<Material>>();
    public List<String> materialKeys;
    public int selected = 0;
    public int scrollPosOne = 0;
    public int scrollPosTwo = 0;
    protected final int maxElements = 8;
    protected final int selectedColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final int unselectedColor = FastColor.ARGB32.m_13660_((int)255, (int)200, (int)200, (int)200);
    protected final int moreEntryColor = FastColor.ARGB32.m_13660_((int)255, (int)160, (int)160, (int)160);
    protected int start = 0;
    protected int end = 0;
    protected boolean lastRendered = false;
    protected Material previewMaterial = null;
    protected int realMouseX = 0;
    protected int realMouseY = 0;
    protected int sizeDetailList;
    protected int verticalSize;
    protected int sizeBaseList = 0;
    protected boolean permaOpen = false;

    public HoverMaterialList(ItemModule module, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.materialKeys = AllowedMaterial.property.getAllowedKeys(module);
        for (String key : this.materialKeys) {
            this.materials.put(key, AllowedMaterial.property.getMaterials(key).stream().sorted(Comparator.comparing(m -> m.getTranslation().getString())).toList());
        }
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.m_280163_(CraftingScreen.BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), 404.0f, 96.0f, 20, 11, 512, 512);
        this.realMouseX = mouseX;
        this.realMouseY = mouseY;
        if (this.lastRendered || this.permaOpen) {
            HoverMaterialList.selectedMaterialUpdate(this.previewMaterial);
            if (CraftingScreen.getInstance() != null) {
                // empty if block
            }
        }
        super.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        int currentY = this.m_252907_() + 3;
        String selectedMaterialOrGroup = this.materialKeys.get(this.selected + this.scrollPosOne);
        List<Material> materialList = this.materials.get(selectedMaterialOrGroup);
        this.sizeBaseList = 30;
        this.verticalSize = Math.min(this.materials.size(), 8);
        this.verticalSize = Math.max(Math.min(materialList.size(), 8), this.verticalSize);
        this.verticalSize *= 14;
        for (int i = this.scrollPosOne; i < Math.min(this.materials.size(), 8 + this.scrollPosOne); ++i) {
            this.sizeBaseList = Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)HoverMaterialList.getTranslation(this.materialKeys.get(i))), this.sizeBaseList);
        }
        this.sizeDetailList = 0;
        for (Material m : materialList) {
            this.sizeDetailList = Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)HoverMaterialList.getTranslation(m.getKey())), this.sizeDetailList);
        }
        this.sizeDetailList += 10;
        if (this.m_5953_(this.realMouseX, this.realMouseY) || this.permaOpen) {
            this.lastRendered = true;
            RenderSystem.disableDepthTest();
            drawContext.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.sizeDetailList + this.sizeBaseList, this.m_252907_() + this.verticalSize, FastColor.ARGB32.m_13660_((int)210, (int)0, (int)0, (int)0));
            if (!this.materials.isEmpty()) {
                int startOne = this.scrollPosOne = Math.max(0, Math.min(this.materials.size() - 8, this.scrollPosOne));
                int endOne = Math.min(this.scrollPosOne + 8, this.materials.size());
                if (startOne > 0) {
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.higher.scroll"), this.m_252754_() + 3, currentY, this.moreEntryColor, false);
                    ++startOne;
                    currentY += 14;
                }
                for (int i = startOne; i < endOne; ++i) {
                    int color = i == this.selected + this.scrollPosOne ? this.selectedColor : this.unselectedColor;
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, HoverMaterialList.getTranslation(this.materialKeys.get(i)), this.m_252754_() + 3, currentY, color, false);
                    currentY += 14;
                }
                if (endOne < this.materials.size()) {
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.lower.scroll"), this.m_252754_() + 3, currentY, this.moreEntryColor, false);
                }
            }
            currentY = this.m_252907_() + 3;
            if (materialList.size() > 1) {
                this.scrollPosTwo = Math.max(0, Math.min(this.scrollPosTwo, materialList.size() - 1));
                while (this.start > this.scrollPosTwo - 1) {
                    --this.start;
                }
                this.start = Math.max(0, this.start);
                this.end = Math.min(this.start + 8, materialList.size());
                while (this.end < this.scrollPosTwo + 2 && this.end < materialList.size()) {
                    ++this.start;
                    this.end = Math.min(this.start + 8, materialList.size());
                }
                for (int i = this.start; i < this.end; ++i) {
                    if (this.start > 0 && i == this.start) {
                        drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.higher"), this.m_252754_() + this.sizeBaseList + 6, currentY, this.moreEntryColor, false);
                    } else if (i == this.end - 1 && this.end < materialList.size() - 1) {
                        drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.lower"), this.m_252754_() + this.sizeBaseList + 6, currentY, this.moreEntryColor, false);
                    } else {
                        int color = i == this.scrollPosTwo ? this.selectedColor : this.unselectedColor;
                        drawContext.m_280614_(Minecraft.m_91087_().f_91062_, HoverMaterialList.getTranslation(materialList.get(i).getKey()), this.m_252754_() + this.sizeBaseList + 6, currentY, color, false);
                    }
                    currentY += 14;
                }
                this.previewMaterial = materialList.get(this.scrollPosTwo);
            } else {
                this.previewMaterial = materialList.get(0);
            }
            RenderSystem.enableDepthTest();
        } else {
            if (this.lastRendered || this.permaOpen) {
                this.previewMaterial = null;
                HoverMaterialList.selectedMaterialUpdate(null);
            }
            this.lastRendered = false;
            this.scrollPosOne = 0;
            this.scrollPosTwo = 0;
            this.selected = 0;
        }
    }

    public boolean isMouseOverFull(double mouseX, double mouseY, int otherWidth, int otherHeight) {
        return this.f_93623_ && this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + otherWidth) && mouseY < (double)(this.m_252907_() + otherHeight);
    }

    public static void selectedMaterialUpdate(Material material) {
        if (material != null && PreviewManager.currentPreviewMaterial != material) {
            ItemStack materialStack = new ItemStack((ItemLike)RegistryInventory.modularItem);
            NBTMaterial.setMaterial(material, materialStack);
            PreviewManager.setCursorItemstack(materialStack);
        } else {
            ItemStack materialStack = new ItemStack((ItemLike)RegistryInventory.modularItem);
            PreviewManager.setCursorItemstack(materialStack);
            PreviewManager.resetCursorStack();
        }
    }

    public static Component getTranslation(String materialOrGroupKey) {
        if (MaterialProperty.materials.containsKey(materialOrGroupKey)) {
            Material material = MaterialProperty.materials.get(materialOrGroupKey);
            return Component.m_237115_((String)material.getData("translation"));
        }
        MutableComponent testTranslation = Component.m_237115_((String)("miapi.material_group." + materialOrGroupKey));
        if (testTranslation.getString().equals("miapi.material_group." + materialOrGroupKey)) {
            return Component.m_237113_((String)materialOrGroupKey);
        }
        return testTranslation;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (Screen.m_96638_() || Screen.m_96637_()) {
                this.scrollPosTwo = amount < 0.0 ? ++this.scrollPosTwo : --this.scrollPosTwo;
                return true;
            }
            this.scrollPosTwo = 0;
            this.start = 0;
            if (amount < 0.0) {
                int maxElementsTotal = this.materialKeys.size();
                if (this.selected + this.scrollPosOne != maxElementsTotal - 1) {
                    if (this.scrollPosOne == 0 && 8 == maxElementsTotal) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.scrollPosOne + 8 == maxElementsTotal - 1) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.selected == 6) {
                        ++this.scrollPosOne;
                    } else {
                        this.selected = Math.min(this.selected + 1, 7);
                    }
                }
            } else if (this.selected == 1 && this.scrollPosOne > 0) {
                --this.scrollPosOne;
            } else {
                this.selected = Math.max(this.selected - 1, 0);
            }
            return true;
        }
        return false;
    }
}

