/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.AllowedSlots;
import smartin.miapi.modules.properties.CanChildBeEmpty;
import smartin.miapi.modules.properties.CraftingConditionProperty;
import smartin.miapi.modules.properties.PriorityProperty;
import smartin.miapi.modules.properties.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class ReplaceView
extends InteractAbleWidget {
    Consumer<CraftOption> craft;
    Consumer<CraftOption> preview;
    SlotButton lastPreview;
    public static List<CraftOptionSupplier> optionSuppliers = new ArrayList<CraftOptionSupplier>();
    public SlotProperty.ModuleSlot currentSlot;

    public ReplaceView(int x, int y, int width, int height, SlotProperty.ModuleSlot slot, EditOption.EditContext editContext, Consumer<SlotProperty.ModuleSlot> back, Consumer<CraftOption> craft, Consumer<CraftOption> preview) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.craft = craft;
        this.preview = preview;
        float headerScale = 1.0f;
        this.currentSlot = slot;
        TransformableWidget headerHolder = new TransformableWidget(x, y, width, height, headerScale);
        this.addChild(headerHolder);
        ScrollingTextWidget header = new ScrollingTextWidget((int)((float)(this.m_252754_() + 5) / headerScale), (int)((float)this.m_252907_() / headerScale) + 3, (int)((float)(this.f_93618_ - 10) / headerScale), (Component)Component.m_237115_((String)"miapi.ui.replace.header"), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        headerHolder.addChild(header);
        ScrollList list = new ScrollList(x, y + 14, width, height - 16, new ArrayList<InteractAbleWidget>());
        this.addChild(list);
        list.children().clear();
        ArrayList<InteractAbleWidget> toList = new ArrayList<InteractAbleWidget>();
        if (editContext.getInstance() == null || CanChildBeEmpty.property.isTrue(editContext.getInstance())) {
            toList.add(new SlotButton(0, 0, this.f_93618_, 15, new CraftOption(ItemModule.empty, new HashMap<String, String>())));
        }
        ArrayList craftOptions = new ArrayList();
        AllowedSlots.allowedIn(slot).stream().sorted(Comparator.comparingDouble(PriorityProperty::getFor)).distinct().forEach(module -> {
            if (CraftingConditionProperty.isVisible(slot, module, (Player)Minecraft.m_91087_().f_91074_, null)) {
                craftOptions.add(new CraftOption((ItemModule)module, (Map<String, String>)new HashMap<String, String>()));
            }
        });
        optionSuppliers.forEach(craftOptionSupplier -> craftOptions.addAll(craftOptionSupplier.getOption(editContext)));
        craftOptions.stream().sorted(Comparator.comparingDouble(a -> PriorityProperty.getFor(a.module()))).forEach(craftOption -> toList.add(new SlotButton(0, 0, this.f_93618_, 15, (CraftOption)craftOption)));
        list.setList(toList);
    }

    public void setPreview(CraftOption option) {
        this.preview.accept(option);
    }

    class SlotButton
    extends InteractAbleWidget {
        private ScrollingTextWidget textWidget;
        private CraftOption option;
        private boolean isAllowed;
        private HoverDescription hoverDescription;

        public SlotButton(int x, int y, int width, int height, CraftOption option) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.isAllowed = true;
            String moduleName = option.module().getName();
            this.option = option;
            ItemModule.ModuleInstance instance = new ItemModule.ModuleInstance(option.module());
            Component translated = StatResolver.translateAndResolve("miapi.module." + moduleName, instance);
            this.textWidget = new ScrollingTextWidget(0, 0, this.f_93618_, translated, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.isAllowed = CraftingConditionProperty.isCraftable(ReplaceView.this.currentSlot, option.module(), (Player)Minecraft.m_91087_().f_91074_, null);
            List<Component> texts = new ArrayList<Component>();
            if (!this.isAllowed) {
                texts = CraftingConditionProperty.getReasonsForCraftable(ReplaceView.this.currentSlot, option.module(), (Player)Minecraft.m_91087_().f_91074_, null);
            }
            this.hoverDescription = new HoverDescription(x, y, texts);
        }

        @Override
        public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int hoverOffset = 0;
            if (this.m_5953_(mouseX, mouseY)) {
                hoverOffset = 14;
            }
            if (!this.isAllowed) {
                hoverOffset = 28;
            }
            SlotButton.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), 404, 54 + hoverOffset, 108, 14, this.m_5711_(), this.m_93694_(), 512, 512, 3);
            this.textWidget.m_252865_(this.m_252754_() + 2);
            this.textWidget.m_253211_(this.m_252907_() + 3);
            this.textWidget.m_93674_(this.f_93618_ - 4);
            this.textWidget.m_88315_(drawContext, mouseX, mouseY, delta);
            if (this.m_5953_(mouseX, mouseY) && !this.isAllowed && this.hoverDescription != null) {
                this.hoverDescription.m_88315_(drawContext, mouseX, mouseY, delta);
            }
        }

        @Override
        public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            if (this.m_5953_(mouseX, mouseY) && !this.isAllowed && this.hoverDescription != null) {
                this.hoverDescription.m_252865_(this.m_252754_());
                this.hoverDescription.m_253211_(this.m_252907_() + this.m_93694_());
                this.hoverDescription.m_88315_(drawContext, mouseX, mouseY, delta);
            }
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            boolean isOver = super.m_5953_(mouseX, mouseY);
            if (!((Object)((Object)this)).equals((Object)ReplaceView.this.lastPreview) && isOver) {
                ReplaceView.this.lastPreview = this;
                ReplaceView.this.setPreview(this.option);
            }
            return isOver;
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY) && button == 0 && this.isAllowed) {
                this.playClickedSound();
                ReplaceView.this.craft.accept(this.option);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    public static interface CraftOptionSupplier {
        public List<CraftOption> getOption(EditOption.EditContext var1);
    }
}

