/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.MutableSlot;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.SimpleScreenHandlerListener;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.client.gui.crafting.crafter.replace.EmptyCraftingWidget;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.network.Networking;

@OnlyIn(value=Dist.CLIENT)
public class CraftViewRework
extends InteractAbleWidget {
    public List<Slot> currentSlots = new ArrayList<Slot>();
    private int currentGuiIndex = 0;
    int backgroundWidth = 284;
    int backgroundHeight = 221;
    List<Component> warnings = new ArrayList<Component>();
    boolean firstRender = true;
    boolean isClosed = false;
    EditOption.EditContext editContext;
    CraftAction action;
    List<CraftingProperty> craftingProperties = new ArrayList<CraftingProperty>();
    List<InteractAbleWidget> craftingGuis = new ArrayList<InteractAbleWidget>();
    SimpleButton<Object> previousButton;
    SimpleButton<Object> nextButton;
    CraftButton<Object> craftButton;
    Matrix4f currentMatrix = new Matrix4f();
    public Map<String, String> defaultMap = new HashMap<String, String>();
    static ContainerListener listener;
    EmptyCraftingWidget fallbackCraftingWidget;

    public CraftViewRework(int x, int y, int width, int height, int offset, CraftOption option, EditOption.EditContext editContext, Consumer<SlotProperty.ModuleSlot> back) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.editContext = editContext;
        if (listener != null) {
            editContext.getScreenHandler().m_38943_(listener);
        }
        listener = new SimpleScreenHandlerListener((TriConsumer<AbstractContainerMenu, Integer, ItemStack>)((TriConsumer)(h, slotId, itemStack) -> {
            if (slotId != CraftingScreenHandler.CLIENT_SLOT_ID) {
                this.update();
            }
        }));
        this.defaultMap = option.data();
        this.action = new CraftAction(editContext.getItemstack(), editContext.getSlot(), option.module(), editContext.getPlayer(), editContext.getWorkbench(), option.data());
        this.action.setItem(editContext.getItemstack());
        this.action.linkInventory(editContext.getLinkedInventory(), offset);
        this.setBuffers();
        ItemStack test = this.action.getPreview();
        this.action.forEachCraftingProperty(test, (craftingProperty, moduleInstance, itemStacks, invStart, invEnd, buf) -> {
            InteractAbleWidget guiScreen = craftingProperty.createGui(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_ - 30, this.action);
            if (guiScreen != null) {
                this.craftingGuis.add(guiScreen);
                this.craftingProperties.add(craftingProperty);
            }
        });
        this.fallbackCraftingWidget = new EmptyCraftingWidget(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.action);
        this.addChild(new SimpleButton<Object>(this.m_252754_() + 2, this.m_252907_() + this.f_93619_ - 14, 40, 12, (Component)Component.m_237115_((String)"miapi.ui.back"), null, moduleSlot -> {
            this.isClosed = true;
            this.closeSlot();
            back.accept(null);
        }));
        if (this.craftingGuis.size() > 1) {
            this.previousButton = new PageButton<Object>(this.m_252754_() + this.f_93618_ - 10, this.m_252907_(), 10, 12, true, null, callback -> {
                if (this.currentGuiIndex > 0) {
                    this.removeChild(this.craftingGuis.get(this.currentGuiIndex));
                    --this.currentGuiIndex;
                    this.addGui(this.craftingGuis.get(this.currentGuiIndex));
                    if (this.currentGuiIndex == 0) {
                        this.previousButton.isEnabled = false;
                    }
                    this.nextButton.isEnabled = true;
                }
            });
            this.nextButton = new PageButton<Object>(this.m_252754_() + 10, this.m_252907_(), 10, 12, false, null, callback -> {
                if (this.currentGuiIndex < this.craftingGuis.size() - 1) {
                    this.removeChild(this.craftingGuis.get(this.currentGuiIndex));
                    ++this.currentGuiIndex;
                    this.addGui(this.craftingGuis.get(this.currentGuiIndex));
                    if (this.currentGuiIndex == this.craftingGuis.size() - 1) {
                        this.nextButton.isEnabled = false;
                    }
                    this.previousButton.isEnabled = true;
                }
            });
        }
        this.craftButton = new CraftButton<Object>(this.m_252754_() + this.f_93618_ - 42, this.m_252907_() + this.f_93619_ - 14, 40, 12, (Component)Component.m_237115_((String)"miapi.ui.craft"), null, callback -> {
            this.setBuffers();
            if (this.action.canPerform()) {
                this.isClosed = true;
                ItemStack craftedStack = this.action.getPreview();
                if (!ItemStack.m_41728_((ItemStack)editContext.getItemstack(), (ItemStack)craftedStack)) {
                    editContext.craft(this.action.toPacket(Networking.createBuffer()));
                    CraftingScreen.getInstance().setItem(craftedStack);
                }
                editContext.getScreenHandler().m_38943_(listener);
            }
        });
        this.addChild(this.craftButton);
        editContext.getScreenHandler().m_38893_(listener);
    }

    private void update() {
        try {
            if (!this.isClosed) {
                ItemStack previewStack = this.action.getPreview().m_41777_();
                this.setBuffers();
                this.editContext.preview(this.action.toPacket(Networking.createBuffer()));
                Pair<Map<CraftingProperty, Boolean>, Boolean> canPerform = this.action.fullCanPerform();
                this.craftButton.isEnabled = (Boolean)canPerform.getSecond();
                this.warnings.clear();
                ItemStack crafted = this.editContext.getItemstack().m_41777_();
                if (ItemStack.m_41728_((ItemStack)previewStack, (ItemStack)crafted)) {
                    this.warnings.add((Component)Component.m_237115_((String)"miapi.ui.craft.result_equal_warning"));
                    this.craftButton.isEnabled = false;
                }
                if (previewStack.m_41773_() > previewStack.m_41776_()) {
                    this.warnings.add((Component)Component.m_237115_((String)"miapi.ui.craft.warning.durability_negative"));
                    this.craftButton.isEnabled = false;
                }
                ((Map)canPerform.getFirst()).forEach((property, result) -> {
                    Component warning;
                    if (!result.booleanValue() && (warning = property.getWarning()) != null && !warning.getString().isEmpty()) {
                        this.warnings.add(warning);
                    }
                });
            }
        }
        catch (Exception e) {
            Miapi.LOGGER.error("surpressed", (Throwable)e);
        }
    }

    public void closeSlot() {
        this.currentSlots.forEach(slot -> {
            if (slot instanceof MutableSlot) {
                MutableSlot mutableSlot = (MutableSlot)((Object)slot);
                mutableSlot.setEnabled(true);
            }
            this.editContext.removeSlot((Slot)slot);
        });
    }

    public void addGui(InteractAbleWidget widget) {
        if (this.children.contains((Object)widget)) {
            return;
        }
        widget.m_252865_(this.m_252754_());
        widget.m_253211_(this.m_252907_());
        widget.m_93674_(this.f_93618_);
        widget.setHeight(this.f_93619_);
        this.currentSlots.forEach(slot -> {
            if (slot instanceof MutableSlot) {
                MutableSlot mutableSlot = (MutableSlot)((Object)slot);
                mutableSlot.setEnabled(false);
            }
        });
        CraftingProperty property = this.craftingProperties.get(this.craftingGuis.indexOf((Object)widget));
        this.action.forEachCraftingProperty(this.action.getPreview(), (craftingProperty, module, inventory, start, end, buffer) -> {
            if (craftingProperty.equals(property)) {
                AtomicInteger counter = new AtomicInteger(0);
                property.getSlotPositions().forEach(vec2f -> {
                    int guiX = widget.m_252754_() + (int)vec2f.f_82470_;
                    int guiY = widget.m_252907_() + (int)vec2f.f_82471_;
                    Matrix4f inverse = new Matrix4f((Matrix4fc)this.currentMatrix);
                    Vector4f vector4f = TransformableWidget.transFormMousePos(guiX, guiY, inverse);
                    guiX = (int)(vector4f.x() - (float)((Minecraft.m_91087_().f_91080_.f_96543_ - this.backgroundWidth) / 2));
                    guiY = (int)(vector4f.y() - (float)((Minecraft.m_91087_().f_91080_.f_96544_ - this.backgroundHeight) / 2));
                    MutableSlot slot = new MutableSlot(this.editContext.getLinkedInventory(), start + counter.getAndAdd(1), guiX, guiY);
                    this.currentSlots.add(slot);
                    this.editContext.addSlot(slot);
                });
            }
        });
        this.addChild(widget);
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.currentMatrix = drawContext.m_280168_().m_85850_().m_252922_();
        if (this.firstRender) {
            this.update();
            this.firstRender = false;
        }
        if (!this.craftingGuis.isEmpty()) {
            this.addGui(this.craftingGuis.get(this.currentGuiIndex));
        } else {
            this.addChild(this.fallbackCraftingWidget);
        }
        super.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    public void setBuffers() {
        HashMap<String, String> data = new HashMap<String, String>(this.defaultMap);
        this.action.forEachCraftingProperty(this.editContext.getItemstack(), (craftingProperty, moduleInstance, itemStacks, invStart, invEnd, buf) -> {
            int index = this.craftingProperties.indexOf(craftingProperty);
            if (index >= 0) {
                craftingProperty.writeData(data, this.craftingGuis.get(this.craftingProperties.indexOf(craftingProperty)), this.editContext);
            } else {
                craftingProperty.writeData(data, null, this.editContext);
            }
        });
        this.action.setData(data);
    }

    public static class PageButton<T>
    extends SimpleButton<T> {
        private boolean isLeft;
        private ResourceLocation texture;
        private boolean isClicked;
        private ResourceLocation right = new ResourceLocation("miapi", "textures/button_right.png");
        private ResourceLocation left = new ResourceLocation("miapi", "textures/button_left.png");

        public PageButton(int x, int y, int width, int height, boolean isLeft, T toCallBack, Consumer<T> callback) {
            super(x, y, width, height, (Component)Component.m_237119_(), toCallBack, callback);
            this.isLeft = isLeft;
            this.texture = isLeft ? this.left : this.right;
        }

        @Override
        public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.m_88315_(context, mouseX, mouseY, delta);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int textureOffset = 0;
            if (this.isClicked) {
                textureOffset = 20;
                if (!this.m_5953_(mouseX, mouseY)) {
                    this.isClicked = false;
                }
            } else if (this.m_5953_(mouseX, mouseY)) {
                textureOffset = 10;
            }
            if (!this.isEnabled) {
                textureOffset = 30;
            }
            context.m_280398_(this.texture, this.m_252754_(), this.m_252907_(), 0, (float)textureOffset, 0.0f, this.f_93618_, this.f_93619_, 40, this.f_93619_);
        }
    }

    public class CraftButton<T>
    extends SimpleButton<T> {
        public HoverDescription hover;

        public CraftButton(int x, int y, int width, int height, Component title, T toCallback, Consumer<T> callback) {
            super(x, y, width, height, title, toCallback, callback);
            this.hover = new HoverDescription(x, y + height, List.of());
        }

        @Override
        public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            super.m_88315_(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            if (!this.isEnabled && this.m_5953_(mouseX, mouseY)) {
                MutableComponent text = Component.m_237115_((String)"miapi.ui.craft.warning").m_130940_(ChatFormatting.RED);
                this.hover.addText((Component)text);
                this.hover.m_252865_(this.m_252754_());
                this.hover.m_253211_(this.m_252907_() + this.m_93694_());
                for (Component warning : CraftViewRework.this.warnings) {
                    this.hover.addText((Component)Component.m_237113_((String)" - ").m_7220_(warning).m_130940_(ChatFormatting.RED));
                }
                this.hover.m_88315_(drawContext, mouseX, mouseY, delta);
                this.hover.reset();
            }
        }
    }
}

