/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class DetailView
extends InteractAbleWidget {
    final Consumer<SlotProperty.ModuleSlot> selectConsumer;
    final Map<SlotProperty.ModuleSlot, SlotButton> buttonMap = new HashMap<SlotProperty.ModuleSlot, SlotButton>();
    SlotProperty.ModuleSlot selectedSlot;
    ScrollList scrollList;
    public static int scrollPos = 0;

    public DetailView(int x, int y, int width, int height, SlotProperty.ModuleSlot baseSlot, SlotProperty.ModuleSlot selected, Consumer<SlotProperty.ModuleSlot> edit, Consumer<SlotProperty.ModuleSlot> replace, String slotType) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.selectedSlot = selected;
        if (baseSlot != null) {
            this.scrollList = new ScrollList(x, y, width, height, this.getButtons(baseSlot, new ArrayList<InteractAbleWidget>(), 0, slotType));
            this.addChild(this.scrollList);
            this.scrollList.setScrollAmount(scrollPos);
        }
        this.selectConsumer = edit;
    }

    public List<InteractAbleWidget> getButtons(SlotProperty.ModuleSlot slot, List<InteractAbleWidget> buttons, int level, String slotType) {
        int nextLevel;
        if (slot.slotType.equals(slotType)) {
            buttons.add(new SlotButton(0, 0, 50, 22, slot, level));
            nextLevel = level + 1;
        } else {
            nextLevel = level;
        }
        if (slot.inSlot != null) {
            SlotProperty.getSlots(slot.inSlot).forEach((id, childSlot) -> {
                if (childSlot.slotType.equals(slotType)) {
                    this.getButtons((SlotProperty.ModuleSlot)childSlot, buttons, nextLevel, slotType);
                }
            });
        }
        return buttons;
    }

    public void select(SlotProperty.ModuleSlot slot) {
        scrollPos = this.scrollList.getScrollAmount();
        this.selectedSlot = slot;
        this.selectConsumer.accept(slot);
    }

    public void scrollTo(int y) {
        if (this.scrollList != null) {
            this.scrollList.setScrollAmount(y - this.m_252907_());
        }
    }

    class SlotButton
    extends InteractAbleWidget {
        private final List<SlotButton> subSlots;
        private final ScrollingTextWidget moduleName;
        private final ScrollingTextWidget materialName;
        private final SlotProperty.ModuleSlot slot;
        private final Material material;
        private final int level;
        private boolean isOpened;
        private boolean isSelected;

        public SlotButton(int x, int y, int width, int height, SlotProperty.ModuleSlot slot, int level) {
            boolean hasNoModule;
            super(x, y, width, height, (Component)Component.m_237119_());
            this.subSlots = new ArrayList<SlotButton>();
            this.isOpened = false;
            this.isSelected = false;
            this.slot = slot;
            this.level = level;
            ItemModule.ModuleInstance moduleInstance = slot.inSlot;
            boolean bl = hasNoModule = moduleInstance == null;
            if (hasNoModule) {
                moduleInstance = new ItemModule.ModuleInstance(ItemModule.empty);
            }
            Component materialNameText = StatResolver.translateAndResolve("[translation.[material.translation]]", moduleInstance);
            this.material = MaterialProperty.getMaterial(moduleInstance);
            Component displayText = StatResolver.translateAndResolve("miapi.module." + moduleInstance.module.getName(), moduleInstance);
            if (hasNoModule && slot.translationKey != null) {
                displayText = Component.m_237115_((String)slot.translationKey);
            }
            this.moduleName = new ScrollingTextWidget(this.m_252754_() + 10, this.m_252907_(), this.f_93618_ - 20, displayText, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.materialName = new ScrollingTextWidget(this.m_252754_() + 10, this.m_252907_(), this.f_93618_ - 20, materialNameText, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.materialName.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            DetailView.this.buttonMap.put(slot, this);
        }

        @Override
        public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            super.m_88315_(drawContext, mouseX, mouseY, delta);
            int hoverOffset = 0;
            if (this.m_5953_(mouseX, mouseY)) {
                hoverOffset = 1;
            }
            if (this.m_198029_()) {
                hoverOffset = 2;
            }
            SlotButton.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.m_252754_() + (this.level - 1) * 2, this.m_252907_(), 404, 18 * hoverOffset, 108, 18, this.m_5711_() - (this.level - 1) * 2, this.m_93694_(), 512, 512, 4);
            int nameStart = this.m_252754_() + 5 + (this.level - 1) * 2;
            if (this.material != null && this.material.hasIcon()) {
                nameStart += 1 + this.material.renderIcon(drawContext, this.m_252754_() + 5 + (this.level - 1) * 2, this.m_252907_() + 3);
            }
            this.moduleName.m_252865_(nameStart);
            this.moduleName.m_253211_(this.m_252907_() + 7);
            this.moduleName.m_93674_(this.m_5711_() + this.m_252754_() - nameStart - 4);
            this.moduleName.m_88315_(drawContext, mouseX, mouseY, delta);
        }

        public boolean m_198029_() {
            if (this.slot == DetailView.this.selectedSlot) {
                return true;
            }
            return this.slot != null && this.slot.equals(DetailView.this.selectedSlot);
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0 && this.m_5953_(mouseX, mouseY)) {
                this.playClickedSound();
                DetailView.this.select(this.slot);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }
}

