/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.edit_options.ReplaceOption;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;

public class PreviewManager {
    @Nullable
    public static Material currentPreviewMaterial = null;
    public static ItemStack currentPreviewMaterialStack = ItemStack.f_41583_;
    private static ItemStack cursorStack = ItemStack.f_41583_;
    private static Material lastFramePreviewMaterial = null;
    public static boolean isOpen = false;

    public static void setCursorItemstack(ItemStack itemstack) {
        if (isOpen && cursorStack != itemstack) {
            Material material = MaterialProperty.getMaterialFromIngredient(itemstack);
            if (material != currentPreviewMaterial) {
                cursorStack = itemstack;
                PreviewManager.updateMaterial(material, cursorStack);
            }
            if (Minecraft.m_91087_().f_91080_ instanceof CraftingScreen) {
                isOpen = false;
            }
        }
    }

    public static void resetCursorStack() {
        PreviewManager.setCursorItemstack(ItemStack.f_41583_);
    }

    public static void resetPreview() {
        ReplaceOption.resetPreview();
    }

    public static boolean hasValidPreview() {
        return currentPreviewMaterial != null;
    }

    public static void updateMaterial(Material material, ItemStack itemStack) {
        currentPreviewMaterial = material;
        currentPreviewMaterialStack = itemStack;
    }

    public static void tick() {
        isOpen = true;
        if (lastFramePreviewMaterial != currentPreviewMaterial) {
            lastFramePreviewMaterial = currentPreviewMaterial;
            if (CraftingScreen.getInstance() != null) {
                CraftingScreen craftingScreen = CraftingScreen.getInstance();
                ItemStack currentStack = craftingScreen.getItem();
                if (currentStack.m_41619_() && craftingScreen.getEditOption() == null) {
                    if (!(cursorStack.m_41720_() instanceof ModularItem) && currentPreviewMaterial != null) {
                        craftingScreen.updatePreviewItemStack(cursorStack);
                    }
                } else {
                    ReplaceOption.tryPreview();
                    String string = currentPreviewMaterial == null ? "empty" : currentPreviewMaterial.getKey();
                }
            }
        }
    }
}

