/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.MutableSlot;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.AllowedSlots;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

public class CraftingScreenHandler
extends AbstractContainerMenu {
    private final ContainerLevelAccess context;
    private static final String PACKET_ID = ":crafting_packet_";
    public Container inventory;
    public Inventory playerInventory;
    @Nullable
    public ModularWorkBenchEntity blockEntity;
    public final ContainerData delegate;
    public final String packetID;
    public final String editPacketID;
    public final String packetIDSlotAdd;
    public final String packetIDSlotRemove;
    public CraftingScreenHandler craftingScreenHandler;
    private List<Slot> mutableSlots = new ArrayList<Slot>();
    public static int CLIENT_SLOT_ID = 36;
    public static int SERVER_SLOT_ID = 36;
    static final ResourceLocation[] EMPTY_ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] EQUIPMENT_SLOT_ORDER = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public CraftingScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, null, ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(7));
        this.craftingScreenHandler = this;
    }

    public CraftingScreenHandler(int syncId, Inventory playerInventory, ModularWorkBenchEntity benchEntity, ContainerData delegate) {
        this(syncId, playerInventory, benchEntity, ContainerLevelAccess.f_39287_, delegate);
        this.craftingScreenHandler = this;
    }

    public CraftingScreenHandler(int syncId, Inventory playerInventory, @Nullable ModularWorkBenchEntity benchEntity, ContainerLevelAccess context, ContainerData delegate) {
        super(RegistryInventory.craftingScreenHandler, syncId);
        int j;
        this.craftingScreenHandler = this;
        this.packetID = "miapi:crafting_packet_" + playerInventory.f_35978_.m_20149_() + "_" + syncId;
        this.editPacketID = "miapi:crafting_packet__edit_" + playerInventory.f_35978_.m_20149_() + "_" + syncId;
        this.packetIDSlotAdd = "miapi:crafting_packet__" + playerInventory.f_35978_.m_20149_() + "_" + syncId + "_slotAdd";
        this.packetIDSlotRemove = "miapi:crafting_packet__" + playerInventory.f_35978_.m_20149_() + "_" + syncId + "_slotRemove";
        this.delegate = delegate;
        this.playerInventory = playerInventory;
        this.blockEntity = benchEntity;
        if (playerInventory.f_35978_ instanceof ServerPlayer) {
            Networking.registerC2SPacket(this.packetID, (buffer, player) -> {
                CraftAction action = new CraftAction((FriendlyByteBuf)buffer, this.blockEntity);
                Miapi.server.execute(() -> {
                    action.setItem(this.inventory.m_8020_(0));
                    action.linkInventory(this.inventory, 1);
                    if (action.canPerform()) {
                        ItemStack stack = action.perform();
                        this.inventory.m_6836_(0, stack);
                        if (this.blockEntity != null) {
                            this.blockEntity.setItem(stack);
                            this.blockEntity.saveAndSync();
                        }
                        this.m_6199_(this.inventory);
                    }
                });
            });
            Networking.registerC2SPacket(this.packetIDSlotAdd, (buffer, player) -> {
                int invId = buffer.readInt();
                int slotId = buffer.readInt();
                Miapi.server.execute(() -> {
                    Slot slot = new Slot(this.inventory, invId, 0, 0);
                    slot.f_40219_ = slotId;
                    this.mutableSlots.add(slot);
                    this.m_38897_(slot);
                    slot.f_40219_ = slotId;
                });
            });
            Networking.registerC2SPacket(this.packetIDSlotRemove, (buffer, player) -> {
                int slotId = buffer.readInt();
                Miapi.server.execute(() -> {
                    Slot slot = this.m_38853_(slotId);
                    this.mutableSlots.remove(slot);
                    this.m_7648_(playerInventory.f_35978_, slotId);
                });
            });
            Networking.registerC2SPacket(this.editPacketID, (buffer, player) -> {
                EditOption option = RegistryInventory.editOptions.get(buffer.m_130277_());
                int[] intArray = buffer.m_130100_();
                final ItemStack stack = ModularItemStackConverter.getModularVersion(this.inventory.m_8020_(0));
                ItemModule.ModuleInstance root = ItemModule.getModules(stack);
                ArrayList<Integer> position = new ArrayList<Integer>();
                for (int value : intArray) {
                    position.add(value);
                }
                final ItemModule.ModuleInstance current = root.getPosition(position).copy();
                SlotProperty.ModuleSlot slot = SlotProperty.getSlotIn(current);
                if (slot == null && current != null && current.module != null) {
                    slot = new SlotProperty.ModuleSlot(AllowedSlots.getAllowedSlots(current.module));
                }
                assert (option != null);
                final SlotProperty.ModuleSlot finalSlot = slot;
                EditOption.EditContext editContext = new EditOption.EditContext(){
                    final /* synthetic */ ServerPlayer val$player;
                    {
                        this.val$player = serverPlayer;
                    }

                    @Override
                    public void craft(FriendlyByteBuf craftBuffer) {
                    }

                    @Override
                    public void preview(FriendlyByteBuf preview) {
                    }

                    @Override
                    public SlotProperty.ModuleSlot getSlot() {
                        return finalSlot;
                    }

                    @Override
                    public ItemStack getItemstack() {
                        return stack == null ? ItemStack.f_41583_ : stack;
                    }

                    @Override
                    @Nullable
                    public ItemModule.ModuleInstance getInstance() {
                        return current;
                    }

                    @Override
                    @Nullable
                    public Player getPlayer() {
                        return this.val$player;
                    }

                    @Override
                    @Nullable
                    public ModularWorkBenchEntity getWorkbench() {
                        return CraftingScreenHandler.this.blockEntity;
                    }

                    @Override
                    public Container getLinkedInventory() {
                        return CraftingScreenHandler.this.inventory;
                    }

                    @Override
                    public CraftingScreenHandler getScreenHandler() {
                        return CraftingScreenHandler.this.craftingScreenHandler;
                    }
                };
                if (option.isVisible(editContext)) {
                    ItemStack editedStack = option.execute((FriendlyByteBuf)buffer, editContext);
                    Miapi.server.execute(() -> {
                        this.inventory.m_6836_(0, editedStack);
                        if (this.blockEntity != null) {
                            this.blockEntity.setItem(editedStack);
                            this.blockEntity.saveAndSync();
                        }
                        this.inventory.m_6596_();
                        this.m_6199_(this.inventory);
                    });
                } else {
                    Miapi.LOGGER.warn("ERROR - Couldn`t verify craft action from client " + player.m_20149_() + " " + player.m_5446_().getString() + " This might be a bug or somebody is trying to exploit");
                    Miapi.LOGGER.warn(String.valueOf(current));
                    Miapi.LOGGER.warn(((Object)position).toString());
                }
            });
        }
        this.context = context;
        this.inventory = new SimpleContainer(54){

            public void m_6596_() {
                super.m_6596_();
                CraftingScreenHandler.this.m_6199_((Container)this);
            }
        };
        if (this.blockEntity != null) {
            this.setItem(this.blockEntity.getItem());
        }
        int yOffset = 131;
        int xOffset = 210;
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new PlayerInventorySlot(playerInventory, k + j * 9 + 9, k * 18 + xOffset - 15, j * 18 + yOffset - 14));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new PlayerInventorySlot(playerInventory, j, j * 18 + xOffset - 15, 58 + yOffset - 14));
        }
        ModifyingSlot slot = new ModifyingSlot(this.inventory, 0, 34, 176, this.blockEntity);
        this.m_38897_(slot);
        OptionalInt optional = this.m_182417_(this.inventory, 0);
        if (optional.isPresent()) {
            if (this.notClient()) {
                SERVER_SLOT_ID = optional.getAsInt();
            } else {
                CLIENT_SLOT_ID = optional.getAsInt();
            }
        }
        for (int i = 0; i < 4; ++i) {
            final EquipmentSlot equipmentSlot = EQUIPMENT_SLOT_ORDER[i];
            int offset = i < 2 ? 0 : 1;
            this.m_38897_(new Slot((Container)playerInventory, 39 - i, 84 + i * 18 - offset - 15, 175){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return equipmentSlot == Mob.m_147233_((ItemStack)stack);
                }

                public boolean m_8010_(Player playerEntity) {
                    ItemStack itemStack = this.m_7993_();
                    if (!itemStack.m_41619_() && !playerEntity.m_7500_() && EnchantmentHelper.m_44920_((ItemStack)itemStack)) {
                        return false;
                    }
                    return super.m_8010_(playerEntity);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_ARMOR_SLOT_TEXTURES[equipmentSlot.m_20749_()]);
                }
            });
        }
        this.m_38897_(new Slot((Container)playerInventory, 40, 140, 175){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.m_38884_(delegate);
    }

    public boolean notClient() {
        return !this.playerInventory.f_35978_.m_9236_().f_46443_;
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.notClient() && !ItemStack.m_41728_((ItemStack)this.inventory.m_8020_(0), (ItemStack)this.blockEntity.getItem())) {
            this.blockEntity.setItem(this.inventory.m_8020_(0));
            this.blockEntity.saveAndSync();
        }
        if (this.blockEntity == null && this.delegate.m_6413_(0) == 1) {
            short xsh = (short)this.delegate.m_6413_(1);
            short xsl = (short)this.delegate.m_6413_(2);
            int x = xsh << 16 | xsl & 0xFFFF;
            short ysh = (short)this.delegate.m_6413_(3);
            short ysl = (short)this.delegate.m_6413_(4);
            int y = ysh << 16 | ysl & 0xFFFF;
            short zsh = (short)this.delegate.m_6413_(5);
            short zsl = (short)this.delegate.m_6413_(6);
            int z = zsh << 16 | zsl & 0xFFFF;
            BlockEntity be = this.playerInventory.f_35978_.m_9236_().m_7702_(new BlockPos(x, y, z));
            if (be instanceof ModularWorkBenchEntity) {
                ModularWorkBenchEntity casted;
                this.blockEntity = casted = (ModularWorkBenchEntity)be;
            }
        }
        this.updateBE();
    }

    public void removeSlotByClient(Slot slot) {
        if (!this.f_38839_.contains((Object)slot)) {
            return;
        }
        this.m_7648_(this.playerInventory.f_35978_, slot.f_40219_);
        slot.m_6654_();
        if (slot instanceof MutableSlot) {
            MutableSlot mutableSlot = (MutableSlot)slot;
            mutableSlot.setEnabled(false);
        }
        this.playerInventory.m_6596_();
        this.inventory.m_6596_();
        FriendlyByteBuf buf = Networking.createBuffer();
        buf.writeInt(slot.f_40219_);
        this.mutableSlots.remove(slot);
        Networking.sendC2S(this.packetIDSlotRemove, buf);
    }

    public void clearSlots() {
        this.f_38839_.stream().filter(MutableSlot.class::isInstance).forEach(this::removeSlotByClient);
    }

    public void addSlotByClient(Slot slot) {
        if (this.f_38839_.contains((Object)slot)) {
            return;
        }
        this.m_38897_(slot);
        FriendlyByteBuf buf = Networking.createBuffer();
        buf.writeInt(slot.m_150661_());
        buf.writeInt(slot.f_40219_);
        this.mutableSlots.add(slot);
        Networking.sendC2S(this.packetIDSlotAdd, buf);
        slot.m_6654_();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.context.m_39292_((world, pos) -> this.m_150411_(player, this.inventory));
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack;
            if (i == 0 || (stack = this.inventory.m_8020_(i)).m_41619_()) continue;
            if (!player.m_150109_().m_36054_(stack)) {
                player.m_36176_(stack, false);
            }
            this.inventory.m_6836_(i, ItemStack.f_41583_);
        }
        Networking.unRegisterC2SPacket(this.packetID);
        Networking.unRegisterC2SPacket(this.packetIDSlotAdd);
        Networking.unRegisterC2SPacket(this.packetIDSlotRemove);
        Networking.unRegisterC2SPacket(this.editPacketID);
        if (this.notClient() && this.blockEntity != null) {
            this.blockEntity.saveAndSync();
        }
    }

    public void setItem(ItemStack stack) {
        this.inventory.m_6836_(0, stack);
        this.inventory.m_6596_();
        if (this.blockEntity != null) {
            this.blockEntity.setItem(stack);
            if (this.notClient()) {
                this.blockEntity.saveAndSync();
            }
        }
    }

    private void updateBE() {
        if (this.notClient()) {
            this.blockEntity.setItem(this.inventory.m_8020_(0));
            this.blockEntity.saveAndSync();
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        int id;
        this.inventory.m_6596_();
        Slot slot = (Slot)this.f_38839_.get(index);
        int n = id = this.notClient() ? SERVER_SLOT_ID : CLIENT_SLOT_ID;
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            if (index == id || index > 41) {
                slot.m_142406_(player, itemStack2);
                if (!this.m_38903_(itemStack2, 37, 41, true)) {
                    this.m_38903_(itemStack2, 0, 36, true);
                }
                if (index == id && this.blockEntity != null) {
                    this.blockEntity.setItem(itemStack2);
                    if (this.notClient()) {
                        this.blockEntity.saveAndSync();
                    }
                }
                slot.m_6654_();
                return ItemStack.f_41583_;
            }
            for (Slot slot1 : this.mutableSlots) {
                if (slot1.f_40219_ < 36 || this.m_38903_(itemStack2, slot1.f_40219_, slot1.f_40219_ + 1, true)) continue;
                return ItemStack.f_41583_;
            }
            if ((((Slot)this.f_38839_.get(id)).m_7993_().m_41619_() || ((Slot)this.f_38839_.get(id)).m_7993_().m_41720_().equals(itemStack2.m_41720_())) && !this.m_38903_(itemStack2, id, id + 1, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }

    protected void m_150411_(Player player, Container inventory) {
        ServerPlayer serverPlayerEntity;
        if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayerEntity = (ServerPlayer)player).m_9232_()) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (i == 0) continue;
                player.m_36176_(inventory.m_8016_(i), false);
            }
            return;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (i == 0) continue;
            Inventory currentPlayerInv = player.m_150109_();
            if (!(currentPlayerInv.f_35978_ instanceof ServerPlayer)) continue;
            currentPlayerInv.m_150079_(inventory.m_8016_(i));
        }
    }

    public static class PlayerInventorySlot
    extends Slot {
        public PlayerInventorySlot(Inventory inventory, int index, int x, int y) {
            super((Container)inventory, index, x, y);
        }
    }

    public static class ModifyingSlot
    extends Slot {
        protected final ModularWorkBenchEntity blockEntity;

        public ModifyingSlot(Container inventory, int index, int x, int y, ModularWorkBenchEntity blockEntity) {
            super(inventory, index, x, y);
            this.blockEntity = blockEntity;
        }

        public boolean notClient() {
            return this.blockEntity != null && this.blockEntity.m_58898_() && !this.blockEntity.m_58904_().f_46443_;
        }

        public boolean m_5857_(ItemStack stack) {
            return true;
        }

        public int m_6641_() {
            return 64;
        }

        public void m_269060_(ItemStack stack) {
            super.m_269060_(stack);
            if (this.notClient()) {
                this.blockEntity.setItem(stack);
                this.blockEntity.saveAndSync();
            }
            this.m_6654_();
        }
    }
}

