/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.TransformableWidget;

@OnlyIn(value=Dist.CLIENT)
public class ScrollingTextWidget
extends InteractAbleWidget
implements Renderable,
GuiEventListener {
    private Component text;
    private float timer = 0.0f;
    private int scrollPosition = 0;
    public int textColor;
    public float scrollDelay = 0.5f;
    public float scrollHoldTime = 2.0f;
    public float firstLetterExtraTime = 1.0f;
    public boolean hasTextShadow = true;
    private Orientation orientation;

    public ScrollingTextWidget(int x, int y, int maxWidth, Component text, int textColor) {
        super(x, y, maxWidth, 9, (Component)Component.m_237119_());
        this.textColor = textColor;
        this.setText(text);
        this.orientation = Orientation.LEFT;
    }

    public ScrollingTextWidget(int x, int y, int maxWidth, Component text) {
        super(x, y, maxWidth, 9, (Component)Component.m_237119_());
        this.textColor = -1;
        this.setText(text);
        this.orientation = Orientation.LEFT;
    }

    public void setText(Component text) {
        this.text = text;
        this.scrollPosition = 0;
        this.timer = -this.firstLetterExtraTime;
    }

    public Component getText() {
        return this.text;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text);
        boolean scissorEnabled = false;
        int textStart = this.m_252754_();
        switch (this.orientation) {
            case CENTERED: {
                textStart += (this.f_93618_ - textWidth) / 2;
                break;
            }
            case RIGHT: {
                textStart += this.f_93618_ - textWidth;
            }
        }
        if (textWidth > this.f_93618_) {
            String string = this.text.getString();
            int offsetAmount = 0;
            boolean stallScrollPos = false;
            if (this.scrollPosition < string.length()) {
                String sub = string.substring(0, this.scrollPosition);
                String remaining = string.substring(Math.min(string.length() - 1, this.scrollPosition + 1));
                int subLength = Minecraft.m_91087_().f_91062_.m_92895_(sub);
                int remainingLength = Minecraft.m_91087_().f_91062_.m_92895_(remaining);
                offsetAmount = -subLength;
                if (remainingLength <= this.f_93618_) {
                    stallScrollPos = true;
                }
            }
            this.timer += delta / 20.0f;
            if (this.timer > this.scrollDelay && !stallScrollPos) {
                ++this.scrollPosition;
                this.timer = 0.0f;
            }
            if (this.timer > this.scrollHoldTime && stallScrollPos) {
                this.scrollPosition = 0;
                this.timer = -this.firstLetterExtraTime;
            }
            textStart += offsetAmount;
            Vector4f corner1 = TransformableWidget.transFormMousePos(this.m_252754_(), this.m_252907_(), context.m_280168_().m_85850_().m_252922_());
            Vector4f corner2 = TransformableWidget.transFormMousePos(this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, context.m_280168_().m_85850_().m_252922_());
            context.m_280588_((int)corner1.x, (int)corner1.y, (int)corner2.x + 1, (int)corner2.y);
            scissorEnabled = true;
        }
        if (this.text != null) {
            context.m_280614_(Minecraft.m_91087_().f_91062_, this.text, textStart, this.m_252907_(), this.textColor, this.hasTextShadow);
        }
        if (scissorEnabled) {
            context.m_280618_();
        }
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public int getRequiredWidth() {
        return Math.min(this.f_93618_, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text));
    }

    public static enum Orientation {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

