/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;

@OnlyIn(value=Dist.CLIENT)
public class ScrollList
extends InteractAbleWidget {
    private List<InteractAbleWidget> widgets = null;
    private int scrollAmount = 0;
    private int maxScrollAmount = 0;
    public boolean saveMode = true;
    boolean needsScrollbar = false;
    public boolean alwaysEnableScrollbar = false;
    int barWidth = 8;
    boolean scrollbarDragged = false;
    public boolean altDesign = false;

    public ScrollList(int x, int y, int width, int height, List<InteractAbleWidget> widgets) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.setList(widgets);
    }

    public void setList(List<InteractAbleWidget> widgets) {
        this.widgets = widgets;
        this.children().clear();
    }

    public void setScrollAmount(int amount) {
        this.scrollAmount = amount;
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.m_88315_(drawContext, mouseX, mouseY, delta);
        int totalHeight = 0;
        for (AbstractWidget abstractWidget : this.widgets) {
            totalHeight += abstractWidget.m_93694_();
        }
        this.maxScrollAmount = Math.max(0, totalHeight - this.f_93619_);
        if (this.widgets == null) {
            return;
        }
        this.scrollAmount = Math.max(0, Math.min(this.scrollAmount, this.maxScrollAmount));
        this.needsScrollbar = totalHeight > this.f_93619_;
        int startY = this.m_252907_() - this.scrollAmount;
        for (AbstractWidget abstractWidget : this.widgets) {
            if (startY + abstractWidget.m_93694_() >= this.m_252907_() && startY <= this.m_252907_() + this.f_93619_ - 1) {
                abstractWidget.m_253211_(startY);
                abstractWidget.m_252865_(this.m_252754_());
                if (this.showScrollbar()) {
                    abstractWidget.m_93674_(this.f_93618_ - this.barWidth);
                } else {
                    abstractWidget.m_93674_(this.f_93618_);
                }
                Matrix4f matrix4f = new Matrix4f((Matrix4fc)drawContext.m_280168_().m_85850_().m_252922_());
                Vector4f posX = TransformableWidget.transFormMousePos(this.m_252754_(), this.m_252907_(), matrix4f);
                Vector4f posY = TransformableWidget.transFormMousePos(this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, matrix4f);
                drawContext.m_280588_((int)posX.x(), (int)posX.y, (int)posY.x(), (int)posY.y());
                abstractWidget.m_88315_(drawContext, mouseX, mouseY, delta);
                drawContext.m_280618_();
            }
            startY += abstractWidget.m_93694_();
        }
        if (this.showScrollbar()) {
            int n = this.m_252754_() + this.f_93618_ - this.barWidth;
            float f = (float)this.scrollAmount / (float)this.maxScrollAmount;
            this.renderScrollbarBackground(drawContext, mouseX, mouseY, delta, n, this.barWidth);
            this.renderScrollbarClickAble(drawContext, mouseX, mouseY, delta, n, this.barWidth, f);
        }
    }

    public void renderScrollbarBackground(GuiGraphics drawContext, int mouseX, int mouseY, float delta, int barX, int barWidth) {
        int offsetAlt = this.altDesign ? 28 : 0;
        ScrollList.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, barX, this.m_252907_(), 498 - offsetAlt, 96, 14, 15, barWidth, this.m_93694_(), 512, 512, 3);
    }

    public void renderScrollbarClickAble(GuiGraphics drawContext, int mouseX, int mouseY, float delta, int barX, int barWidth, float percent) {
        int height = (int)((float)(this.m_93694_() - 17) * percent) + (this.altDesign ? (percent >= 1.0f ? 2 : 0) : 1) + this.m_252907_();
        int offset = this.needsScrollbar ? 0 : 15;
        int offsetAlt = this.altDesign ? 28 : 0;
        ScrollList.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, barX, height, 484 - offsetAlt, 96 + offset, 14, 15, barWidth, 15, 512, 512, 3);
    }

    private boolean showScrollbar() {
        return this.needsScrollbar || this.alwaysEnableScrollbar;
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.m_5953_(mouseX, mouseY)) {
            int startY = this.m_252907_() - this.scrollAmount;
            for (AbstractWidget abstractWidget : this.widgets) {
                if (startY + abstractWidget.m_93694_() >= this.m_252907_() && startY <= this.m_252907_() + this.f_93619_ - 1 && abstractWidget instanceof InteractAbleWidget) {
                    InteractAbleWidget interactAbleWidget = (InteractAbleWidget)abstractWidget;
                    abstractWidget.m_253211_(startY);
                    abstractWidget.m_252865_(this.m_252754_());
                    if (this.showScrollbar()) {
                        abstractWidget.m_93674_(this.f_93618_ - this.barWidth);
                    } else {
                        abstractWidget.m_93674_(this.f_93618_);
                    }
                    interactAbleWidget.renderHover(drawContext, mouseX, mouseY, delta);
                }
                startY += abstractWidget.m_93694_();
            }
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.widgets == null) {
            return false;
        }
        for (AbstractWidget abstractWidget : this.widgets) {
            if (!abstractWidget.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        int scrollSpeed = 10;
        this.scrollAmount = (int)((double)this.scrollAmount - amount * (double)scrollSpeed);
        return true;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.widgets != null) {
            for (InteractAbleWidget widget : this.widgets) {
                if (!widget.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.widgets != null) {
            for (InteractAbleWidget widget : this.widgets) {
                if (!widget.m_7920_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.widgets == null) {
                return false;
            }
            boolean clicked = false;
            if (this.showScrollbar() && this.m_5953_(mouseX, mouseY) && mouseX > (double)(this.m_252754_() + this.f_93618_ - this.barWidth) && mouseX < (double)(this.m_252754_() + this.f_93618_)) {
                this.scrollbarDragged = true;
                return true;
            }
            for (AbstractWidget abstractWidget : this.widgets) {
                if (!abstractWidget.m_5953_(mouseX, mouseY) || !abstractWidget.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX > (double)(this.m_252754_() + this.f_93618_ - this.barWidth) && mouseX < (double)(this.m_252754_() + this.f_93618_)) {
            if (mouseY < (double)this.m_252907_()) {
                this.scrollAmount = 0;
                return true;
            }
            if (mouseY > (double)(this.m_252907_() + this.f_93619_)) {
                this.scrollAmount = this.maxScrollAmount;
                return true;
            }
            double i = Math.min(1.0, Math.max(0.0, (mouseY - (double)this.m_252907_()) / (double)(this.m_93694_() - 10)));
            this.scrollAmount = (int)(i * (double)this.maxScrollAmount);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.widgets == null) {
            return false;
        }
        if (this.showScrollbar() && this.m_5953_(mouseX, mouseY) && mouseX > (double)(this.m_252754_() + this.f_93618_ - this.barWidth) && mouseX < (double)(this.m_252754_() + this.f_93618_)) {
            this.scrollbarDragged = false;
            return true;
        }
        boolean released = false;
        for (AbstractWidget abstractWidget : this.widgets) {
            if (!abstractWidget.m_6348_(mouseX, mouseY, button)) continue;
            released = true;
        }
        return released;
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return false;
        }
        double x = this.m_252754_();
        double y = this.m_252907_();
        double width = this.f_93618_;
        double height = this.f_93619_;
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }
}

