/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchRenderer;
import smartin.miapi.client.ShaderRegistry;
import smartin.miapi.client.atlas.MaterialAtlasManager;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.client.renderer.SpriteLoader;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.effects.CryoStatusEffect;
import smartin.miapi.entity.ItemProjectileRenderer;
import smartin.miapi.events.ClientEvents;
import smartin.miapi.modules.MiapiPermissions;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialCommand;
import smartin.miapi.modules.material.MaterialIcons;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class MiapiClient {
    public static MaterialAtlasManager materialAtlasManager;
    public static boolean shaderModLoaded;
    public static boolean sodiumLoaded;
    public static boolean jerLoaded;
    public static final MiapiRegistry<KeyMapping> KEY_BINDINGS;

    private MiapiClient() {
    }

    public static void init() {
        RegistryInventory.modularItems.addCallback(MiapiClient::registerAnimations);
        ClientTickEvent.CLIENT_PRE.register(instance -> {
            if (MiapiConfig.INSTANCE.client.other.animatedMaterials) {
                Minecraft.m_91087_().m_91307_().m_6180_("miapiMaterialAnimations");
                MaterialSpriteManager.tick();
                Minecraft.m_91087_().m_91307_().m_7238_();
            }
        });
        Networking.registerS2CPacket(MaterialCommand.SEND_MATERIAL_CLIENT, buf -> {
            String materialId = buf.m_130277_();
            Minecraft.m_91087_().execute(() -> {
                Material material = MaterialProperty.materials.get(materialId);
                if (material != null) {
                    String raw = Miapi.gson.toJson((JsonElement)material.getDebugJson());
                    MutableComponent text = Component.m_237113_((String)raw);
                    ClickEvent event = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, raw);
                    text = (Component)text.m_178405_(Style.f_131099_.m_131142_(event)).get(0);
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)text);
                }
            });
        });
        Networking.registerS2CPacket(CacheCommands.SEND_MATERIAL_CLIENT, buf -> Minecraft.m_91087_().execute(ModularItemCache::discardCache));
        ClientReloadShadersEvent.EVENT.register((resourceFactory, shadersSink) -> {
            ModularItemCache.discardCache();
            if (Minecraft.m_91087_().f_91073_ != null) {
                ReloadEvents.executeClientReload(Minecraft.m_91087_());
            }
        });
        MiapiClient.registerShaders();
        MaterialRenderControllers.setup();
        MaterialIcons.setup();
        ColorProvider.setup();
        ClientLifecycleEvent.CLIENT_SETUP.register(MiapiClient::clientSetup);
        ClientLifecycleEvent.CLIENT_STARTED.register(MiapiClient::clientStart);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(MiapiClient::clientLevelLoad);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> new Thread(() -> MiapiPermissions.getPerms((Player)player)).start());
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            String version;
            ModularItemCache.discardCache();
            if (jerLoaded && Miapi.server == null && ((version = Platform.getMod((String)"jeresources").getVersion()).equals("1.4.0.238") || version.equals("1.4.0.246") || version.equals("1.4.0.247"))) {
                player.m_213846_((Component)Component.m_237113_((String)"Just Enough Resources 1.20.1-1.4.0.247 Release is broken on servers. Please Remove it."));
                ClickEvent event = new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/way2muchnoise/JustEnoughResources/issues/392");
                MutableComponent link = Component.m_237113_((String)"For more information you can read this");
                player.m_213846_((Component)link.m_178405_(Style.f_131099_.m_131142_(event).m_131162_(Boolean.valueOf(true))).get(0));
                player.m_213846_((Component)Component.m_237113_((String)"This message was sent by Truly Modular."));
            }
        });
        ClientReloadShadersEvent.EVENT.register((resourceFactory, asd) -> {
            ModularItemCache.discardCache();
            ShaderRegistry.setup();
        });
        RegistryInventory.modularItems.addCallback(item -> {
            ModularModelPredicateProvider.registerModelOverride(item, new ResourceLocation("miapi", "damage"), (stack, world, entity, seed) -> stack.m_41763_() && stack.m_41773_() > 0 ? (float)stack.m_41773_() / (float)stack.m_41776_() : 0.0f);
            ModularModelPredicateProvider.registerModelOverride(item, new ResourceLocation("miapi", "damaged"), (stack, world, entity, seed) -> stack.m_41768_() ? 1.0f : 0.0f);
        });
        ReloadEvents.START.subscribe(isClient -> {
            if (isClient) {
                StatListWidget.onReload();
            }
        });
        ReloadEvents.END.subscribe(isClient -> {
            if (isClient) {
                StatListWidget.reloadEnd();
            }
        });
        if (sodiumLoaded) {
            ClientEvents.HUD_RENDER.register((drawContext, deltaTick) -> MaterialSpriteManager.onHudRender(drawContext));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerAnimations(Item item) {
        if (item.m_41465_()) {
            ModularModelPredicateProvider.registerModelOverride(item, new ResourceLocation("miapi", "damage"), (stack, world, entity, seed) -> stack.m_41763_() && stack.m_41768_() ? 0.0f : (float)stack.m_41776_() / (float)(stack.m_41776_() - stack.m_41773_()));
            ModularModelPredicateProvider.registerModelOverride(item, new ResourceLocation("miapi", "damaged"), (stack, world, entity, seed) -> stack.m_41768_() ? 0.0f : 1.0f);
        }
        ModularModelPredicateProvider.registerModelOverride(item, new ResourceLocation("miapi", "is_using"), (stack, world, entity, seed) -> {
            ItemStack itemStack;
            InteractionHand hand = entity.m_7655_();
            if (hand != null && (itemStack = entity.m_21120_(hand)) == stack) {
                return entity.m_21252_() > 0 ? 0.0f : 1.0f;
            }
            return 0.0f;
        });
    }

    public static boolean isSodiumLoaded() {
        return Platform.isModLoaded((String)"sodium") || Platform.isModLoaded((String)"embeddium") || Platform.isModLoaded((String)"magnesium") || Platform.isModLoaded((String)"rubidium");
    }

    public static boolean isHigherVersion(String version, String compareToVersion) {
        String[] versionParts = version.split("\\.");
        String[] compareToVersionParts = compareToVersion.split("\\.");
        for (int i = 0; i < versionParts.length && i < compareToVersionParts.length; ++i) {
            int part2;
            int part1 = Integer.parseInt(versionParts[i]);
            if (part1 > (part2 = Integer.parseInt(compareToVersionParts[i]))) {
                return true;
            }
            if (part1 >= part2) continue;
            return false;
        }
        return versionParts.length > compareToVersionParts.length;
    }

    protected static void clientSetup(Minecraft client) {
        MiapiClient.runOnClientEnsured(() -> {
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91097_();
            SpriteLoader.setup();
        });
    }

    public static void runOnClientEnsured(Runnable runnable) {
        if (RenderSystem.isOnRenderThreadOrInit()) {
            runnable.run();
        } else {
            Minecraft mc = Minecraft.m_91087_();
            mc.execute(runnable);
        }
    }

    protected static void clientStart(Minecraft client) {
        MiapiClient.runOnClientEnsured(() -> {
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91097_();
            materialAtlasManager = new MaterialAtlasManager(mc.m_91097_());
            ((ReloadableResourceManager)mc.m_91098_()).m_7217_((PreparableReloadListener)materialAtlasManager);
            CryoStatusEffect.setupOnClient();
        });
    }

    protected static void clientLevelLoad(ClientLevel clientWorld) {
        SpriteLoader.clientStart();
        ModularItemCache.discardCache();
    }

    public static void registerScreenHandler() {
        MenuRegistry.registerScreenFactory(RegistryInventory.craftingScreenHandler, CraftingScreen::new);
    }

    public static void registerEntityRenderer() {
        EntityRendererRegistry.register(RegistryInventory.itemProjectileType, ItemProjectileRenderer::new);
        EntityRendererRegistry.register(RegistryInventory.itemBoomerangProjectileType, ItemProjectileRenderer::new);
    }

    public static void registerBlockEntityRenderer() {
        BlockEntityRendererRegistry.register(RegistryInventory.modularWorkBenchEntityType, ModularWorkBenchRenderer::new);
    }

    public static void registerShaders() {
        MiapiClient.runOnClientEnsured(() -> {
            com.redpxnda.nucleus.impl.ShaderRegistry.register((ResourceLocation)new ResourceLocation("miapi", "rendertype_entity_translucent_material"), (VertexFormat)DefaultVertexFormat.f_85812_, s -> {
                ShaderRegistry.entityTranslucentMaterialShader = s;
            });
            com.redpxnda.nucleus.impl.ShaderRegistry.register((ResourceLocation)new ResourceLocation("miapi", "rendertype_item_glint"), (VertexFormat)DefaultVertexFormat.f_85812_, s -> {
                ShaderRegistry.glintShader = s;
            });
        });
    }

    static {
        shaderModLoaded = Platform.isModLoaded((String)"iris") || Platform.isModLoaded((String)"optifine") || Platform.isModLoaded((String)"optifabric") || Platform.isModLoaded((String)"oculus");
        sodiumLoaded = MiapiClient.isSodiumLoaded();
        jerLoaded = Platform.isModLoaded((String)"jeresources");
        KEY_BINDINGS = MiapiRegistry.getInstance(KeyMapping.class);
    }
}

