/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blueprint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResearchTree {
    public List<TreeNode> headNodes;
    public Map<Integer, List<TreeNode>> treeByLevel = new HashMap<Integer, List<TreeNode>>();

    public void setup(TreeNode rootNode) {
        this.addSubElement(0, rootNode);
    }

    private void addSubElement(int level, TreeNode blueprint) {
        List getByLevel = this.treeByLevel.getOrDefault(level, new ArrayList());
        getByLevel.add(blueprint);
        this.treeByLevel.put(0, getByLevel);
        for (TreeNode researchAbleBlueprint : blueprint.childEntries) {
            this.addSubElement(level + 1 + researchAbleBlueprint.levelOffset, researchAbleBlueprint);
        }
    }

    private void calculateHorizontalPositions(TreeNode node, int verticalOffset) {
        int avgHorizontalPos;
        for (int i = node.childEntries.size() - 1; i >= 0; --i) {
            this.calculateHorizontalPositions(node.childEntries.get(i), i + verticalOffset);
        }
        int totalHorizontalPos = node.childEntries.stream().mapToInt(child -> child.verticalPos).sum();
        node.verticalPos = avgHorizontalPos = node.childEntries.isEmpty() ? 0 : totalHorizontalPos / node.childEntries.size();
    }

    public class TreeNode {
        public List<TreeNode> prerequisites = new ArrayList<TreeNode>();
        public int levelOffset = 0;
        public int verticalPos = 0;
        public List<TreeNode> childEntries = new ArrayList<TreeNode>();
    }
}

