/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blueprint;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.blueprint.Blueprint;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.client.gui.crafting.crafter.replace.ReplaceView;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class BlueprintProperty
implements CraftingProperty,
ModuleProperty {
    public static String KEY = "blueprint";
    public static BlueprintProperty property;

    public BlueprintProperty() {
        property = this;
        if (Environment.isClient()) {
            this.setupClient();
        }
        PropertyResolver.register("blueprint", (moduleInstance, oldMap) -> {
            Blueprint blueprint;
            if (moduleInstance != null && moduleInstance.moduleData.containsKey("blueprint") && (blueprint = Blueprint.blueprintRegistry.get(moduleInstance.moduleData.get("blueprint"))) != null && !blueprint.writeToItem) {
                return ModuleProperty.mergeList(oldMap, blueprint.upgrades, MergeType.SMART);
            }
            return oldMap;
        });
        ReloadEvents.END.subscribe(isClient -> {
            Blueprint.blueprintRegistry.clear();
            RegistryInventory.modules.getFlatMap().forEach((s, module) -> {
                Blueprint blueprint = new Blueprint();
                blueprint.isAllowed = ConditionManager.get(null);
                blueprint.module = module;
                blueprint.key = "testing" + s;
            });
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient() {
        ReplaceView.optionSuppliers.add(option -> {
            ArrayList options = new ArrayList();
            Blueprint.blueprintRegistry.getFlatMap().forEach((key, blueprint) -> {
                HashMap<ModuleProperty, JsonElement> propertyMap = new HashMap();
                if (option.getInstance() != null) {
                    propertyMap = option.getInstance().getProperties();
                }
                BlockPos pos = option.getWorkbench() != null ? option.getWorkbench().m_58899_() : null;
                if (blueprint.isAllowed.isAllowed(new ConditionManager.ModuleConditionContext(option.getInstance(), pos, option.getPlayer(), propertyMap, new ArrayList<Component>())) && option.getSlot().allowedIn(new ItemModule.ModuleInstance(blueprint.module))) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    dataMap.put("blueprint", blueprint.key);
                    options.add(new CraftOption(blueprint.module, dataMap));
                }
            });
            return options;
        });
    }

    @Override
    public void writeData(Map<String, String> data, @Nullable InteractAbleWidget createdGui, EditOption.EditContext editContext) {
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        ItemModule.ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        String blueprintKey = data.get("blueprint");
        if (blueprintKey != null && newModule != null) {
            newModule.moduleData.put("blueprint", blueprintKey);
            Blueprint blueprint = Blueprint.blueprintRegistry.get(blueprintKey);
            if (blueprint != null && blueprint.writeToItem) {
                BlueprintProperty.writePropertiesToModule(newModule, blueprint.upgrades);
            }
            newModule.getRoot().writeToItem(old);
        }
        return old;
    }

    public static void writePropertiesToModule(ItemModule.ModuleInstance moduleInstance, Map<ModuleProperty, JsonElement> properties) {
        String rawProperties = moduleInstance.moduleData.get("properties");
        if (rawProperties != null) {
            HashMap<ModuleProperty, JsonElement> nextMap = new HashMap<ModuleProperty, JsonElement>(properties);
            JsonObject moduleJson = (JsonObject)Miapi.gson.fromJson(rawProperties, JsonObject.class);
            if (moduleJson != null) {
                moduleJson.entrySet().forEach(stringJsonElementEntry -> {
                    ModuleProperty property = RegistryInventory.moduleProperties.get((String)stringJsonElementEntry.getKey());
                    if (property != null) {
                        nextMap.put(property, (JsonElement)stringJsonElementEntry.getValue());
                    }
                });
            }
            moduleInstance.moduleData.put("properties", Miapi.gson.toJson(nextMap));
        }
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }
}

