/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.attributes;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import smartin.miapi.attributes.AttributeRegistry;

public class ElytraAttributes {
    public static Map<LivingEntity, Vec3> velocityMap = new WeakHashMap<LivingEntity, Vec3>();

    public static void movementUpdate(LivingEntity livingEntity) {
        if (!livingEntity.m_6109_()) {
            return;
        }
        if (velocityMap.containsKey(livingEntity) && livingEntity instanceof Player) {
            if (ElytraAttributes.isElytraFlying(livingEntity)) {
                Vec3 lastVelocity = ElytraAttributes.from(velocityMap.get(livingEntity));
                Vec3 currentVelocity = ElytraAttributes.from(livingEntity.m_20184_());
                double glideEfficiency = livingEntity.m_21204_().m_22181_(AttributeRegistry.ELYTRA_GLIDE_EFFICIENCY) / 100.0;
                double turnEfficiency = livingEntity.m_21204_().m_22181_(AttributeRegistry.ELYTRA_TURN_EFFICIENCY) / 100.0;
                double lastSpeed = lastVelocity.m_82553_();
                double currentSpeed = currentVelocity.m_82553_();
                if (Math.abs(Math.max(0.1, lastSpeed) / Math.max(0.1, currentSpeed) - 1.0) > 0.9) {
                    velocityMap.put(livingEntity, livingEntity.m_20184_());
                    return;
                }
                double horizontalDotProduct = currentVelocity.m_82541_().m_82526_(new Vec3(0.0, 1.0, 0.0));
                double horizontalRatio = Math.min(1.0, 1.0 + horizontalDotProduct);
                if (horizontalDotProduct > 0.1) {
                    horizontalRatio = 0.0;
                }
                double turnHorizontalRation = Math.min(1.0, (-horizontalDotProduct + 1.0) * 5.0);
                double directionChange = Math.min(1.0, (1.0 - ElytraAttributes.from(lastVelocity).m_82541_().m_82526_(ElytraAttributes.from(currentVelocity).m_82541_())) * 100.0);
                double speedLoss = Math.max(0.0, lastSpeed - currentSpeed);
                double speedRecovery = Math.min(1.0, directionChange * turnEfficiency * turnHorizontalRation + (1.0 - directionChange) * (glideEfficiency *= horizontalRatio));
                double speed = Math.max(1.0E-8, currentSpeed + speedLoss * speedRecovery);
                Vec3 vec3d = ElytraAttributes.from(currentVelocity);
                vec3d = ElytraAttributes.from(vec3d.m_82541_());
                vec3d = vec3d.m_82490_(speed);
                livingEntity.m_20256_(vec3d);
                velocityMap.put(livingEntity, livingEntity.m_20184_());
            } else {
                velocityMap.remove(livingEntity);
            }
        } else if (ElytraAttributes.isElytraFlying(livingEntity)) {
            velocityMap.put(livingEntity, livingEntity.m_20184_());
        }
    }

    private static Vec3 from(Vec3 vec3d) {
        if (vec3d == null) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        double x = Double.isNaN(vec3d.f_82479_) ? 0.0 : vec3d.f_82479_;
        double y = Double.isNaN(vec3d.f_82480_) ? 0.0 : vec3d.f_82480_;
        double z = Double.isNaN(vec3d.f_82481_) ? 0.0 : vec3d.f_82481_;
        return new Vec3(x, y, z);
    }

    static boolean isElytraFlying(LivingEntity livingEntity) {
        return livingEntity.m_21255_();
    }
}

