/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.attributes;

import com.redpxnda.nucleus.facet.Facet;
import com.redpxnda.nucleus.facet.FacetRegistry;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.entity.ShieldingArmorFacet;
import smartin.miapi.entity.StunHealthFacet;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.modules.abilities.util.WrappedSoundEvent;
import smartin.miapi.modules.properties.AttributeProperty;

public class AttributeRegistry {
    public static Map<String, Attribute> entityAttributeMap = new HashMap<String, Attribute>();
    public static Map<Player, Boolean> hasCrittedLast = new WeakHashMap<Player, Boolean>();
    public static Attribute REACH;
    public static Attribute ATTACK_RANGE;
    public static Attribute SWIM_SPEED;
    public static Attribute MINING_SPEED_PICKAXE;
    public static Attribute MINING_SPEED_AXE;
    public static Attribute MINING_SPEED_SHOVEL;
    public static Attribute MINING_SPEED_HOE;
    public static Attribute MAGIC_DAMAGE;
    public static Attribute STUN_DAMAGE;
    public static Attribute STUN_MAX_HEALTH;
    public static Attribute CRITICAL_DAMAGE;
    public static Attribute CRITICAL_CHANCE;
    public static Attribute DAMAGE_RESISTANCE;
    public static Attribute BACK_STAB;
    public static Attribute ARMOR_CRUSHING;
    public static Attribute SHIELD_BREAK;
    public static Attribute PROJECTILE_ARMOR;
    public static Attribute BOW_DRAW_TIME;
    public static Attribute PLAYER_ITEM_USE_MOVEMENT_SPEED;
    public static Attribute PROJECTILE_DAMAGE;
    @Deprecated
    public static Attribute PROJECTILE_CRIT_MULTIPLIER;
    public static Attribute PROJECTILE_SPEED;
    public static Attribute PROJECTILE_ACCURACY;
    public static Attribute PROJECTILE_PIERCING;
    public static Attribute ELYTRA_TURN_EFFICIENCY;
    public static Attribute ELYTRA_GLIDE_EFFICIENCY;
    public static Attribute ELYTRA_ROCKET_EFFICIENCY;
    public static Attribute SHIELDING_ARMOR;
    private static final UUID TEMP_CRIT_DMG_UUID;
    private static final UUID TEMP_CRIT_DMG_MULTIPLIER_UUID;
    private static final UUID TEMP_BACKSTAB_DMG_UUID;

    public static void setup() {
        FacetRegistry.ENTITY_FACET_ATTACHMENT.register((entity, attacher) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ShieldingArmorFacet facet = new ShieldingArmorFacet(livingEntity);
                attacher.add(ShieldingArmorFacet.KEY, (Facet)facet);
                StunHealthFacet stunHealthFacet = new StunHealthFacet(livingEntity);
                attacher.add(StunHealthFacet.KEY, (Facet)stunHealthFacet);
            }
        });
        MiapiEvents.LIVING_HURT_AFTER_ARMOR.register(livingHurt -> {
            Entity patt4567$temp;
            StunHealthFacet facet = (StunHealthFacet)StunHealthFacet.KEY.get((Entity)livingHurt.defender);
            if (livingHurt.damageSource != null && livingHurt.damageSource.m_7639_() != null && (patt4567$temp = livingHurt.damageSource.m_7639_()) instanceof LivingEntity) {
                double currentStunDamage;
                LivingEntity attacker = (LivingEntity)patt4567$temp;
                if (facet != null && !livingHurt.defender.m_9236_().m_5776_() && attacker.m_21204_().m_22171_(STUN_DAMAGE) && (currentStunDamage = attacker.m_21133_(STUN_DAMAGE)) > 0.1) {
                    facet.takeStunDamage((float)currentStunDamage, attacker);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER_ARMOR.register(livingHurt -> {
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((Entity)livingHurt.defender);
            if (facet != null && !livingHurt.defender.m_9236_().m_5776_() && livingHurt.damageSource != null && !livingHurt.damageSource.m_269533_(DamageTypeTags.f_268490_)) {
                livingHurt.amount = facet.takeDamage(livingHurt.amount);
                LivingEntity patt5705$temp = livingHurt.defender;
                if (patt5705$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)patt5705$temp;
                    if (serverPlayerEntity.f_8906_ != null && serverPlayerEntity.m_20152_() && !serverPlayerEntity.f_8944_) {
                        try {
                            facet.sendToClient(serverPlayerEntity);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_ENTITY_TICK_END.register(entity -> {
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((Entity)entity);
            if (facet != null && !entity.m_9236_().m_5776_()) {
                facet.tick();
            }
            return EventResult.pass();
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            ShieldingArmorFacet facet = (ShieldingArmorFacet)ShieldingArmorFacet.KEY.get((Entity)player);
            if (facet != null) {
                // empty if block
            }
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            if (livingHurtEvent.defender.m_21204_().m_22171_(DAMAGE_RESISTANCE)) {
                livingHurtEvent.amount = Math.max(0.0f, (float)((double)livingHurtEvent.amount * (100.0 - livingHurtEvent.defender.m_21133_(DAMAGE_RESISTANCE)) / 100.0));
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_ATTACK.register((attacker, defender) -> {
            double value;
            if (attacker != null && defender != null && attacker.m_21204_().m_22171_(MAGIC_DAMAGE) && (value = attacker.m_21133_(MAGIC_DAMAGE)) > 0.0) {
                defender.m_6469_(attacker.m_269291_().m_269425_(), (float)value);
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            LivingEntity attacker;
            Entity patt7856$temp;
            if (livingHurtEvent.damageSource != null && (patt7856$temp = livingHurtEvent.damageSource.m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)patt7856$temp).m_21204_().m_22171_(BACK_STAB) && livingHurtEvent.damageSource.m_7639_().m_20154_().m_82526_(livingHurtEvent.defender.m_20154_()) > 0.0) {
                attacker.m_21204_().m_22146_(BACK_STAB).m_22118_(new AttributeModifier(TEMP_BACKSTAB_DMG_UUID, "temp_backstab_base_damage", (double)livingHurtEvent.amount, AttributeModifier.Operation.ADDITION));
                livingHurtEvent.amount = (float)attacker.m_21133_(BACK_STAB);
                attacker.m_21204_().m_22146_(BACK_STAB).m_22120_(TEMP_BACKSTAB_DMG_UUID);
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            double projectileArmor;
            if (livingHurtEvent.damageSource != null && livingHurtEvent.damageSource.m_269533_(DamageTypeTags.f_268524_) && livingHurtEvent.defender.m_21204_().m_22171_(PROJECTILE_ARMOR) && (projectileArmor = livingHurtEvent.defender.m_21133_(PROJECTILE_ARMOR)) > 0.0) {
                double totalDamage = (double)livingHurtEvent.amount * (1.0 - Math.max(20.0, projectileArmor) / 25.0);
                livingHurtEvent.amount = (float)totalDamage;
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(livingHurtEvent -> {
            LivingEntity attacker;
            Entity patt9624$temp;
            if (livingHurtEvent.damageSource != null && (patt9624$temp = livingHurtEvent.damageSource.m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)patt9624$temp).m_21204_().m_22171_(SHIELD_BREAK)) {
                double value = attacker.m_21133_(SHIELD_BREAK);
                LivingEntity patt9861$temp = livingHurtEvent.defender;
                if (patt9861$temp instanceof Player) {
                    Player player = (Player)patt9861$temp;
                    if (value > 0.0 && player.m_21254_()) {
                        player.m_36335_().m_41524_(Items.f_42740_, (int)(value * 20.0));
                        player.m_5810_();
                        player.m_9236_().m_7605_((Entity)player, (byte)30);
                    }
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            LivingEntity attacker;
            Entity patt10530$temp;
            if (livingHurtEvent.damageSource != null && (patt10530$temp = livingHurtEvent.damageSource.m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)patt10530$temp).m_21204_().m_22171_(ARMOR_CRUSHING)) {
                double value = attacker.m_21133_(ARMOR_CRUSHING);
                ((LivingEntityAccessor)livingHurtEvent.defender).callDamageArmor(livingHurtEvent.damageSource, (float)((double)livingHurtEvent.defender.m_21230_() * value));
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_POST_HIT.register(listener -> {
            ItemProjectileEntity projectile = listener.projectile;
            Entity victim = listener.entityHitResult.m_82443_();
            Entity owner = listener.projectile.m_19749_();
            if (projectile.m_9236_() instanceof ServerLevel && projectile.m_9236_().m_46470_() && projectile.hasChanneling()) {
                BlockPos blockPos = victim.m_20183_();
                if (projectile.m_9236_().m_45527_(blockPos)) {
                    LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(projectile.m_9236_());
                    lightningEntity.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                    lightningEntity.m_20879_(owner instanceof ServerPlayer ? (ServerPlayer)owner : null);
                    projectile.m_9236_().m_7967_((Entity)lightningEntity);
                    projectile.hitEntitySound = new WrappedSoundEvent(SoundEvents.f_12521_, 5.0f, 1.0f);
                }
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(listener -> {
            ItemProjectileEntity projectile = listener.projectile;
            if (projectile.m_36792_()) {
                listener.damage = (float)((double)listener.damage * AttributeProperty.getActualValue(projectile.m_7941_(), EquipmentSlot.MAINHAND, PROJECTILE_CRIT_MULTIPLIER));
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            Entity patt12776$temp;
            if (livingHurtEvent.damageSource != null && (patt12776$temp = livingHurtEvent.damageSource.m_7639_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt12776$temp;
                if (!livingHurtEvent.defender.m_9236_().m_5776_()) {
                    if (attacker.m_21204_().m_22171_(CRITICAL_CHANCE) && !livingHurtEvent.isCritical) {
                        attacker.m_21204_().m_22146_(CRITICAL_CHANCE).m_22118_(new AttributeModifier(TEMP_CRIT_DMG_UUID, "temp_crit_base", 1.0, AttributeModifier.Operation.ADDITION));
                        double value = attacker.m_21133_(CRITICAL_CHANCE) - 1.0;
                        attacker.m_21204_().m_22146_(CRITICAL_CHANCE).m_22120_(TEMP_CRIT_DMG_UUID);
                        if (attacker.m_9236_().m_213780_().m_188500_() < value) {
                            livingHurtEvent.isCritical = true;
                            livingHurtEvent.amount *= 1.5f;
                            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.0f);
                            if (attacker instanceof Player) {
                                Player player = (Player)attacker;
                                player.m_5704_((Entity)livingHurtEvent.defender);
                            }
                            if (attacker.m_9236_().m_5776_()) {
                                Minecraft.m_91087_().f_91061_.m_107329_((Entity)livingHurtEvent.defender, (ParticleOptions)ParticleTypes.f_123797_);
                            } else {
                                Level patt14302$temp = attacker.m_9236_();
                                if (patt14302$temp instanceof ServerLevel) {
                                    ServerLevel serverWorld = (ServerLevel)patt14302$temp;
                                    serverWorld.m_7726_().m_8394_((Entity)attacker, (Packet)new ClientboundAnimatePacket((Entity)livingHurtEvent.defender, 4));
                                }
                            }
                        }
                    }
                    if (attacker.m_21204_().m_22171_(CRITICAL_DAMAGE) && livingHurtEvent.isCritical && attacker.m_21204_().m_22146_(CRITICAL_DAMAGE) != null) {
                        attacker.m_21051_(CRITICAL_DAMAGE);
                        attacker.m_21204_().m_22146_(CRITICAL_DAMAGE).m_22118_(new AttributeModifier(TEMP_CRIT_DMG_UUID, "temp_crit_base_damage", (double)livingHurtEvent.amount / 1.5, AttributeModifier.Operation.ADDITION));
                        attacker.m_21204_().m_22146_(CRITICAL_DAMAGE).m_22118_(new AttributeModifier(TEMP_CRIT_DMG_MULTIPLIER_UUID, "temp_crit_base_multiplier", 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                        livingHurtEvent.amount = (float)attacker.m_21133_(CRITICAL_DAMAGE);
                        attacker.m_21204_().m_22146_(CRITICAL_DAMAGE).m_22120_(TEMP_CRIT_DMG_UUID);
                        attacker.m_21204_().m_22146_(CRITICAL_DAMAGE).m_22120_(TEMP_CRIT_DMG_MULTIPLIER_UUID);
                    }
                }
            }
            return EventResult.pass();
        }, -1.0f);
    }

    public static double getAttribute(ItemStack stack, Attribute attribute, EquipmentSlot slot, double defaultValue) {
        return AttributeProperty.getActualValue(stack, slot, attribute, defaultValue);
    }

    static {
        TEMP_CRIT_DMG_UUID = UUID.fromString("483b007a-c7db-11ee-a506-0242ac120002");
        TEMP_CRIT_DMG_MULTIPLIER_UUID = UUID.fromString("238664bf-ae30-40f7-b717-230655bd6595");
        TEMP_BACKSTAB_DMG_UUID = UUID.fromString("03740034-c97c-11ee-a506-0242ac120002");
    }
}

