/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.redpxnda.nucleus.config.ConfigBuilder;
import com.redpxnda.nucleus.config.ConfigManager;
import com.redpxnda.nucleus.config.ConfigType;
import com.redpxnda.nucleus.registry.NucleusNamespaces;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartin.miapi.Environment;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.craft.stat.StatActorType;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.injectors.PropertySubstitution;
import smartin.miapi.item.ItemToModularConverter;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.MiapiPermissions;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.PoseCommands;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.edit_options.CreateItemOption.CreateItemOption;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.material.MaterialCommand;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.material.NBTMaterial;
import smartin.miapi.modules.properties.GlintProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.modules.synergies.SynergyManager;
import smartin.miapi.network.Networking;
import smartin.miapi.network.NetworkingImplCommon;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class Miapi {
    public static final String MOD_ID = "miapi";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ModularItem API");
    public static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"miapi debug");
    public static NetworkingImplCommon networkingImplementation;
    public static MinecraftServer server;
    public static Gson gson;

    public static void init() {
        Miapi.setupConfigs();
        Miapi.setupNetworking();
        RegistryInventory.setup();
        ReloadEvents.setup();
        ItemAbilityManager.setup();
        AttributeRegistry.setup();
        ConditionManager.setup();
        StatActorType.setup();
        NBTMaterial.setup();
        LifecycleEvent.SERVER_BEFORE_START.register(minecraftServer -> {
            server = minecraftServer;
        });
        PlayerEvent.PLAYER_JOIN.register(player -> new Thread(() -> MiapiPermissions.getPerms((Player)player)).start());
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "modules", RegistryInventory.modules, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> ItemModule.loadFromData(path, data, isClient)), -0.5f);
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "module_extensions", Collections.synchronizedMap(new LinkedHashMap()), (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> ItemModule.loadModuleExtension(path, data, isClient)), -0.4f);
        MaterialProperty.register();
        CreateItemOption.setup();
        SkinOptions.setup();
        SynergyManager.setup();
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "injectors", (Boolean bl) -> {
            PropertySubstitution.injectorsCount = 0;
        }, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> {
            JsonObject element = GsonHelper.m_13864_((String)data);
            if (element instanceof JsonObject) {
                JsonObject object = element;
                ((PropertySubstitution.TargetSelector)PropertySubstitution.targetSelectionDispatcher.dispatcher()).triggerTargetFrom(object.get("target"), PropertySubstitution.getInjector(object));
                ++PropertySubstitution.injectorsCount;
            } else {
                LOGGER.warn("Found a non JSON object PropertyInjector. PropertyInjectors should be JSON objects.");
            }
        }), 1.0f);
        ReloadEvents.START.subscribe(isClient -> {
            RegistryInventory.modules.clear();
            MaterialProperty.materials.clear();
        });
        ReloadEvents.END.subscribe(isClient -> {
            RegistryInventory.modules.register(ItemModule.empty.getName(), ItemModule.empty);
            RegistryInventory.modules.register(ItemModule.internal.getName(), ItemModule.internal);
            LOGGER.info("Loaded " + PropertySubstitution.injectorsCount + " Injectors/Property Substitutors");
            LOGGER.info("Loaded " + RegistryInventory.modules.getFlatMap().size() + " Modules");
            ModularItemCache.discardCache();
        });
        PropertyResolver.register(new ResourceLocation(MOD_ID, "module"), (moduleInstance, oldMap) -> {
            ConcurrentHashMap map = new ConcurrentHashMap();
            moduleInstance.module.getProperties().forEach((key, jsonData) -> map.put(RegistryInventory.moduleProperties.get((String)key), jsonData));
            return map;
        });
        PropertyResolver.register("module_data", (moduleInstance, oldMap) -> {
            JsonObject moduleJson;
            ConcurrentHashMap map = new ConcurrentHashMap();
            String properties = moduleInstance.moduleData.get("properties");
            if (properties != null && (moduleJson = (JsonObject)gson.fromJson(properties, JsonObject.class)) != null) {
                moduleJson.entrySet().forEach(stringJsonElementEntry -> {
                    ModuleProperty property = RegistryInventory.moduleProperties.get((String)stringJsonElementEntry.getKey());
                    if (property != null) {
                        map.put(property, (JsonElement)stringJsonElementEntry.getValue());
                    }
                });
            }
            return map;
        });
        ModularItemCache.setSupplier("modules", itemStack -> {
            if (itemStack.m_41720_() instanceof VisualModularItem) {
                CompoundTag tag = itemStack.m_41784_();
                try {
                    String modulesString = tag.m_128441_("miapi_modules") && tag.m_128423_("miapi_modules") != null ? tag.m_128461_("miapi_modules") : tag.m_128461_("modules");
                    return gson.fromJson(modulesString, ItemModule.ModuleInstance.class);
                }
                catch (Exception e) {
                    LOGGER.error("could not resolve Modules", (Throwable)e);
                }
            }
            return null;
        });
        ModularItemCache.setSupplier("rawProperties", itemStack -> ItemModule.getUnmergedProperties(ModularItemCache.getVisualOnlyCache(itemStack, "modules", new ItemModule.ModuleInstance(ItemModule.empty))));
        ModularItemStackConverter.converters.add(new ItemToModularConverter());
        if (Environment.isClient()) {
            MiapiClient.init();
        }
        NucleusNamespaces.addAddonNamespace((String)MOD_ID);
        CommandRegistrationEvent.EVENT.register((serverCommandSourceCommandDispatcher, registryAccess, listener) -> {
            MaterialCommand.register((CommandDispatcher<CommandSourceStack>)serverCommandSourceCommandDispatcher);
            CacheCommands.register((CommandDispatcher<CommandSourceStack>)serverCommandSourceCommandDispatcher);
            PoseCommands.register((CommandDispatcher<CommandSourceStack>)serverCommandSourceCommandDispatcher);
        });
        LifecycleEvent.SERVER_STARTED.register(minecraftServer -> {
            if (MiapiConfig.INSTANCE.server.other.doubleReload) {
                LOGGER.info("Truly Modular will now go onto reload twice.");
                LOGGER.info("This is done because for compat reasons and because forge sometimes breaks badly");
                LOGGER.info("This can be turned off in Miapis config.json");
                CacheCommands.triggerServerReload();
            }
        });
    }

    public static ResourceLocation MiapiIdentifier(String string) {
        String[] parts = string.split(":");
        if (parts.length > 1) {
            return new ResourceLocation(parts[0], parts[1]);
        }
        return new ResourceLocation(MOD_ID, string);
    }

    public static ResourceLocation MiapiIdentifier(String namespace, String id) {
        return new ResourceLocation(namespace, id);
    }

    protected static void setupNetworking() {
        networkingImplementation = new NetworkingImplCommon();
        Networking.setImplementation(networkingImplementation);
        networkingImplementation.setupServer();
    }

    protected static void setupConfigs() {
        ConfigManager.register((ConfigBuilder)ConfigBuilder.automatic(MiapiConfig.class).id("miapi:merged").fileLocation(MOD_ID).type(ConfigType.COMMON).creator(MiapiConfig::new).updateListener(c -> {
            MiapiConfig.INSTANCE = c;
            if (Environment.isClient()) {
                GlintProperty.updateConfig();
            }
        }).automaticScreen());
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, boolean syncToClient, Consumer<Boolean> beforeLoop, TriConsumer<Boolean, String, String> handler, float priority) {
        if (syncToClient) {
            ReloadEvents.registerDataPackPathToSync(MOD_ID, location);
        }
        event.subscribe(isClient -> {
            beforeLoop.accept(isClient);
            ReloadEvents.getDataPacks(isClient).forEach((path, data) -> {
                if (path.startsWith(location + "/")) {
                    try {
                        handler.accept((Object)isClient, path, data);
                    }
                    catch (Exception e) {
                        LOGGER.warn("could not load " + path, (Throwable)e);
                    }
                }
            });
        }, priority);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Consumer<Boolean> beforeLoop, TriConsumer<Boolean, String, String> handler, float priority) {
        Miapi.registerReloadHandler(event, location, true, beforeLoop, handler, priority);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, MiapiRegistry<?> toClear, TriConsumer<Boolean, String, String> handler) {
        Miapi.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, 0.0f);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, MiapiRegistry<?> toClear, TriConsumer<Boolean, String, String> handler, float prio) {
        Miapi.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, prio);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Map<?, ?> toClear, TriConsumer<Boolean, String, String> handler) {
        Miapi.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, 0.0f);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Map<?, ?> toClear, TriConsumer<Boolean, String, String> handler, float prio) {
        Miapi.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, prio);
    }

    static {
        gson = new Gson();
    }
}

