/*
 * Decompiled with CFR 0.152.
 */
package work.crash.skyraah.sanityjs.mixin;

import com.mojang.authlib.GameProfile;
import croissantnova.sanitydim.capability.SanityProvider;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import work.crash.skyraah.sanityjs.util.IPlayerSanity;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements IPlayerSanity {
    @Unique
    public float sanity;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onConstruct(Level level, BlockPos pos, float yRot, GameProfile gameProfile, CallbackInfo ci) {
        this.sanity = this.getSanity();
    }

    @Override
    @Unique
    public float getSanity() {
        AtomicReference<Float> sanityValue = new AtomicReference<Float>(Float.valueOf(0.0f));
        ((Player)this).getCapability(SanityProvider.CAP).ifPresent(sanity -> sanityValue.set(Float.valueOf((1.0f - sanity.getSanity()) * 100.0f)));
        return sanityValue.get().floatValue();
    }

    @Override
    @Unique
    public void setSanity(float value) {
        ((Player)this).getCapability(SanityProvider.CAP).ifPresent(sanity -> sanity.setSanity(1.0f - value / 100.0f));
    }

    @Override
    @Unique
    public void addSanity(float value) {
        ((Player)this).getCapability(SanityProvider.CAP).ifPresent(sanity -> {
            float currentSanity = (1.0f - sanity.getSanity()) * 100.0f;
            float newSanity = currentSanity + value;
            newSanity = Math.max(0.0f, Math.min(100.0f, newSanity));
            sanity.setSanity(1.0f - newSanity / 100.0f);
        });
    }
}

