/*
 * Decompiled with CFR 0.152.
 */
package work.crash.skyraah.sanityjs.event;

import dev.latvian.mods.kubejs.player.PlayerEventJS;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.world.entity.player.Player;
import work.crash.skyraah.sanityjs.util.IMathHelper;
import work.crash.skyraah.sanityjs.util.IPlayerSanity;

public class SanityTickEventJS
extends PlayerEventJS {
    private final Player player;
    private final float sanity;

    public SanityTickEventJS(Player player) {
        this.player = player;
        this.sanity = ((IPlayerSanity)player).getSanity();
    }

    public Player getEntity() {
        return this.player;
    }

    public float getSanity() {
        return this.sanity;
    }

    @Info(value="Set the sanity value to a specific number (0-100)")
    public void setSanity(float value) {
        ((IPlayerSanity)this.player).setSanity(value);
    }

    @Info(value="Increase sanity")
    public void addSanity(float value) {
        ((IPlayerSanity)this.player).addSanity(value);
    }

    @Info(value="Convert a number to a value between 0 and 1")
    public float clampNorm(float value) {
        return IMathHelper.clampNorm((float)value);
    }

    @Info(value="Convert the value between 0 and 1 into a readable number")
    public float unclampNorm(float normalizedValue) {
        return IMathHelper.unclampNorm(normalizedValue);
    }

    @Info(value="Truncate a number to n significant decimal places (rounding mode)")
    public float approximation(float value, int n) {
        return IMathHelper.approximation(value, n);
    }
}

