/*
 * Decompiled with CFR 0.152.
 */
package work.crash.skyraah.sanityjs.event;

import dev.latvian.mods.kubejs.player.PlayerEventJS;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.world.entity.player.Player;
import work.crash.skyraah.sanityjs.util.IMathHelper;
import work.crash.skyraah.sanityjs.util.IPlayerSanity;

@Info(value="Handle Sanity Change Event caused by Passive Events.")
public class SanityChangeEventJS
extends PlayerEventJS {
    private final float value;
    private final float previousValue;
    private final Player player;

    public SanityChangeEventJS(float value, float previousValue, Player player) {
        this.value = value;
        this.previousValue = previousValue;
        this.player = player;
    }

    public Player getEntity() {
        return this.player;
    }

    @Info(value="Get the sanity value")
    public float getSanity() {
        return this.value;
    }

    @Info(value="Get the sanity value before the change")
    public float getPreviousSanity() {
        return this.previousValue;
    }

    @Info(value="Set the sanity value to a specific number (0-100)")
    public void setSanity(float value) {
        ((IPlayerSanity)this.player).setSanity(value);
    }

    @Info(value="Increase sanity")
    public void addSanity(float value) {
        ((IPlayerSanity)this.player).addSanity(value);
    }

    @Info(value="Convert a number to a value between 0 and 1")
    public float clampNorm(float value) {
        return IMathHelper.clampNorm((float)value);
    }

    @Info(value="Convert the value between 0 and 1 into a readable number")
    public float unclampNorm(float normalizedValue) {
        return IMathHelper.unclampNorm(normalizedValue);
    }

    @Info(value="Truncate a number to n significant decimal places (rounding mode)")
    public float approximation(float value, int n) {
        return IMathHelper.approximation(value, n);
    }
}

