/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.util;

import io.github.maki99999.biomebeats.event.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class EventBus {
    private static final Map<Class<?>, List<Consumer<?>>> listeners = new ConcurrentHashMap();

    public static <T extends Event> void subscribe(Class<T> eventType, Consumer<T> listener) {
        listeners.computeIfAbsent(eventType, k -> new ArrayList()).add(listener);
    }

    public static <T extends Event> void publish(T event) {
        List eventListeners = listeners.getOrDefault(event.getClass(), Collections.emptyList());
        Iterator iterator = eventListeners.iterator();
        while (iterator.hasNext()) {
            Consumer listener;
            Consumer typedListener = listener = (Consumer)iterator.next();
            typedListener.accept(event);
        }
    }

    public static <T extends Event> void unsubscribe(Class<T> eventType, Consumer<T> listener) {
        List<Consumer<?>> eventListeners = listeners.get(eventType);
        if (eventListeners != null) {
            eventListeners.remove(listener);
            if (eventListeners.isEmpty()) {
                listeners.remove(eventType);
            }
        }
    }
}

