/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.Alsa;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaBaseDataLine;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.TConversionTool;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class AlsaTargetDataLine
extends AlsaBaseDataLine
implements TargetDataLine {
    private byte[] m_abSwapBuffer;

    public AlsaTargetDataLine(AlsaDataLineMixer mixer, AudioFormat format, int nBufferSize) throws LineUnavailableException {
        super(mixer, new DataLine.Info(TargetDataLine.class, format, nBufferSize));
    }

    protected int getAlsaStreamType() {
        return 1;
    }

    protected void stopImpl() {
        int nReturn;
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.stopImpl(): called.");
        }
        if ((nReturn = 0) != 0) {
            TDebug.out("flushChannel: " + Alsa.getStringError(nReturn));
        }
    }

    public int available() {
        return -1;
    }

    public int read(byte[] abData, int nOffset, int nLength) {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.read(): called.");
            TDebug.out("AlsaTargetDataLine.read(): wanted length: " + nLength);
        }
        int nOriginalOffset = nOffset;
        if (nLength > 0 && !this.isActive()) {
            this.start();
        }
        if (!this.isOpen() && TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.read(): stream closed");
        }
        int nBytesRead = this.readImpl(abData, nOffset, nLength);
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.read(): read (bytes): " + nBytesRead);
        }
        if (this.getSwapBytes() && nBytesRead > 0) {
            TConversionTool.swapOrder16(abData, nOriginalOffset, nBytesRead / 2);
        }
        return nBytesRead;
    }

    public int readImpl(byte[] abData, int nOffset, int nLength) {
        int nFramesRead;
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.readImpl(): called.");
            TDebug.out("AlsaTargetDataLine.readImpl(): wanted length: " + nLength);
        }
        int nFrameSize = this.getFormat().getFrameSize();
        int nFramesToRead = nLength / nFrameSize;
        if (nLength > 0 && !this.isActive()) {
            this.start();
        }
        if (!this.isOpen() && TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.readImpl(): stream closed");
        }
        if ((nFramesRead = (int)this.getAlsaPcm().readi(abData, nOffset, nFramesToRead)) < 0) {
            TDebug.out("AlsaTargetDataLine.readImpl(): " + Alsa.getStringError(nFramesRead));
        }
        int nBytesRead = nFramesRead * nFrameSize;
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.readImpl(): read (bytes): " + nBytesRead);
        }
        return nBytesRead;
    }

    public void drain() {
    }

    public void flush() {
    }

    public long getPosition() {
        return 0L;
    }

    protected void setGain(float fGain) {
    }

    public class AlsaTargetDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN = 90.0f;
        private final float MIN_GAIN = -96.0f;
        private final int GAIN_INCREMENTS = 1000;

        AlsaTargetDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }

        public void setValue(float fGain) {
            if ((double)Math.abs((fGain = Math.max(Math.min(fGain, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(fGain);
                AlsaTargetDataLine.this.setGain(this.getValue());
            }
        }
    }
}

