/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.Alsa;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaBaseDataLine;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.TConversionTool;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class AlsaSourceDataLine
extends AlsaBaseDataLine
implements SourceDataLine {
    private byte[] m_abSwapBuffer;

    public AlsaSourceDataLine(AlsaDataLineMixer mixer, AudioFormat format, int nBufferSize) throws LineUnavailableException {
        super(mixer, new DataLine.Info(SourceDataLine.class, format, nBufferSize));
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.<init>(): begin");
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.<init>(): buffer size: " + nBufferSize);
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.<init>(): end");
        }
    }

    protected int getAlsaStreamType() {
        return 0;
    }

    protected void stopImpl() {
        int nReturn;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.stopImpl(): called");
        }
        if ((nReturn = 0) != 0) {
            TDebug.out("flushChannel: " + Alsa.getStringError(nReturn));
        }
    }

    public int available() {
        this.throwNYIException();
        return -1;
    }

    public int write(byte[] abData, int nOffset, int nLength) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.write(): begin");
        }
        if (this.getSwapBytes()) {
            if (this.m_abSwapBuffer == null || this.m_abSwapBuffer.length < nOffset + nLength) {
                this.m_abSwapBuffer = new byte[nOffset + nLength];
            }
            TConversionTool.changeOrderOrSign(abData, nOffset, this.m_abSwapBuffer, nOffset, nLength, this.getBytesPerSample());
            abData = this.m_abSwapBuffer;
        }
        int nReturn = this.writeImpl(abData, nOffset, nLength);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.write(): end");
        }
        return nReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(byte[] abData, int nOffset, int nLength) {
        int nWrittenBytes;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.writeImpl(): begin");
        }
        if (nLength > 0 && !this.isActive()) {
            this.start();
        }
        int nFrameSize = this.getFormat().getFrameSize();
        for (int nRemaining = nLength; nRemaining > 0 && this.isOpen(); nRemaining -= nWrittenBytes) {
            AlsaSourceDataLine alsaSourceDataLine = this;
            synchronized (alsaSourceDataLine) {
                int nWrittenFrames;
                if (!this.isOpen()) {
                    return nLength - nRemaining;
                }
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("AlsaSourceDataLine.writeImpl(): trying to write (bytes): " + nRemaining);
                }
                int nRemainingFrames = nRemaining / nFrameSize;
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("AlsaSourceDataLine.writeImpl(): trying to write (frames): " + nRemainingFrames);
                }
                if ((nWrittenFrames = (int)this.getAlsaPcm().writei(abData, nOffset, nRemainingFrames)) < 0) {
                    TDebug.out("AlsaSourceDataLine.writeImpl(): " + Alsa.getStringError(nWrittenFrames));
                    return nLength - nRemaining;
                }
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("AlsaSourceDataLine.writeImpl(): written (frames): " + nWrittenFrames);
                }
                nWrittenBytes = nWrittenFrames * nFrameSize;
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("AlsaSourceDataLine.writeImpl(): written (bytes): " + nWrittenBytes);
                }
                nOffset += nWrittenBytes;
                continue;
            }
        }
        return nLength;
    }

    public void drain() {
    }

    public void flush() {
    }

    protected void setGain(float dGain) {
    }

    private void throwNYIException() {
        throw new RuntimeException("sorry, this feature is not yet implemented");
    }

    public class AlsaSourceDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN = 90.0f;
        private final float MIN_GAIN = -96.0f;
        private final int GAIN_INCREMENTS = 1000;

        AlsaSourceDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }

        public void setValue(float fGain) {
            if ((double)Math.abs((fGain = Math.max(Math.min(fGain, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(fGain);
                AlsaSourceDataLine.this.setGain(this.getValue());
            }
        }
    }
}

