/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaMixer;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaMixerElement;
import io.github.maki99999.biomebeats.org.tritonus.share.GlobalInfo;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TCompoundControlType;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TMixer;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TMixerInfo;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaPortMixer
extends TMixer {
    public static final int DIRECTION_NONE = -1;
    public static final int DIRECTION_COMMON = 0;
    public static final int DIRECTION_PLAYBACK = 1;
    public static final int DIRECTION_CAPTURE = 2;
    private List<AlsaMixerElement> m_mixerElements;
    private Map<Port.Info, Port> m_portMap;
    private Map<Port.Info, AlsaMixerElement> m_mixerElementMap;

    public AlsaPortMixer(int nCard) {
        this("hw:" + nCard);
    }

    public AlsaPortMixer(String strDeviceName) {
        AlsaMixer alsaMixer;
        block10: {
            super(new TMixerInfo("Alsa Port Mixer (" + strDeviceName + ")", GlobalInfo.getVendor(), "System Mixer for the Advanced Linux Sound System (card " + strDeviceName + ")", GlobalInfo.getVersion()), new Line.Info(Mixer.class));
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.<init>: begin");
            }
            this.m_mixerElements = new ArrayList<AlsaMixerElement>();
            this.m_mixerElementMap = new HashMap<Port.Info, AlsaMixerElement>();
            this.m_portMap = new HashMap<Port.Info, Port>();
            alsaMixer = null;
            try {
                alsaMixer = new AlsaMixer(strDeviceName);
                if (TDebug.TraceMixer) {
                    TDebug.out("AlsaPortMixer.<init>: successfully created AlsaMixer instance");
                }
            }
            catch (Exception e) {
                if (!TDebug.TraceMixer && !TDebug.TraceAllExceptions) break block10;
                TDebug.out(e);
            }
        }
        int nArraySize = 150;
        int[] anIndices = null;
        String[] astrNames = null;
        int nControlCount = 0;
        while ((nControlCount = alsaMixer.readControlList(anIndices = new int[nArraySize], astrNames = new String[nArraySize])) < 0) {
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.<init>: increasing array size for AlsaMixer.readControlList(): now " + nArraySize * 2);
            }
            nArraySize *= 2;
        }
        ArrayList<Line.Info> sourcePortInfos = new ArrayList<Line.Info>();
        ArrayList<Line.Info> targetPortInfos = new ArrayList<Line.Info>();
        for (int i = 0; i < nControlCount; ++i) {
            Port.Info info;
            AlsaMixerElement element;
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.<init>(): control " + i + ": " + anIndices[i] + " " + astrNames[i]);
            }
            if (!(element = new AlsaMixerElement(alsaMixer, anIndices[i], astrNames[i])).isActive()) continue;
            this.m_mixerElements.add(element);
            if (AlsaPortMixer.hasPlaybackChannels(element)) {
                info = new Port.Info(Port.class, element.getName(), true);
                sourcePortInfos.add(info);
                this.m_mixerElementMap.put(info, element);
            }
            if (!AlsaPortMixer.hasCaptureChannels(element)) continue;
            info = new Port.Info(Port.class, element.getName(), false);
            targetPortInfos.add(info);
            this.m_mixerElementMap.put(info, element);
        }
        this.setSupportInformation(new ArrayList<AudioFormat>(), new ArrayList<AudioFormat>(), sourcePortInfos, targetPortInfos);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.<init>: end.");
        }
    }

    private static boolean hasPlaybackChannels(AlsaMixerElement element) {
        boolean bHasChannels = false;
        for (int nChannel = 0; nChannel <= 5; ++nChannel) {
            bHasChannels |= element.hasPlaybackChannel(nChannel);
        }
        return bHasChannels;
    }

    private static boolean hasCaptureChannels(AlsaMixerElement element) {
        boolean bHasChannels = false;
        for (int nChannel = 0; nChannel <= 5; ++nChannel) {
            bHasChannels |= element.hasCaptureChannel(nChannel);
        }
        return bHasChannels;
    }

    @Override
    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.open(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.close(): end");
        }
    }

    @Override
    public int getMaxLines(Line.Info info) {
        return 0;
    }

    @Override
    protected Port getPort(Port.Info info) throws LineUnavailableException {
        Port port;
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.getPort(): begin");
        }
        if ((port = this.m_portMap.get(info)) == null) {
            port = this.createPort(info);
            this.m_portMap.put(info, port);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.getPort(): end");
        }
        return port;
    }

    private Port createPort(Port.Info info) {
        AlsaMixerElement element;
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.createPort(): begin");
        }
        if ((element = this.m_mixerElementMap.get(info)) == null) {
            throw new IllegalArgumentException("no port for this info");
        }
        List<Control> controls = info.isSource() ? this.createSourcePortControls(element) : new ArrayList<Control>();
        TPort port = new TPort(this, info, controls);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.createPort(): end");
        }
        return port;
    }

    private List<Control> createSourcePortControls(AlsaMixerElement element) {
        Control[] aMemberControls;
        ArrayList<FloatControl> volumeControls;
        Control c;
        int nDirection = 1;
        ArrayList<Control> controls = new ArrayList<Control>();
        if (element.hasPlaybackVolume() || element.hasCommonVolume()) {
            if (element.isPlaybackMono() || element.hasPlaybackVolumeJoined()) {
                c = this.createVolumeControl(element, 0, nDirection);
                controls.add(c);
            } else {
                volumeControls = new ArrayList<FloatControl>();
                for (int nChannel = 0; nChannel < 31; ++nChannel) {
                    if (!element.hasPlaybackChannel(nChannel)) continue;
                    c = this.createVolumeControl(element, nChannel, nDirection);
                    volumeControls.add((FloatControl)c);
                }
                TCompoundControlType type = new TCompoundControlType("test");
                aMemberControls = volumeControls.toArray(new Control[0]);
                c = new AlsaCompoundControl(type, aMemberControls);
                controls.add(c);
            }
        }
        if (element.hasPlaybackSwitch() || element.hasCommonSwitch()) {
            if (element.isPlaybackMono() || element.hasPlaybackSwitchJoined()) {
                c = this.createSwitchControl(element, 0, nDirection);
                controls.add(c);
            } else {
                volumeControls = new ArrayList();
                for (int nChannel = 0; nChannel < 31; ++nChannel) {
                    if (!element.hasPlaybackChannel(nChannel)) continue;
                    c = this.createSwitchControl(element, nChannel, nDirection);
                    volumeControls.add((FloatControl)c);
                }
                TCompoundControlType type = new TCompoundControlType("test");
                aMemberControls = volumeControls.toArray(new Control[0]);
                c = new AlsaCompoundControl(type, aMemberControls);
                controls.add(c);
            }
        }
        return controls;
    }

    private FloatControl createVolumeControl(AlsaMixerElement element, int nChannel, int nDirection) {
        int[] anValues = new int[2];
        switch (nDirection) {
            case 0: 
            case 1: {
                element.getPlaybackVolumeRange(anValues);
                break;
            }
            case 2: {
                element.getCaptureVolumeRange(anValues);
            }
        }
        AlsaVolumeControl control = new AlsaVolumeControl(FloatControl.Type.VOLUME, anValues[0], anValues[1], 1.0f, -1, anValues[0], "", "", "", "", element, nChannel, nDirection);
        return control;
    }

    private BooleanControl createSwitchControl(AlsaMixerElement element, int nChannel, int nDirection) {
        AlsaSwitchControl control = new AlsaSwitchControl(BooleanControl.Type.MUTE, false, "", "", element, nChannel, nDirection);
        return control;
    }

    public class AlsaCompoundControl
    extends CompoundControl {
        public AlsaCompoundControl(CompoundControl.Type type, Control[] aMemberControls) {
            super(type, aMemberControls);
        }
    }

    private class AlsaSwitchControl
    extends BooleanControl {
        private AlsaMixerElement m_element;
        private int m_nChannel;
        private int m_nDirection;

        public AlsaSwitchControl(BooleanControl.Type type, boolean bInitialValue, String strTrueLabel, String strFalseLabel, AlsaMixerElement element, int nChannel, int nDirection) {
            super(type, bInitialValue, strTrueLabel, strFalseLabel);
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): begin");
            }
            this.m_element = element;
            this.m_nChannel = nChannel;
            this.m_nDirection = nDirection;
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): end");
            }
        }

        private AlsaMixerElement getElement() {
            return this.m_element;
        }

        private int getChannel() {
            return this.m_nChannel;
        }

        private int getDirection() {
            return this.m_nDirection;
        }

        public void setValue(boolean bValue) {
            super.setValue(bValue);
            switch (this.getDirection()) {
                case 0: 
                case 1: {
                    this.getElement().setPlaybackSwitchAll(bValue);
                    break;
                }
                case 2: {
                    this.getElement().setCaptureSwitchAll(bValue);
                }
            }
        }
    }

    private class AlsaVolumeControl
    extends FloatControl {
        private AlsaMixerElement m_element;
        private int m_nChannel;
        private int m_nDirection;

        public AlsaVolumeControl(FloatControl.Type type, float fMinimum, float fMaximum, float fPrecision, int nUpdatePeriod, float fInitialValue, String strUnits, String strMinLabel, String strMidLabel, String strMaxLabel, AlsaMixerElement element, int nChannel, int nDirection) {
            super(type, fMinimum, fMaximum, fPrecision, nUpdatePeriod, fInitialValue, strUnits, strMinLabel, strMidLabel, strMaxLabel);
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): begin");
            }
            this.m_element = element;
            this.m_nChannel = nChannel;
            this.m_nDirection = nDirection;
            this.setValue(this.getValueImpl());
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): end");
            }
        }

        private AlsaMixerElement getElement() {
            return this.m_element;
        }

        private int getChannel() {
            return this.m_nChannel;
        }

        private int getDirection() {
            return this.m_nDirection;
        }

        public void setValue(float fValue) {
            super.setValue(fValue);
            int nValue = (int)fValue;
            switch (this.getDirection()) {
                case 0: 
                case 1: {
                    this.getElement().setPlaybackVolumeAll(nValue);
                    break;
                }
                case 2: {
                    this.getElement().setCaptureVolumeAll(nValue);
                }
            }
        }

        private float getValueImpl() {
            int nChannel = this.getChannel();
            float fValue = 0.0f;
            switch (this.getDirection()) {
                case 0: 
                case 1: {
                    fValue = this.getElement().getPlaybackVolume(nChannel);
                    break;
                }
                case 2: {
                    fValue = this.getElement().getCaptureVolume(nChannel);
                }
            }
            return fValue;
        }
    }
}

