/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.Alsa;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaCtl;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaCtlCardInfo;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TMixerProvider;

public class AlsaDataLineMixerProvider
extends TMixerProvider {
    private static boolean sm_bInitialized = false;

    public AlsaDataLineMixerProvider() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.<init>(): begin");
        }
        if (!sm_bInitialized && !this.isDisabled()) {
            if (!Alsa.isLibraryAvailable()) {
                this.disable();
            } else {
                this.staticInit();
                sm_bInitialized = true;
            }
        } else if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.<init>(): already initialized or disabled");
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.<init>(): end");
        }
    }

    protected void staticInit() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.staticInit(): begin");
        }
        int[] anCards = AlsaCtl.getCards();
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.staticInit(): num cards: " + anCards.length);
        }
        for (int i = 0; i < anCards.length; ++i) {
            if (TDebug.TraceMixerProvider) {
                TDebug.out("AlsaDataLineMixerProvider.staticInit():card #" + i + ": " + anCards[i]);
            }
            if (TDebug.TraceMixerProvider) {
                TDebug.out("AlsaDataLineMixerProvider.staticInit(): creating Ctl object...");
            }
            String strPcmName = "hw:" + anCards[i];
            AlsaCtl ctl = null;
            try {
                ctl = new AlsaCtl(strPcmName, 0);
            }
            catch (Exception e) {
                if (!TDebug.TraceMixerProvider && !TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
                continue;
            }
            if (TDebug.TraceMixerProvider) {
                TDebug.out("AlsaDataLineMixerProvider.staticInit(): calling getCardInfo()...");
            }
            AlsaCtlCardInfo cardInfo = new AlsaCtlCardInfo();
            ctl.getCardInfo(cardInfo);
            if (TDebug.TraceMixerProvider) {
                TDebug.out("AlsaDataLineMixerProvider.staticInit(): ALSA sound card:");
                TDebug.out("AlsaDataLineMixerProvider.staticInit(): card: " + cardInfo.getCard());
                TDebug.out("AlsaDataLineMixerProvider.staticInit(): id: " + cardInfo.getId());
            }
            int[] anDevices = ctl.getPcmDevices();
            if (TDebug.TraceMixerProvider) {
                TDebug.out("AlsaDataLineMixerProvider.staticInit(): num devices: " + anDevices.length);
            }
            for (int nDevice = 0; nDevice < anDevices.length; ++nDevice) {
                if (!TDebug.TraceMixerProvider) continue;
                TDebug.out("AlsaDataLineMixerProvider.staticInit(): device #" + nDevice + ": " + anDevices[nDevice]);
            }
            AlsaDataLineMixer mixer = new AlsaDataLineMixer(anCards[i]);
            super.addMixer(mixer);
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("AlsaDataLineMixerProvider.staticInit(): end");
        }
    }
}

