/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.Alsa;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaPcm;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaPcmHWParams;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaPcmHWParamsFormatMask;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaSourceDataLine;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaTargetDataLine;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaUtils;
import io.github.maki99999.biomebeats.org.tritonus.share.GlobalInfo;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.TSettings;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TMixer;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TMixerInfo;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TSoftClip;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaDataLineMixer
extends TMixer {
    private static final AudioFormat[] EMPTY_AUDIOFORMAT_ARRAY = new AudioFormat[0];
    private static final int CHANNELS_LIMIT = 32;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private String m_strPcmName;

    public static String getDeviceNamePrefix() {
        if (TSettings.AlsaUsePlughw) {
            return "plughw";
        }
        return "hw";
    }

    public static String getPcmName(int nCard) {
        String strPcmName = AlsaDataLineMixer.getDeviceNamePrefix() + ":" + nCard;
        if (TSettings.AlsaUsePlughw) {
            // empty if block
        }
        return strPcmName;
    }

    public AlsaDataLineMixer() {
        this(0);
    }

    public AlsaDataLineMixer(int nCard) {
        this(AlsaDataLineMixer.getPcmName(nCard));
    }

    public AlsaDataLineMixer(String strPcmName) {
        super(new TMixerInfo("Alsa DataLine Mixer (" + strPcmName + ")", GlobalInfo.getVendor(), "Mixer for the Advanced Linux Sound Architecture (card " + strPcmName + ")", GlobalInfo.getVersion()), new Line.Info(Mixer.class));
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.<init>(String): begin.");
        }
        this.m_strPcmName = strPcmName;
        List<AudioFormat> sourceFormats = this.getSupportedFormats(0);
        List<AudioFormat> targetFormats = this.getSupportedFormats(1);
        ArrayList<Line.Info> sourceLineInfos = new ArrayList<Line.Info>();
        DataLine.Info sourceLineInfo = new DataLine.Info(SourceDataLine.class, sourceFormats.toArray(EMPTY_AUDIOFORMAT_ARRAY), -1, -1);
        sourceLineInfos.add(sourceLineInfo);
        ArrayList<Line.Info> targetLineInfos = new ArrayList<Line.Info>();
        DataLine.Info targetLineInfo = new DataLine.Info(TargetDataLine.class, targetFormats.toArray(EMPTY_AUDIOFORMAT_ARRAY), -1, -1);
        targetLineInfos.add(targetLineInfo);
        this.setSupportInformation(sourceFormats, targetFormats, sourceLineInfos, targetLineInfos);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.<init>(String): end.");
        }
    }

    public String getPcmName() {
        return this.m_strPcmName;
    }

    @Override
    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.open(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.close(): end");
        }
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getMaxLines(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getMaxLines(): end");
        }
        return 0;
    }

    @Override
    protected SourceDataLine getSourceDataLine(AudioFormat format, int nBufferSize) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): format: " + format);
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): buffer size: " + nBufferSize);
        }
        if (nBufferSize < 1) {
            nBufferSize = 32768;
        }
        AlsaSourceDataLine sourceDataLine = new AlsaSourceDataLine(this, format, nBufferSize);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): returning: " + sourceDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): end");
        }
        return sourceDataLine;
    }

    @Override
    protected TargetDataLine getTargetDataLine(AudioFormat format, int nBufferSize) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): begin");
        }
        int nBufferSizeInBytes = nBufferSize * format.getFrameSize();
        AlsaTargetDataLine targetDataLine = new AlsaTargetDataLine(this, format, nBufferSizeInBytes);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): returning: " + targetDataLine);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): end");
        }
        return targetDataLine;
    }

    @Override
    protected Clip getClip(AudioFormat format) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getClip(): begin");
        }
        TSoftClip clip = new TSoftClip((Mixer)this, format);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getClip(): end");
        }
        return clip;
    }

    private List<AudioFormat> getSupportedFormats(int nDirection) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): direction: " + nDirection);
        }
        ArrayList<AudioFormat> supportedFormats = new ArrayList<AudioFormat>();
        AlsaPcm alsaPcm = null;
        try {
            alsaPcm = new AlsaPcm(this.getPcmName(), nDirection, 0);
        }
        catch (Exception e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            throw new RuntimeException("cannot open pcm");
        }
        AlsaPcmHWParams hwParams = new AlsaPcmHWParams();
        int nReturn = alsaPcm.getAnyHWParams(hwParams);
        if (nReturn != 0) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): getAnyHWParams(): " + Alsa.getStringError(nReturn));
            throw new RuntimeException(Alsa.getStringError(nReturn));
        }
        AlsaPcmHWParamsFormatMask formatMask = new AlsaPcmHWParamsFormatMask();
        int nMinChannels = hwParams.getChannelsMin();
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): min channels: " + nMinChannels);
        }
        int nMaxChannels = hwParams.getChannelsMax();
        nMaxChannels = Math.min(nMaxChannels, 32);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): max channels: " + nMaxChannels);
        }
        hwParams.getFormatMask(formatMask);
        for (int i = 0; i < 32; ++i) {
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaDataLineMixer.getSupportedFormats(): checking ALSA format index: " + i);
            }
            if (formatMask.test(i)) {
                if (TDebug.TraceMixer) {
                    TDebug.out("AlsaDataLineMixer.getSupportedFormats(): ...supported");
                }
                AudioFormat audioFormat = AlsaUtils.getAlsaFormat(i);
                if (TDebug.TraceMixer) {
                    TDebug.out("AlsaDataLineMixer.getSupportedFormats(): adding AudioFormat: " + audioFormat);
                }
                AlsaDataLineMixer.addChanneledAudioFormats(supportedFormats, audioFormat, nMinChannels, nMaxChannels);
                continue;
            }
            if (!TDebug.TraceMixer) continue;
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): ...not supported");
        }
        alsaPcm.close();
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): end");
        }
        return supportedFormats;
    }

    private static void addChanneledAudioFormats(Collection<AudioFormat> collection, AudioFormat protoAudioFormat, int nMinChannels, int nMaxChannels) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): begin");
        }
        for (int nChannels = nMinChannels; nChannels <= nMaxChannels; ++nChannels) {
            AudioFormat channeledAudioFormat = AlsaDataLineMixer.getChanneledAudioFormat(protoAudioFormat, nChannels);
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): adding AudioFormat: " + channeledAudioFormat);
            }
            collection.add(channeledAudioFormat);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): end");
        }
    }

    private static AudioFormat getChanneledAudioFormat(AudioFormat audioFormat, int nChannels) {
        AudioFormat channeledAudioFormat = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), nChannels, audioFormat.getSampleSizeInBits() / 8 * nChannels, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        return channeledAudioFormat;
    }
}

