/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.Alsa;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaPcm;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaPcmHWParams;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaPcmSWParams;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import io.github.maki99999.biomebeats.org.tritonus.sampled.mixer.alsa.AlsaUtils;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TBaseDataLine;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.mixer.TMixer;
import java.util.Collection;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;

public abstract class AlsaBaseDataLine
extends TBaseDataLine {
    private AlsaPcm m_alsaPcm;
    private boolean m_bSwapBytes;
    private int m_nBytesPerSample;

    public AlsaBaseDataLine(AlsaDataLineMixer mixer, DataLine.Info info) throws LineUnavailableException {
        super((TMixer)mixer, info);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): begin");
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): end");
        }
    }

    public AlsaBaseDataLine(AlsaDataLineMixer mixer, DataLine.Info info, Collection controls) throws LineUnavailableException {
        super((TMixer)mixer, info);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): begin");
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): end");
        }
    }

    protected AlsaDataLineMixer getAlsaDataLineMixer() {
        return (AlsaDataLineMixer)this.getMixer();
    }

    protected AlsaPcm getAlsaPcm() {
        return this.m_alsaPcm;
    }

    protected abstract int getAlsaStreamType();

    protected boolean getSwapBytes() {
        return this.m_bSwapBytes;
    }

    protected int getBytesPerSample() {
        return this.m_nBytesPerSample;
    }

    protected void openImpl() throws LineUnavailableException {
        int nBufferSize;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.openImpl(): begin");
        }
        this.checkOpen();
        AudioFormat format = this.getFormat();
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.openImpl(): input format: " + format);
        }
        boolean bHWBigEndian = false;
        AudioFormat.Encoding encoding = format.getEncoding();
        boolean bBigEndian = format.isBigEndian();
        this.m_bSwapBytes = false;
        if (format.getSampleSizeInBits() == 16 && bBigEndian != bHWBigEndian) {
            this.m_bSwapBytes = true;
            bBigEndian = bHWBigEndian;
        } else if (format.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (this.getSwapBytes()) {
            format = new AudioFormat(encoding, format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), bBigEndian);
            if (TDebug.TraceSourceDataLine) {
                TDebug.out("AlsaBaseDataLine.openImpl(): output format: " + format);
            }
            this.m_nBytesPerSample = format.getFrameSize() / format.getChannels();
        }
        int nAlsaOutFormat = AlsaUtils.getAlsaFormat(format);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.openImpl(): ALSA output format: " + nAlsaOutFormat);
        }
        if (nAlsaOutFormat == -1) {
            throw new IllegalArgumentException("unsupported format");
        }
        try {
            this.m_alsaPcm = new AlsaPcm(this.getAlsaDataLineMixer().getPcmName(), this.getAlsaStreamType(), 0);
        }
        catch (Exception e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            throw new LineUnavailableException();
        }
        AlsaPcmHWParams hwParams = new AlsaPcmHWParams();
        int nReturn = this.m_alsaPcm.getAnyHWParams(hwParams);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): getAnyHWParams(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setHWParamsAccess(hwParams, 3);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setHWParamsFormat(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setHWParamsFormat(hwParams, nAlsaOutFormat);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setHWParamsFormat(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setHWParamsChannels(hwParams, format.getChannels());
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setHWParamsChannels(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setHWParamsRateNear(hwParams, (int)format.getSampleRate());
        if (nReturn < 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setHWParamsRateNear(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        int nBufferTime = nReturn = this.m_alsaPcm.setHWParamsBufferTimeNear(hwParams, 500000);
        if (nReturn < 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setHWParamsBufferTimeNear(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setHWParamsPeriodTimeNear(hwParams, nBufferTime / 4);
        if (nReturn < 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setHWParamsPeriodTimeNear(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setHWParams(hwParams);
        if (nReturn < 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setHWParams(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        int nChunkSize = hwParams.getPeriodSize(null);
        if (nChunkSize == (nBufferSize = hwParams.getBufferSize())) {
            throw new LineUnavailableException("period size is equal to buffer size");
        }
        AlsaPcmSWParams swParams = new AlsaPcmSWParams();
        nReturn = this.m_alsaPcm.getSWParams(swParams);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): getSWParams(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setSWParamsSleepMin(swParams, 0);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setSWParamsSleepMin(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setSWParamsXrunMode(swParams, 0);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setSWParamsXrunMode(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setSWParamsAvailMin(swParams, nChunkSize);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setSWParamsAvailMin(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        long lStartThreshold = (long)((double)format.getFrameRate() * 1.0 / 1000000.0);
        nReturn = this.m_alsaPcm.setSWParamsStartThreshold(swParams, (int)lStartThreshold);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setSWParamsStartThreshold(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        long lStopThreshold = (long)((double)nBufferSize + (double)format.getFrameRate() * 0.0 / 1000000.0);
        nReturn = this.m_alsaPcm.setSWParamsStopThreshold(swParams, (int)lStopThreshold);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setSWParamsStopThreshold(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        nReturn = this.m_alsaPcm.setSWParams(swParams);
        if (nReturn != 0) {
            TDebug.out("AlsaBaseDataLine.openImpl(): setSWParams(): " + Alsa.getStringError(nReturn));
            throw new LineUnavailableException(Alsa.getStringError(nReturn));
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.openImpl(): end");
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.closeImpl(): begin");
        }
        this.m_alsaPcm.close();
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.closeImpl(): end");
        }
    }

    protected void stopImpl() {
        int nReturn;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.stopImpl(): called");
        }
        if ((nReturn = 0) != 0) {
            TDebug.out("flushChannel: " + Alsa.getStringError(nReturn));
        }
    }

    public int available() {
        return -1;
    }

    public void drain() {
    }

    public void flush() {
    }

    protected void setGain(float dGain) {
    }

    public class AlsaBaseDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN = 90.0f;
        private final float MIN_GAIN = -96.0f;
        private final int GAIN_INCREMENTS = 1000;

        AlsaBaseDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }

        public void setValue(float fGain) {
            if ((double)Math.abs((fGain = Math.max(Math.min(fGain, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(fGain);
                AlsaBaseDataLine.this.setGain(this.getValue());
            }
        }
    }
}

