/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.file.pvorbis;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Packet;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Page;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.StreamState;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.SyncState;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.file.TAudioFileFormat;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.file.TAudioFileReader;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class VorbisAudioFileReader
extends TAudioFileReader {
    private static final int INITAL_READ_LENGTH = 4096;
    private static final int MARK_LIMIT = 4097;

    public VorbisAudioFileReader() {
        super(4097, true);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long lFileSizeInBytes) throws UnsupportedAudioFileException, IOException {
        Packet oggPacket;
        Page oggPage;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out(">VorbisAudioFileReader.getAudioFileFormat(): begin");
        }
        SyncState oggSyncState = new SyncState();
        StreamState oggStreamState = new StreamState();
        try {
            oggPage = new Page();
            oggPacket = new Packet();
        }
        catch (UnsatisfiedLinkError ule) {
            throw new UnsupportedAudioFileException(ule.getMessage());
        }
        int bytes = 0;
        oggSyncState.init();
        byte[] abBuffer = new byte[4096];
        bytes = inputStream.read(abBuffer);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("read bytes from input stream: " + bytes);
        }
        int nResult = oggSyncState.write(abBuffer, bytes);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("SyncState.write() returned " + nResult);
        }
        if (oggSyncState.pageOut(oggPage) != 1) {
            if (bytes < 4096) {
                if (TDebug.TraceAudioFileReader) {
                    TDebug.out("stream ended prematurely");
                }
                if (TDebug.TraceAudioFileReader) {
                    TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
                }
                oggSyncState.free();
                oggStreamState.free();
                oggPacket.free();
                throw new UnsupportedAudioFileException("not a Vorbis stream: ended prematurely");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("not in Ogg bitstream format");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: not in Ogg bitstream format");
        }
        int nSerialNo = oggPage.getSerialNo();
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("serial no.: " + nSerialNo);
        }
        oggStreamState.init(nSerialNo);
        if (oggStreamState.pageIn(oggPage) < 0) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("can't read first page of Ogg bitstream data");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: can't read first page of Ogg bitstream data");
        }
        if (oggStreamState.packetOut(oggPacket) != 1) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("can't read initial header packet");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: can't read initial header packet");
        }
        byte[] abData = oggPacket.getData();
        if (TDebug.TraceAudioFileReader) {
            String strData = "";
            for (int i = 0; i < abData.length; ++i) {
                strData = strData + " " + abData[i];
            }
            TDebug.out("packet data: " + strData);
        }
        byte nPacketType = abData[0];
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("packet type: " + nPacketType);
        }
        if (nPacketType != 1) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("first packet is not the identification header");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: first packet is not the identification header");
        }
        if (abData[1] != 118 || abData[2] != 111 || abData[3] != 114 || abData[4] != 98 || abData[5] != 105 || abData[6] != 115) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("not a vorbis header packet");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: not a vorbis header packet");
        }
        if (!oggPacket.isBos()) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("initial packet not marked as beginning of stream");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: initial packet not marked as beginning of stream");
        }
        int nVersion = (abData[7] & 0xFF) + 256 * (abData[8] & 0xFF) + 65536 * (abData[9] & 0xFF) + 0x1000000 * (abData[10] & 0xFF);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("version: " + nVersion);
        }
        if (nVersion != 0) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("wrong vorbis version");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: wrong vorbis version");
        }
        int nChannels = abData[11] & 0xFF;
        float fSampleRate = (abData[12] & 0xFF) + 256 * (abData[13] & 0xFF) + 65536 * (abData[14] & 0xFF) + 0x1000000 * (abData[15] & 0xFF);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("channels: " + nChannels);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("rate: " + fSampleRate);
        }
        int[] blocksizes = new int[]{1 << (abData[28] & 0xF), 1 << (abData[28] >>> 4 & 0xF)};
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("blocksizes[0]: " + blocksizes[0]);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("blocksizes[1]: " + blocksizes[1]);
        }
        if (fSampleRate < 1.0f || nChannels < 1 || blocksizes[0] < 8 || blocksizes[1] < blocksizes[0] || (abData[29] & 1) != 1) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("illegal values in initial header");
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): throwing exception");
            }
            oggSyncState.free();
            oggStreamState.free();
            oggPacket.free();
            throw new UnsupportedAudioFileException("not a Vorbis stream: illegal values in initial header");
        }
        oggSyncState.free();
        oggStreamState.free();
        oggPacket.free();
        int nByteSize = -1;
        if (lFileSizeInBytes != -1L && lFileSizeInBytes <= Integer.MAX_VALUE) {
            nByteSize = (int)lFileSizeInBytes;
        }
        int nFrameSize = -1;
        AudioFormat format = new AudioFormat(new AudioFormat.Encoding("VORBIS"), fSampleRate, -1, nChannels, -1, -1.0f, true);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AudioFormat: " + format);
        }
        AudioFileFormat.Type type = new AudioFileFormat.Type("Ogg", "ogg");
        TAudioFileFormat audioFileFormat = new TAudioFileFormat(type, format, nFrameSize, nByteSize);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AudioFileFormat: " + audioFileFormat);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("<VorbisAudioFileReader.getAudioFileFormat(): end");
        }
        return audioFileFormat;
    }
}

