/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.file;

import io.github.maki99999.biomebeats.org.tritonus.sampled.file.AiffAudioOutputStream;
import io.github.maki99999.biomebeats.org.tritonus.sampled.file.AiffTool;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.file.AudioOutputStream;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.file.TAudioFileWriter;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.file.TDataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

public class AiffAudioFileWriter
extends TAudioFileWriter {
    private static final AudioFileFormat.Type[] FILE_TYPES = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF, AudioFileFormat.Type.AIFC};
    private static final AudioFormat.Encoding ULAW = AudioFormat.Encoding.ULAW;
    private static final AudioFormat.Encoding IMA_ADPCM = new AudioFormat.Encoding("IMA_ADPCM");
    private static final AudioFormat[] AUDIO_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ULAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ULAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, true), new AudioFormat(IMA_ADPCM, -1.0f, 4, -1, -1, -1.0f, true), new AudioFormat(IMA_ADPCM, -1.0f, 4, -1, -1, -1.0f, false)};

    public AiffAudioFileWriter() {
        super(Arrays.asList(FILE_TYPES), Arrays.asList(AUDIO_FORMATS));
    }

    protected boolean isAudioFormatSupportedImpl(AudioFormat format, AudioFileFormat.Type fileType) {
        return AiffTool.getFormatCode(format) != 0;
    }

    protected AudioOutputStream getAudioOutputStream(AudioFormat audioFormat, long lLengthInBytes, AudioFileFormat.Type fileType, TDataOutputStream dataOutputStream) throws IOException {
        return new AiffAudioOutputStream(audioFormat, fileType, lLengthInBytes, dataOutputStream);
    }
}

