/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.sampled.convert.lame;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.lame.Lame;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.AudioFormatSet;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class Mp3LameFormatConversionProvider
extends TSimpleFormatConversionProvider {
    private static final int ALL = -1;
    private static final int MPEG_BITS_PER_SAMPLE = -1;
    private static final int MPEG_FRAME_RATE = -1;
    private static final int MPEG_FRAME_SIZE = -1;
    public static final AudioFormat.Encoding MPEG1L3 = Lame.MPEG1L3;
    public static final AudioFormat.Encoding MPEG2L3 = Lame.MPEG2L3;
    public static final AudioFormat.Encoding MPEG2DOT5L3 = Lame.MPEG2DOT5L3;
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 8000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 8000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 11025.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 11025.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 12000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 12000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 16000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 16000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 22050.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 22050.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 24000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 24000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, true)};
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};

    public Mp3LameFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
        if (!Lame.isLibAvailable()) {
            this.disable();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("******* Error initializing LAME mp3 encoder: " + Lame.getLinkError());
            }
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        if (this.isConversionSupported(targetFormat, audioInputStream.getFormat())) {
            return new EncodedMpegAudioInputStream(this.getDefaultTargetFormat(targetFormat, audioInputStream.getFormat(), false), audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">MP3Lame getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking out possible target formats");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to  : " + targetEncoding);
        }
        if (this.isConversionSupported(targetEncoding, sourceFormat)) {
            AudioFormatSet result = new AudioFormatSet();
            for (AudioFormat targetFormat : this.getCollectionTargetFormats()) {
                if (!Mp3LameFormatConversionProvider.doMatch(targetFormat.getSampleRate(), sourceFormat.getSampleRate()) || !targetFormat.getEncoding().equals(targetEncoding) || !Mp3LameFormatConversionProvider.doMatch(targetFormat.getChannels(), sourceFormat.getChannels())) continue;
                targetFormat = this.getDefaultTargetFormat(targetFormat, sourceFormat, true);
                result.add(targetFormat);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<found " + result.size() + " matching formats.");
            }
            return result.toAudioFormatArray();
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<returning empty array.");
        }
        return EMPTY_FORMAT_ARRAY;
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat targetFormat, AudioFormat sourceFormat, boolean allowNotSpecified) {
        float targetSampleRate = targetFormat.getSampleRate();
        if (targetSampleRate == -1.0f) {
            targetSampleRate = sourceFormat.getSampleRate();
        }
        if (!allowNotSpecified && targetSampleRate == -1.0f || targetSampleRate != -1.0f && sourceFormat.getSampleRate() != -1.0f && targetSampleRate != sourceFormat.getSampleRate()) {
            throw new IllegalArgumentException("Illegal sample rate (" + targetSampleRate + ") !");
        }
        int targetChannels = targetFormat.getChannels();
        if (targetChannels == -1) {
            targetChannels = sourceFormat.getChannels();
        }
        if (!allowNotSpecified && targetChannels == -1 || targetChannels != -1 && sourceFormat.getChannels() != -1 && targetChannels != sourceFormat.getChannels()) {
            throw new IllegalArgumentException("Illegal number of channels (" + targetChannels + ") !");
        }
        AudioFormat newTargetFormat = new AudioFormat(targetFormat.getEncoding(), targetSampleRate, -1, targetChannels, this.getFrameSize(targetFormat.getEncoding(), targetSampleRate, -1, targetChannels, -1.0f, false, 0), -1.0f, false, targetFormat.properties());
        return newTargetFormat;
    }

    protected int getFrameSize(AudioFormat.Encoding encoding, float sampleRate, int sampleSize, int channels, float frameRate, boolean bigEndian, int oldFrameSize) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            return super.getFrameSize(encoding, sampleRate, sampleSize, channels, frameRate, bigEndian, oldFrameSize);
        }
        return -1;
    }

    public static class EncodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream pcmStream;
        private Lame encoder;
        private byte[] pcmBuffer;
        private byte[] encodedBuffer;

        public EncodedMpegAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
            super(targetFormat, -1L);
            this.pcmStream = sourceStream;
            this.encoder = new Lame(sourceStream.getFormat(), targetFormat);
            this.format = this.encoder.getEffectiveFormat();
            this.pcmBuffer = new byte[this.encoder.getPCMBufferSize()];
            this.encodedBuffer = new byte[this.encoder.getMP3BufferSize()];
        }

        public void execute() {
            block10: {
                try {
                    if (this.encoder == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("mp3 lame encoder is null (already at end of stream)");
                        }
                        this.getCircularBuffer().close();
                        return;
                    }
                    int encodedBytes = 0;
                    byte[] buffer = null;
                    while (encodedBytes == 0 && this.encoder != null) {
                        int readBytes = this.pcmStream.read(this.pcmBuffer);
                        if (readBytes > 0) {
                            encodedBytes = this.encoder.encodeBuffer(this.pcmBuffer, 0, readBytes, this.encodedBuffer);
                            buffer = this.encodedBuffer;
                            continue;
                        }
                        buffer = this.encodedBuffer.length > this.pcmBuffer.length ? this.encodedBuffer : this.pcmBuffer;
                        encodedBytes = this.encoder.encodeFinish(buffer);
                        this.encoder.close();
                        this.encoder = null;
                    }
                    if (encodedBytes > 0) {
                        this.getCircularBuffer().write(buffer, 0, encodedBytes);
                    }
                    if (this.encoder == null) {
                        this.getCircularBuffer().close();
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (TDebug.TraceAudioConverter || TDebug.TraceAllExceptions) {
                        TDebug.out(e);
                    }
                }
                catch (IOException e) {
                    if (!TDebug.TraceAudioConverter && !TDebug.TraceAllExceptions) break block10;
                    TDebug.out(e);
                }
            }
        }

        public void close() throws IOException {
            super.close();
            this.pcmStream.close();
            if (this.encoder != null) {
                this.encoder.encodeFinish(null);
                this.encoder.close();
                this.encoder = null;
            }
        }
    }
}

