/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.midi.device.fluidsynth;

import io.github.maki99999.biomebeats.org.tritonus.midi.sb.fluidsynth.FluidSoundbank;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.midi.TDirectSynthesizer;
import io.github.maki99999.biomebeats.org.tritonus.share.midi.TMidiChannel;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.VoiceStatus;

public class FluidSynthesizer
extends TDirectSynthesizer
implements Synthesizer {
    private MidiChannel[] channels;
    private FluidSoundbank defaultSoundbank;
    private int defaultbankSfontID;
    private long settingsPtr;
    private long synthPtr;
    private long audioDriverPtr;

    private static void loadNativeLibrary() {
        block4: {
            if (TDebug.TraceFluidNative) {
                TDebug.out("FluidSynthesizer.loadNativeLibrary(): loading native library tritonusfluid");
            }
            try {
                System.loadLibrary("tritonusfluid");
                FluidSynthesizer.setTrace(TDebug.TraceFluidNative);
            }
            catch (Error e) {
                if (!TDebug.TraceFluidNative && !TDebug.TraceAllExceptions) break block4;
                TDebug.out(e);
            }
        }
        if (TDebug.TraceFluidNative) {
            TDebug.out("FluidSynthesizer.loadNativeLibrary(): loaded");
        }
    }

    public FluidSynthesizer(MidiDevice.Info info) throws Exception {
        super(info);
    }

    protected void openImpl() throws MidiUnavailableException {
        if (this.newSynth() < 0) {
            throw new MidiUnavailableException("Low-level initialization of the synthesizer failed");
        }
        if (TDebug.TraceSynthesizer) {
            TDebug.out("FluidSynthesizer: " + Long.toHexString(this.synthPtr));
        }
        this.channels = new MidiChannel[16];
        for (int i = 0; i < 16; ++i) {
            this.channels[i] = new NewFluidMidiChannel(i);
        }
        String sfontFile = System.getProperty("tritonus.fluidsynth.defaultsoundbank");
        if (sfontFile != null && !sfontFile.equals("")) {
            int sfontID = this.loadSoundFont(sfontFile);
            this.setDefaultSoundBank(sfontID);
            String strBankOffset = System.getProperty("tritonus.fluidsynth.defaultsoundbankoffset");
            if (strBankOffset != null && !strBankOffset.equals("")) {
                this.setBankOffset(sfontID, Integer.parseInt(strBankOffset));
            }
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceSynthesizer) {
            TDebug.out("FluidSynthesizer.closeImpl(): " + Long.toHexString(this.synthPtr));
        }
        this.deleteSynth();
        super.closeImpl();
    }

    public void setDefaultSoundBank(int sfontID) {
        this.defaultSoundbank = new FluidSoundbank(this, sfontID);
        this.defaultbankSfontID = sfontID;
    }

    protected void finalize() {
        if (TDebug.TraceSynthesizer) {
            TDebug.out("finalize: " + Long.toHexString(this.synthPtr));
        }
        this.close();
    }

    public native int loadSoundFont(String var1);

    public native void setBankOffset(int var1, int var2);

    public native void setGain(float var1);

    public native void setReverbPreset(int var1);

    public native int getMaxPolyphony();

    protected native int newSynth();

    protected native void deleteSynth();

    native void noteOn(int var1, int var2, int var3);

    native void noteOff(int var1, int var2, int var3);

    native void controlChange(int var1, int var2, int var3);

    native int getController(int var1, int var2);

    native void programChange(int var1, int var2);

    native int getProgram(int var1);

    native void setPitchBend(int var1, int var2);

    native int getPitchBend(int var1);

    public static native void setTrace(boolean var0);

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return soundbank instanceof FluidSoundbank;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        this.checkSoundbank(soundbank);
        return true;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
        this.checkSoundbank(soundbank);
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
        this.checkSoundbank(soundbank);
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        this.checkSoundbank(soundbank);
        return true;
    }

    public void unloadInstrument(Instrument instrument) {
        this.checkInstrument(instrument);
    }

    public boolean loadInstrument(Instrument instrument) {
        this.checkInstrument(instrument);
        return true;
    }

    public Instrument[] getAvailableInstruments() {
        return null;
    }

    public MidiChannel[] getChannels() {
        return this.channels;
    }

    public Soundbank getDefaultSoundbank() {
        return this.defaultSoundbank;
    }

    public long getLatency() {
        return 0L;
    }

    public Instrument[] getLoadedInstruments() {
        return null;
    }

    public VoiceStatus[] getVoiceStatus() {
        return new VoiceStatus[0];
    }

    public boolean remapInstrument(Instrument from, Instrument to) {
        this.checkInstrument(from);
        this.checkInstrument(to);
        return true;
    }

    private void checkSoundbank(Soundbank sb) {
        if (!this.isSoundbankSupported(sb)) {
            throw new IllegalArgumentException("soundbank is not supported");
        }
    }

    private void checkInstrument(Instrument instr) {
        this.checkSoundbank(instr.getSoundbank());
    }

    static {
        FluidSynthesizer.loadNativeLibrary();
    }

    private class NewFluidMidiChannel
    extends TMidiChannel {
        public NewFluidMidiChannel(int nChannel) {
            super(nChannel);
        }

        public void noteOn(int nNoteNumber, int nVelocity) {
            FluidSynthesizer.this.noteOn(this.getChannel(), nNoteNumber, nVelocity);
        }

        public void noteOff(int nNoteNumber, int nVelocity) {
            FluidSynthesizer.this.noteOff(this.getChannel(), nNoteNumber, nVelocity);
        }

        public void noteOff(int nNoteNumber) {
            this.noteOff(nNoteNumber, 0);
        }

        public void setPolyPressure(int nNoteNumber, int nPressure) {
        }

        public int getPolyPressure(int nNoteNumber) {
            return 0;
        }

        public void setChannelPressure(int nPressure) {
        }

        public int getChannelPressure() {
            return 0;
        }

        public void controlChange(int nController, int nValue) {
            FluidSynthesizer.this.controlChange(this.getChannel(), nController, nValue);
        }

        public int getController(int nController) {
            return FluidSynthesizer.this.getController(this.getChannel(), nController);
        }

        public void programChange(int nProgram) {
            FluidSynthesizer.this.programChange(this.getChannel(), nProgram);
        }

        public int getProgram() {
            return FluidSynthesizer.this.getProgram(this.getChannel());
        }

        public void setPitchBend(int nBend) {
            FluidSynthesizer.this.setPitchBend(this.getChannel(), nBend);
        }

        public int getPitchBend() {
            return FluidSynthesizer.this.getPitchBend(this.getChannel());
        }

        public void setMute(boolean bMute) {
        }

        public boolean getMute() {
            return false;
        }

        public void setSolo(boolean bSolo) {
        }

        public boolean getSolo() {
            return false;
        }
    }
}

