/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeq;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqQueueInfo;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqQueueStatus;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqQueueTempo;
import io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa.AlsaMidiIn;
import io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa.AlsaMidiOut;
import io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa.AlsaReceiver;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.midi.MidiUtils;
import io.github.maki99999.biomebeats.org.tritonus.share.midi.TMidiDevice;
import io.github.maki99999.biomebeats.org.tritonus.share.midi.TSequencer;
import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

public class AlsaSequencer
extends TSequencer {
    private static final Sequencer.SyncMode[] MASTER_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static final Sequencer.SyncMode[] SLAVE_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC, Sequencer.SyncMode.MIDI_SYNC};
    private static final int CLOCK_EVENT_TAG = 255;
    private AlsaSeq m_playbackAlsaSeq;
    private AlsaSeq m_recordingAlsaSeq;
    private int m_nRecordingPort;
    private int m_nPlaybackPort;
    private int m_nQueue;
    private AlsaSeqQueueInfo m_queueInfo;
    private AlsaSeqQueueStatus m_queueStatus;
    private AlsaSeqQueueTempo m_queueTempo;
    private AlsaMidiIn m_playbackAlsaMidiIn;
    private AlsaMidiOut m_playbackAlsaMidiOut;
    private AlsaMidiIn m_recordingAlsaMidiIn;
    protected LoaderThread m_loaderThread;
    private Thread m_syncThread;
    private AlsaSeqEvent m_queueControlEvent;
    protected AlsaSeqEvent m_clockEvent;
    private boolean m_bRecording;
    private Track m_track;
    private AlsaSeqEvent m_allNotesOffEvent;
    private Sequencer.SyncMode m_oldSlaveSyncMode;
    private float m_fCachedRealMPQ = -1.0f;

    public AlsaSequencer(MidiDevice.Info info) {
        super(info, Arrays.asList(MASTER_SYNC_MODES), Arrays.asList(SLAVE_SYNC_MODES));
    }

    protected int getPlaybackClient() {
        int nClient = this.getPlaybackAlsaSeq().getClientId();
        return nClient;
    }

    protected int getPlaybackPort() {
        return this.m_nPlaybackPort;
    }

    protected int getRecordingClient() {
        int nClient = this.getRecordingAlsaSeq().getClientId();
        return nClient;
    }

    protected int getRecordingPort() {
        return this.m_nRecordingPort;
    }

    protected int getQueue() {
        return this.m_nQueue;
    }

    private AlsaSeqQueueStatus getQueueStatus() {
        return this.m_queueStatus;
    }

    private AlsaSeqQueueTempo getQueueTempo() {
        return this.m_queueTempo;
    }

    private AlsaSeq getPlaybackAlsaSeq() {
        return this.m_playbackAlsaSeq;
    }

    protected AlsaSeq getRecordingAlsaSeq() {
        return this.m_recordingAlsaSeq;
    }

    private void updateQueueStatus() {
        this.getPlaybackAlsaSeq().getQueueStatus(this.getQueue(), this.getQueueStatus());
    }

    protected void openImpl() {
        this.m_recordingAlsaSeq = new AlsaSeq("Tritonus ALSA Sequencer (recording/synchronization)");
        this.m_nRecordingPort = this.getRecordingAlsaSeq().createPort("recording/synchronization port", 99, 0, 0x100000, 0, 0, 0);
        this.m_playbackAlsaSeq = new AlsaSeq("Tritonus ALSA Sequencer (playback)");
        this.m_nPlaybackPort = this.getPlaybackAlsaSeq().createPort("playback port", 99, 0, 0x100000, 0, 0, 0);
        this.m_nQueue = this.getPlaybackAlsaSeq().allocQueue();
        this.m_queueInfo = new AlsaSeqQueueInfo();
        this.m_queueStatus = new AlsaSeqQueueStatus();
        this.m_queueTempo = new AlsaSeqQueueTempo();
        this.getPlaybackAlsaSeq().getQueueInfo(this.getQueue(), this.m_queueInfo);
        this.m_queueInfo.setLocked(false);
        this.getPlaybackAlsaSeq().setQueueInfo(this.getQueue(), this.m_queueInfo);
        this.m_playbackAlsaMidiOut = new AlsaMidiOut(this.getPlaybackAlsaSeq(), this.getPlaybackPort(), this.getQueue());
        this.m_playbackAlsaMidiOut.setHandleMetaMessages(true);
        this.getRecordingAlsaSeq().setQueueUsage(this.getQueue(), true);
        PlaybackAlsaMidiInListener playbackListener = new PlaybackAlsaMidiInListener();
        this.m_playbackAlsaMidiIn = new AlsaMidiIn(this.getPlaybackAlsaSeq(), this.getPlaybackPort(), this.getPlaybackClient(), this.getPlaybackPort(), playbackListener);
        this.m_playbackAlsaMidiIn.start();
        this.m_queueControlEvent = new AlsaSeqEvent();
        this.m_clockEvent = new AlsaSeqEvent();
        this.m_clockEvent.setCommon(36, 0, 255, this.getQueue(), 0L, 0, this.getRecordingPort(), 254, 253);
        this.m_allNotesOffEvent = new AlsaSeqEvent();
        this.m_oldSlaveSyncMode = this.getSlaveSyncMode();
        if (this.m_fCachedRealMPQ != -1.0f) {
            this.setTempoImpl(this.m_fCachedRealMPQ);
            this.m_fCachedRealMPQ = -1.0f;
        }
        this.m_loaderThread = new LoaderThread();
        this.m_loaderThread.start();
    }

    protected void closeImpl() {
        this.m_playbackAlsaMidiIn.interrupt();
        this.m_playbackAlsaMidiIn = null;
        this.getQueueStatus().free();
        this.m_queueStatus = null;
        this.getQueueTempo().free();
        this.m_queueTempo = null;
        this.getRecordingAlsaSeq().close();
        this.m_recordingAlsaSeq = null;
        this.getPlaybackAlsaSeq().close();
        this.m_playbackAlsaSeq = null;
        this.m_queueControlEvent.free();
        this.m_queueControlEvent = null;
        this.m_clockEvent.free();
        this.m_clockEvent = null;
        this.m_allNotesOffEvent.free();
        this.m_allNotesOffEvent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startImpl() {
        if (this.getTickPosition() == 0L) {
            this.startQueue();
        } else {
            this.continueQueue();
        }
        LoaderThread loaderThread = this.m_loaderThread;
        synchronized (loaderThread) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.startImpl(): notifying loader thread");
            }
            this.m_loaderThread.notify();
        }
        if (!this.getSlaveSyncMode().equals(Sequencer.SyncMode.NO_SYNC)) {
            this.sendStartEvent();
        }
    }

    protected void stopImpl() {
        this.stopQueue();
        this.sendAllNotesOff();
        this.stopRecording();
        if (!this.getSlaveSyncMode().equals(Sequencer.SyncMode.NO_SYNC)) {
            this.sendStopEvent();
        }
    }

    protected void setSequenceImpl() {
        if (this.m_loaderThread != null) {
            this.m_loaderThread.setLoading(this.getSequence() != null);
        }
    }

    public boolean isRunning() {
        boolean bRunning = false;
        if (this.isOpen()) {
            this.updateQueueStatus();
            int nStatus = this.getQueueStatus().getStatus();
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.isRunning(): queue status: " + nStatus);
            }
            bRunning = nStatus != 0;
        }
        return bRunning;
    }

    public void startRecording() {
        this.checkOpen();
        this.m_bRecording = true;
        this.start();
    }

    public void stopRecording() {
        this.checkOpen();
        this.m_bRecording = false;
    }

    public boolean isRecording() {
        return this.m_bRecording;
    }

    public void recordEnable(Track track, int nChannel) {
        this.m_track = track;
    }

    public void recordDisable(Track track) {
    }

    protected void setTempoImpl(float fRealMPQ) {
        if (this.isOpen()) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.setTempoImpl(): setting tempo to " + (int)fRealMPQ);
            }
            this.getQueueTempo().setTempo((int)fRealMPQ);
            this.getQueueTempo().setPpq(this.getResolution());
            this.getPlaybackAlsaSeq().setQueueTempo(this.getQueue(), this.getQueueTempo());
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.setTempoImpl(): ignoring because sequencer is not open");
            }
            this.m_fCachedRealMPQ = fRealMPQ;
        }
    }

    public long getTickPosition() {
        long lPosition;
        if (this.isOpen()) {
            this.updateQueueStatus();
            lPosition = this.getQueueStatus().getTickTime();
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.getTickPosition(): sequencer not open, returning 0");
            }
            lPosition = 0L;
        }
        return lPosition;
    }

    public void setTickPosition(long lTick) {
        if (this.isOpen()) {
            int nSourcePort = this.getRecordingPort();
            int nQueue = this.getQueue();
            long lTime = lTick;
            this.sendQueueControlEvent(33, 3, 0, 253, 0L, nSourcePort, 0, 0, nQueue, 0, lTime);
        } else if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTickPosition(): ignored because sequencer is not open");
        }
    }

    public long getMicrosecondPosition() {
        long lPosition;
        if (this.isOpen()) {
            this.updateQueueStatus();
            long lNanoSeconds = this.getQueueStatus().getRealTime();
            lPosition = lNanoSeconds / 1000L;
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.getMicrosecondPosition(): sequencer not open, returning 0");
            }
            lPosition = 0L;
        }
        return lPosition;
    }

    public void setMicrosecondPosition(long lMicroseconds) {
        if (this.isOpen()) {
            long lNanoSeconds = lMicroseconds * 1000L;
            int nSourcePort = this.getRecordingPort();
            int nQueue = this.getQueue();
            long lTime = lNanoSeconds;
            this.sendQueueControlEvent(34, 3, 0, 253, 0L, nSourcePort, 0, 0, nQueue, 0, lTime);
        } else if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setMicrosecondPosition(): ignoring because sequencer is not open");
        }
    }

    protected void setMasterSyncModeImpl(Sequencer.SyncMode syncMode) {
    }

    protected void setSlaveSyncModeImpl(Sequencer.SyncMode syncMode) {
        if (this.isRunning()) {
            if (this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.NO_SYNC) && (syncMode.equals(Sequencer.SyncMode.MIDI_SYNC) || syncMode.equals(Sequencer.SyncMode.MIDI_TIME_CODE))) {
                this.sendStartEvent();
            } else if ((this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.MIDI_SYNC) || this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.MIDI_TIME_CODE)) && syncMode.equals(Sequencer.SyncMode.NO_SYNC)) {
                this.sendStopEvent();
            }
        }
    }

    protected void setTrackEnabledImpl(int nTrack, boolean bEnabled) {
        if (bEnabled) {
            // empty if block
        }
    }

    protected synchronized void enqueueMessage(MidiMessage message, long lTick) {
        this.m_playbackAlsaMidiOut.enqueueMessage(message, lTick);
    }

    public void sendMessageTick(MidiMessage message, long lTick) {
        this.enqueueMessage(message, lTick);
    }

    private void startQueue() {
        this.controlQueue(30);
    }

    private void continueQueue() {
        this.controlQueue(31);
    }

    private void stopQueue() {
        this.controlQueue(32);
    }

    private void controlQueue(int nType) {
        int nSourcePort = this.getPlaybackPort();
        int nQueue = this.getQueue();
        this.sendQueueControlEvent(nType, 3, 0, 253, 0L, nSourcePort, 0, 0, nQueue, 0, 0L);
    }

    private void sendStartEvent() {
        this.sendRealtimeEvent(30);
    }

    private void sendStopEvent() {
        this.sendRealtimeEvent(32);
    }

    private void sendRealtimeEvent(int nType) {
        this.sendQueueControlEvent(nType, 3, 0, 253, 0L, this.getPlaybackPort(), 254, 253, 0, 0, 0L);
    }

    private void sendQueueControlEvent(int nType, int nFlags, int nTag, int nQueue, long lTime, int nSourcePort, int nDestClient, int nDestPort, int nControlQueue, int nControlValue, long lControlTime) {
        this.m_queueControlEvent.setCommon(nType, nFlags, nTag, nQueue, lTime, 0, nSourcePort, nDestClient, nDestPort);
        this.m_queueControlEvent.setQueueControl(nControlQueue, nControlValue, lControlTime);
        this.getPlaybackAlsaSeq().eventOutputDirect(this.m_queueControlEvent);
    }

    private void sendAllNotesOffEvent(int nChannel) {
        int nSourcePort = this.getPlaybackPort();
        this.m_allNotesOffEvent.setCommon(10, 3, 0, 253, 0L, 0, nSourcePort, 254, 253);
        this.m_allNotesOffEvent.setControl(nChannel, 120, 0);
        this.getPlaybackAlsaSeq().eventOutputDirect(this.m_allNotesOffEvent);
    }

    private void sendAllNotesOff() {
        for (int nChannel = 0; nChannel < 16; ++nChannel) {
            this.sendAllNotesOffEvent(nChannel);
        }
    }

    protected void receiveTimestamped(MidiMessage message, long lTimestamp) {
        if (this.isRecording()) {
            Track track = this.m_track;
            MidiEvent event = new MidiEvent(message, lTimestamp);
            track.add(event);
        }
    }

    protected void receive(MidiMessage message, long lTimestamp) {
        lTimestamp = this.getTickPosition();
        this.receiveTimestamped(message, lTimestamp);
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        return new AlsaSequencerReceiver();
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        return new AlsaSequencerTransmitter();
    }

    public class MasterSynchronizer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (AlsaSequencer.this.isOpen()) {
                do {
                    MasterSynchronizer masterSynchronizer = this;
                    synchronized (masterSynchronizer) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (!AlsaSequencer.this.isRunning());
                double dTickMin = AlsaSequencer.this.getTickPosition();
                double dTickMax = AlsaSequencer.this.getSequence().getTickLength();
                double dTickStep = (double)AlsaSequencer.this.getSequence().getResolution() / 24.0;
                if (TDebug.TraceSequencer) {
                    TDebug.out("MasterSynchronizer.run(): tick step: " + dTickStep);
                }
                for (double dTick = dTickMin; dTick < dTickMax && AlsaSequencer.this.isRunning(); dTick += dTickStep) {
                    long lTick = Math.round(dTick);
                    if (TDebug.TraceSequencer) {
                        TDebug.out("MasterSynchronizer.run(): sending clock event with tick " + lTick);
                    }
                    AlsaSequencer.this.m_clockEvent.setTimestamp(lTick);
                    AlsaSequencer.this.getRecordingAlsaSeq().eventOutput(AlsaSequencer.this.m_clockEvent);
                    AlsaSequencer.this.getRecordingAlsaSeq().drainOutput();
                }
            }
        }
    }

    public class LoaderThread
    extends Thread {
        private long m_lLoadingPosition = 0L;
        private long m_lStartPosition;
        private boolean m_bLoading;
        private Track[] m_aTracks;
        private int[] m_anTrackPositions;

        public LoaderThread() {
            this.initTracks();
            this.setLoading(AlsaSequencer.this.getSequence() != null);
        }

        private void initTracks() {
            Sequence sequence = AlsaSequencer.this.getSequence();
            if (this.m_aTracks == null && sequence != null) {
                this.m_aTracks = sequence.getTracks();
                this.m_anTrackPositions = new int[this.m_aTracks.length];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLoading(boolean bLoading) {
            if (TDebug.TraceSequencer) {
                TDebug.out("LoaderThread.setLoading(): new value: " + bLoading);
            }
            this.m_bLoading = bLoading;
            LoaderThread loaderThread = this;
            synchronized (loaderThread) {
                this.notify();
            }
        }

        private boolean isLoading() {
            return this.m_bLoading;
        }

        public void setStartPosition(long lTicks) {
            this.setLoading(false);
            this.m_lStartPosition = lTicks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (AlsaSequencer.this.isOpen()) {
                do {
                    LoaderThread loaderThread = this;
                    synchronized (loaderThread) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (!AlsaSequencer.this.isRunning() || !this.isLoading());
                if (!AlsaSequencer.this.isOpen()) continue;
                this.loadSequenceToNative();
            }
        }

        private void loadSequenceToNative() {
            this.initTracks();
            for (int i = 0; i < this.m_aTracks.length; ++i) {
                this.m_anTrackPositions[i] = 0;
            }
            while (AlsaSequencer.this.isRunning() && this.isLoading()) {
                boolean bTrackPresent = false;
                long lBestTick = Long.MAX_VALUE;
                int nBestTrack = -1;
                for (int nTrack = 0; nTrack < this.m_aTracks.length; ++nTrack) {
                    if (this.m_anTrackPositions[nTrack] >= this.m_aTracks[nTrack].size()) continue;
                    bTrackPresent = true;
                    MidiEvent event = this.m_aTracks[nTrack].get(this.m_anTrackPositions[nTrack]);
                    long lTick = event.getTick();
                    if (lTick < this.m_lStartPosition || lTick >= lBestTick) continue;
                    lBestTick = lTick;
                    nBestTrack = nTrack;
                }
                if (!bTrackPresent) {
                    MetaMessage metaMessage = new MetaMessage();
                    try {
                        metaMessage.setMessage(47, new byte[0], 0);
                    }
                    catch (InvalidMidiDataException event) {
                        // empty catch block
                    }
                    AlsaSequencer.this.enqueueMessage(metaMessage, this.m_lLoadingPosition + 1L);
                    this.setLoading(false);
                }
                MidiEvent event = this.m_aTracks[nBestTrack].get(this.m_anTrackPositions[nBestTrack]);
                int n = nBestTrack;
                this.m_anTrackPositions[n] = this.m_anTrackPositions[n] + 1;
                long lTick = event.getTick();
                this.m_lLoadingPosition = Math.max(this.m_lLoadingPosition, lTick);
                MidiMessage message = event.getMessage();
                this.processMessage(message, lTick);
            }
        }

        private void processMessage(MidiMessage message, long lTick) {
            boolean bMessageConsumed = false;
            if (message instanceof MetaMessage) {
                MetaMessage metaMessage = (MetaMessage)message;
                int nType = metaMessage.getType();
                if (nType == 47) {
                    bMessageConsumed = true;
                    if (TDebug.TraceSequencer) {
                        TDebug.out("LoaderThread.loadSequenceToNative(): ignoring End of Track message with tick " + lTick);
                    }
                } else if (nType == 6) {
                    String strMarkerText = new String(metaMessage.getData());
                    if (strMarkerText.equals("loopstart")) {
                        AlsaSequencer.this.setLoopStartPoint(lTick);
                        bMessageConsumed = true;
                    } else if (strMarkerText.equals("loopend")) {
                        AlsaSequencer.this.setLoopEndPoint(lTick);
                        AlsaSequencer.this.setLoopCount(-1);
                        bMessageConsumed = false;
                        this.setLoading(false);
                    }
                }
            }
            if (!bMessageConsumed) {
                if (TDebug.TraceSequencer) {
                    TDebug.out("LoaderThread.loadSequenceToNative(): enqueueing event with tick " + lTick);
                }
                AlsaSequencer.this.enqueueMessage(message, lTick);
            }
        }
    }

    public class AlsaSequencerTransmitter
    extends TMidiDevice.TTransmitter {
        private boolean m_bReceiverSubscribed;

        public AlsaSequencerTransmitter() {
            super(AlsaSequencer.this);
            this.m_bReceiverSubscribed = false;
        }

        public void setReceiver(Receiver receiver) {
            super.setReceiver(receiver);
            if (receiver instanceof AlsaReceiver) {
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaSequencer.this.getPlaybackClient(), AlsaSequencer.this.getPlaybackPort());
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaSequencer.this.getRecordingClient(), AlsaSequencer.this.getRecordingPort());
            }
        }

        public void send(MidiMessage message, long lTimeStamp) {
            if (!this.m_bReceiverSubscribed) {
                super.send(message, lTimeStamp);
            }
        }

        public void close() {
            super.close();
        }
    }

    public class AlsaSequencerReceiver
    extends TMidiDevice.TReceiver
    implements AlsaReceiver {
        public AlsaSequencerReceiver() {
            super(AlsaSequencer.this);
        }

        public boolean subscribeTo(int nClient, int nPort) {
            try {
                AlsaSeqPortSubscribe portSubscribe = new AlsaSeqPortSubscribe();
                portSubscribe.setSender(nClient, nPort);
                portSubscribe.setDest(AlsaSequencer.this.getRecordingClient(), AlsaSequencer.this.getRecordingPort());
                portSubscribe.setQueue(AlsaSequencer.this.getQueue());
                portSubscribe.setExclusive(false);
                portSubscribe.setTimeUpdate(true);
                portSubscribe.setTimeReal(false);
                AlsaSequencer.this.getRecordingAlsaSeq().subscribePort(portSubscribe);
                portSubscribe.free();
                return true;
            }
            catch (RuntimeException e) {
                return false;
            }
        }
    }

    public class RecordingAlsaMidiInListener
    implements AlsaMidiIn.AlsaMidiInListener {
        public void dequeueEvent(MidiMessage message, long lTimestamp) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.RecordingAlsaMidiInListener.dequeueEvent(): message: " + message);
            }
            AlsaSequencer.this.receiveTimestamped(message, lTimestamp);
        }
    }

    public class PlaybackAlsaMidiInListener
    implements AlsaMidiIn.AlsaMidiInListener {
        public void dequeueEvent(MidiMessage message, long lTimestamp) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.PlaybackAlsaMidiInListener.dequeueEvent(): message: " + message);
            }
            if (message instanceof MetaMessage) {
                MetaMessage metaMessage = (MetaMessage)message;
                byte[] abData = metaMessage.getData();
                switch (metaMessage.getType()) {
                    case 6: {
                        String strMarkerText = new String(abData);
                        if (!strMarkerText.equals("loopend")) break;
                        AlsaSequencer.this.setTickPosition(AlsaSequencer.this.getLoopStartPoint());
                        AlsaSequencer.this.m_loaderThread.setStartPosition(AlsaSequencer.this.getLoopStartPoint());
                        AlsaSequencer.this.m_loaderThread.setLoading(true);
                        break;
                    }
                    case 81: {
                        int nTempo = MidiUtils.getUnsignedInteger(abData[0]) * 65536 + MidiUtils.getUnsignedInteger(abData[1]) * 256 + MidiUtils.getUnsignedInteger(abData[2]);
                        AlsaSequencer.this.setTempoInMPQ(nTempo);
                    }
                }
            }
            AlsaSequencer.this.sendImpl(message, -1L);
            AlsaSequencer.this.notifyListeners(message);
        }
    }
}

