/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeq;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.alsa.AlsaSeqQueueStatus;
import io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa.AlsaMidiIn;
import io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa.AlsaMidiOut;
import io.github.maki99999.biomebeats.org.tritonus.midi.device.alsa.AlsaReceiver;
import io.github.maki99999.biomebeats.org.tritonus.share.GlobalInfo;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;
import io.github.maki99999.biomebeats.org.tritonus.share.midi.TMidiDevice;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class AlsaMidiDevice
extends TMidiDevice
implements AlsaMidiIn.AlsaMidiInListener {
    private int m_nPhysicalClient;
    private int m_nPhysicalPort;
    private AlsaSeq m_alsaSeq;
    private AlsaSeqQueueStatus m_queueStatus;
    private int m_nOwnPort;
    private AlsaMidiIn m_alsaMidiIn;
    private AlsaMidiOut m_alsaMidiOut;
    private int m_nTimestampingQueue;
    private AlsaSeqEvent m_event = new AlsaSeqEvent();

    public AlsaMidiDevice(int nClient, int nPort, boolean bUseIn, boolean bUseOut) {
        this(new TMidiDevice.Info("ALSA MIDI port (" + nClient + ":" + nPort + ")", GlobalInfo.getVendor(), "ALSA MIDI port (" + nClient + ":" + nPort + ")", GlobalInfo.getVersion()), nClient, nPort, bUseIn, bUseOut);
    }

    protected AlsaMidiDevice(MidiDevice.Info info, int nClient, int nPort, boolean bUseIn, boolean bUseOut) {
        super(info, bUseIn, bUseOut);
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.<init>(): begin");
        }
        this.m_nPhysicalClient = nClient;
        this.m_nPhysicalPort = nPort;
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.<init>(): end");
        }
    }

    protected AlsaSeq getAlsaSeq() {
        return this.m_alsaSeq;
    }

    protected int getOwnPort() {
        return this.m_nOwnPort;
    }

    protected int getPhysicalClient() {
        return this.m_nPhysicalClient;
    }

    protected int getPhysicalPort() {
        return this.m_nPhysicalPort;
    }

    private AlsaSeqQueueStatus getQueueStatus() {
        return this.m_queueStatus;
    }

    protected void openImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.openImpl(): begin");
        }
        this.m_alsaSeq = new AlsaSeq("Tritonus Midi port handler");
        this.m_nOwnPort = this.getAlsaSeq().createPort("handler port", 99, 0, 0x100000, 0, 0, 0);
        if (this.getUseTransmitter()) {
            this.m_nTimestampingQueue = this.getAlsaSeq().allocQueue();
            this.m_queueStatus = new AlsaSeqQueueStatus();
            this.startQueue();
            this.m_alsaMidiIn = new AlsaMidiIn(this.getAlsaSeq(), this.getOwnPort(), this.getPhysicalClient(), this.getPhysicalPort(), this.getTimestampingQueue(), true, this);
            this.m_alsaMidiIn.start();
        }
        if (this.getUseReceiver()) {
            this.m_alsaMidiOut = new AlsaMidiOut(this.getAlsaSeq(), this.getOwnPort());
            AlsaSeqPortSubscribe portSubscribe = new AlsaSeqPortSubscribe();
            portSubscribe.setSender(this.getAlsaSeq().getClientId(), this.getOwnPort());
            portSubscribe.setDest(this.getPhysicalClient(), this.getPhysicalPort());
            this.getAlsaSeq().subscribePort(portSubscribe);
            portSubscribe.free();
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.openImpl(): end");
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.closeImpl(): begin");
        }
        if (this.getUseTransmitter()) {
            this.m_alsaMidiIn.interrupt();
            this.m_alsaMidiIn = null;
            this.stopQueue();
            this.m_queueStatus.free();
            this.m_queueStatus = null;
        }
        this.getAlsaSeq().close();
        this.m_alsaSeq = null;
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.closeImpl(): end");
        }
    }

    public long getMicroSecondPosition() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.getMicroSecondPosition(): begin");
        }
        long lPosition = 0L;
        if (this.m_queueStatus != null) {
            this.getAlsaSeq().getQueueStatus(this.getTimestampingQueue(), this.getQueueStatus());
            long lNanoSeconds = this.getQueueStatus().getRealTime();
            lPosition = lNanoSeconds / 1000L;
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.getMicroSecondPosition(): end");
        }
        return lPosition;
    }

    private void startQueue() {
        this.controlQueue(30);
    }

    private void stopQueue() {
        this.controlQueue(32);
    }

    private void controlQueue(int nType) {
        this.m_event.setCommon(nType, 3, 0, 253, 0L, 0, this.getOwnPort(), 0, 0);
        this.m_event.setQueueControl(this.getTimestampingQueue(), 0, 0L);
        this.getAlsaSeq().eventOutputDirect(this.m_event);
    }

    protected void receive(MidiMessage message, long lTimeStamp) {
        if (this.isOpen()) {
            this.m_alsaMidiOut.enqueueMessage(message, lTimeStamp);
        }
    }

    public void dequeueEvent(MidiMessage message, long lTimestamp) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.dequeueEvent(): message: " + message);
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.dequeueEvent(): tick: " + lTimestamp);
        }
        this.sendImpl(message, lTimestamp);
    }

    private int getTimestampingQueue() {
        return this.m_nTimestampingQueue;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        if (!this.getUseReceiver()) {
            throw new MidiUnavailableException("Receivers are not supported by this device");
        }
        return new AlsaMidiDeviceReceiver();
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        if (!this.getUseTransmitter()) {
            throw new MidiUnavailableException("Transmitters are not supported by this device");
        }
        return new AlsaMidiDeviceTransmitter();
    }

    private class AlsaMidiDeviceTransmitter
    extends TMidiDevice.TTransmitter {
        private boolean m_bReceiverSubscribed;

        public AlsaMidiDeviceTransmitter() {
            super(AlsaMidiDevice.this);
            this.m_bReceiverSubscribed = false;
        }

        public void setReceiver(Receiver receiver) {
            super.setReceiver(receiver);
            if (receiver instanceof AlsaReceiver) {
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaMidiDevice.this.getPhysicalClient(), AlsaMidiDevice.this.getPhysicalPort());
            }
        }

        public void send(MidiMessage message, long lTimeStamp) {
            if (!this.m_bReceiverSubscribed) {
                super.send(message, lTimeStamp);
            }
        }

        public void close() {
            super.close();
        }
    }

    private class AlsaMidiDeviceReceiver
    extends TMidiDevice.TReceiver
    implements AlsaReceiver {
        public AlsaMidiDeviceReceiver() {
            super(AlsaMidiDevice.this);
        }

        public boolean subscribeTo(int nClient, int nPort) {
            try {
                AlsaSeqPortSubscribe portSubscribe = new AlsaSeqPortSubscribe();
                portSubscribe.setSender(nClient, nPort);
                portSubscribe.setDest(AlsaMidiDevice.this.getPhysicalClient(), AlsaMidiDevice.this.getPhysicalPort());
                AlsaMidiDevice.this.getAlsaSeq().subscribePort(portSubscribe);
                portSubscribe.free();
                return true;
            }
            catch (RuntimeException e) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                return false;
            }
        }
    }
}

