/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Buffer;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis.VorbisConstants;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;

public class StaticCodebook
implements VorbisConstants {
    private int m_nDimensions;
    private int m_nEntries;
    private int[] m_anLengths;
    private int m_nMaptype;
    private int m_nQMin;
    private int m_nQDelta;
    private int m_nQQuant;
    private int m_nQSequencep;
    private int[] m_anQuants;

    public StaticCodebook() {
        if (TDebug.TraceVorbisNative) {
            TDebug.out("StaticCodebook.<init>(): begin");
        }
        if (TDebug.TraceVorbisNative) {
            TDebug.out("StaticCodebook.<init>(): end");
        }
    }

    public void clear() {
        this.m_nDimensions = 0;
        this.m_nEntries = 0;
        this.m_anLengths = null;
        this.m_nMaptype = 0;
        this.m_nQMin = 0;
        this.m_nQDelta = 0;
        this.m_nQQuant = 0;
        this.m_nQSequencep = 0;
        this.m_anQuants = null;
    }

    public void init() {
    }

    public int pack(Buffer buffer) {
        return 0;
    }

    public int unpack(Buffer buffer) {
        int i;
        int nMagic = buffer.read(24);
        if (nMagic != 5653314) {
            this.clear();
            return -1;
        }
        this.m_nDimensions = buffer.read(16);
        this.m_nEntries = buffer.read(24);
        if (this.m_nEntries == -1) {
            this.clear();
            return -1;
        }
        this.m_anLengths = new int[this.m_nEntries];
        if (!buffer.readFlag()) {
            int nLength;
            int i2;
            if (buffer.readFlag()) {
                for (i2 = 0; i2 < this.m_nEntries; ++i2) {
                    if (buffer.readFlag()) {
                        nLength = buffer.read(5);
                        if (nLength == -1) {
                            this.clear();
                            return -1;
                        }
                        this.m_anLengths[i2] = nLength + 1;
                        continue;
                    }
                    this.m_anLengths[i2] = 0;
                }
            } else {
                for (i2 = 0; i2 < this.m_nEntries; ++i2) {
                    nLength = buffer.read(5);
                    if (nLength == -1) {
                        this.clear();
                        return -1;
                    }
                    this.m_anLengths[i2] = nLength + 1;
                }
            }
        } else {
            int nLength = buffer.read(5) + 1;
            i = 0;
            while (i < this.m_nEntries) {
                int nCount = buffer.read(StaticCodebook.ilog(this.m_nEntries - i));
                if (nCount == -1) {
                    this.clear();
                    return -1;
                }
                int j = 0;
                while (j < nCount) {
                    this.m_anLengths[i] = nLength;
                    ++j;
                    ++i;
                }
                ++nLength;
            }
        }
        this.m_nMaptype = buffer.read(4);
        if (this.m_nMaptype == 1 || this.m_nMaptype == 2) {
            this.m_nQMin = buffer.read(32);
            this.m_nQDelta = buffer.read(32);
            this.m_nQQuant = buffer.read(4) + 1;
            this.m_nQSequencep = buffer.read(1);
            int nQuantVals = 0;
            if (this.m_nMaptype == 1) {
                nQuantVals = this.calculateMaptype1Quantvals();
            } else if (this.m_nMaptype == 2) {
                nQuantVals = this.m_nEntries * this.m_nDimensions;
            }
            this.m_anQuants = new int[nQuantVals];
            for (i = 0; i < nQuantVals; ++i) {
                this.m_anQuants[i] = buffer.read(this.m_nQQuant);
            }
            if (nQuantVals != 0 && this.m_anQuants[nQuantVals - 1] == -1) {
                this.clear();
                return -1;
            }
        } else if (this.m_nMaptype > 2) {
            this.clear();
            return -1;
        }
        return 0;
    }

    private int calculateMaptype1Quantvals() {
        int vals = (int)Math.floor(Math.pow(this.m_nEntries, 1.0f / (float)this.m_nDimensions));
        while (true) {
            int acc = 1;
            int acc1 = 1;
            for (int i = 0; i < this.m_nDimensions; ++i) {
                acc *= vals;
                acc1 *= vals + 1;
            }
            if (acc <= this.m_nEntries && acc1 > this.m_nEntries) {
                return vals;
            }
            if (acc > this.m_nEntries) {
                --vals;
                continue;
            }
            ++vals;
        }
    }

    private static int ilog(int v) {
        int ret = 0;
        while (v != 0) {
            ++ret;
            v >>= 1;
        }
        return ret;
    }
}

