/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis;

import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Buffer;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Ogg;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pogg.Packet;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis.Comment;
import io.github.maki99999.biomebeats.org.tritonus.lowlevel.pvorbis.VorbisConstants;
import io.github.maki99999.biomebeats.org.tritonus.share.TDebug;

public class Info
implements VorbisConstants {
    private long m_lNativeHandle;
    private int m_nVersion;
    private int m_nChannels;
    private int m_nRate;
    private int m_nBitrateUpper;
    private int m_nBitrateNominal;
    private int m_nBitrateLower;

    public Info() {
        int nReturn;
        if (TDebug.TraceVorbisNative) {
            TDebug.out("Info.<init>(): begin");
        }
        if ((nReturn = this.malloc()) < 0) {
            throw new RuntimeException("malloc of vorbis_info failed");
        }
        if (TDebug.TraceVorbisNative) {
            TDebug.out("Info.<init>(): end");
        }
    }

    public void finalize() {
    }

    private native int malloc();

    public native void free();

    public void init() {
        this.m_nVersion = 0;
        this.m_nChannels = 0;
        this.m_nRate = 0;
        this.m_nBitrateUpper = 0;
        this.m_nBitrateNominal = 0;
        this.m_nBitrateLower = 0;
        this.init_native();
    }

    public native void init_native();

    public void clear() {
        this.m_nVersion = 0;
        this.m_nChannels = 0;
        this.m_nRate = 0;
        this.m_nBitrateUpper = 0;
        this.m_nBitrateNominal = 0;
        this.m_nBitrateLower = 0;
        this.clear_native();
    }

    public native void clear_native();

    public int getVersion() {
        return this.getVersion_native();
    }

    private native int getVersion_native();

    public void setValues(int nVersion, int nChannels, int nRate, int nBitrateUpper, int nBitrateNominal, int nBitrateLower, int nBlocksize0, int nBlocksize1) {
        this.m_nVersion = nVersion;
        this.m_nChannels = nChannels;
        this.m_nRate = nRate;
        this.m_nBitrateUpper = nBitrateUpper;
        this.m_nBitrateNominal = nBitrateNominal;
        this.m_nBitrateLower = nBitrateLower;
        this.setValues_native(nVersion, nChannels, nRate, nBitrateUpper, nBitrateNominal, nBitrateLower, nBlocksize0, nBlocksize1);
    }

    private native void setValues_native(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public int getBlocksize0() {
        return this.getBlocksize_native(0);
    }

    public int getBlocksize1() {
        return this.getBlocksize_native(1);
    }

    private native int getBlocksize_native(int var1);

    public int getChannels() {
        return this.getChannels_native();
    }

    private native int getChannels_native();

    public int getRate() {
        return this.getRate_native();
    }

    private native int getRate_native();

    public int getBitrateUpper() {
        return this.getBitrateUpper_native();
    }

    private native int getBitrateUpper_native();

    public int getBitrateNominal() {
        return this.getBitrateNominal_native();
    }

    private native int getBitrateNominal_native();

    public int getBitrateLower() {
        return this.getBitrateLower_native();
    }

    private native int getBitrateLower_native();

    public int encodeInit(int nChannels, int nRate, int nMaxBitrate, int nNominalBitrate, int nMinBitrate) {
        return this.encodeInit_native(nChannels, nRate, nMaxBitrate, nNominalBitrate, nMinBitrate);
    }

    private native int encodeInit_native(int var1, int var2, int var3, int var4, int var5);

    public int encodeInitVBR(int nChannels, int nRate, float fQuality) {
        return this.encodeInitVBR_native(nChannels, nRate, fQuality);
    }

    private native int encodeInitVBR_native(int var1, int var2, float var3);

    public int headerIn(Comment comment, Packet packet) {
        if (packet == null) {
            return -133;
        }
        Buffer buffer = new Buffer();
        byte[] abData = packet.getData();
        buffer.readInit(abData, abData.length);
        int packtype = buffer.read(8);
        String s = buffer.readString(6);
        if (!"vorbis".equals(s)) {
            buffer.free();
            return -132;
        }
        switch (packtype) {
            case 1: {
                if (!packet.isBos()) {
                    buffer.free();
                    return -133;
                }
                if (this.getRate() != 0) {
                    buffer.free();
                    return -133;
                }
                int r = this.unpack(buffer);
                buffer.free();
                return r;
            }
            case 3: {
                if (this.getRate() == 0) {
                    buffer.free();
                    return -133;
                }
                int r = comment.unpack(buffer);
                buffer.free();
                return r;
            }
            case 5: {
                if (this.getRate() == 0 || comment.getVendor() == null) {
                    buffer.free();
                    return -133;
                }
                int r = this.headerIn_native(buffer, packtype, packet);
                buffer.free();
                return r;
            }
        }
        buffer.free();
        return -133;
    }

    private native int headerIn_native(Buffer var1, int var2, Packet var3);

    public int pack(Buffer buffer) {
        buffer.write(1, 8);
        buffer.write("vorbis");
        buffer.write(0, 32);
        buffer.write(this.getChannels(), 8);
        buffer.write(this.getRate(), 32);
        buffer.write(this.getBitrateUpper(), 32);
        buffer.write(this.getBitrateNominal(), 32);
        buffer.write(this.getBitrateLower(), 32);
        buffer.write(Info.ilog2(this.getBlocksize0()), 4);
        buffer.write(Info.ilog2(this.getBlocksize1()), 4);
        buffer.write(1, 1);
        return 0;
    }

    public int unpack(Buffer buffer) {
        int nVersion = buffer.read(32);
        if (nVersion != 0) {
            return -134;
        }
        int nChannels = buffer.read(8);
        int nRate = buffer.read(32);
        int nBitrateUpper = buffer.read(32);
        int nBitrateNominal = buffer.read(32);
        int nBitrateLower = buffer.read(32);
        int nBlocksize0 = 1 << buffer.read(4);
        int nBlocksize1 = 1 << buffer.read(4);
        if (nChannels < 1 || nRate < 1 || nBlocksize0 < 8 || nBlocksize1 < nBlocksize0) {
            this.clear();
            return -133;
        }
        if (buffer.read(1) != 1) {
            this.clear();
            return -133;
        }
        this.setValues(nVersion, nChannels, nRate, nBitrateUpper, nBitrateNominal, nBitrateLower, nBlocksize0, nBlocksize1);
        return 0;
    }

    private static native void setTrace(boolean var0);

    private static int ilog2(int v) {
        int ret = 0;
        if (v != 0) {
            --v;
        }
        while (v != 0) {
            ++ret;
            v >>= 1;
        }
        return ret;
    }

    static {
        Ogg.loadNativeLibrary();
        if (TDebug.TraceVorbisNative) {
            Info.setTrace(true);
        }
    }
}

